﻿import mx.controls.Button;
import mx.controls.Label;
import mx.controls.ComboBox;
import mx.utils.Delegate;

class NetState {
	var pads:Array;
	var SIZE:Number = 30;
	var TOP:Number = 35;
	var LEFT:Number = 35;
	static var squares:Array;
	static var turns:Array;
	static var turnStack:Array;
		
	function NetState() {
		pads = [];
		squares = [];
		turnStack = [];
		for(var i:Number=0; i < 9; i++) {
			var row:Array = [];
			for(var j:Number=0; j < 12; j++) {
				trace("("+i+","+j+")");
				if((i < 3 || i > 5) && (j < 3 || j > 5))
					continue;
				row[j] = _root.attachMovie("Pad", "pad"+i*12+j, i*12+j, {_x:LEFT + j*SIZE, _y: TOP+ i*SIZE});
			}
			pads[i] = row;
		}
		
		turns = [redCycle, whiteCycle, blueCycle,
				 greenCycle, yellowCycle, purpleCycle];
		
		Pad(pads[0][3]).setup("YellowFace", 37, "corner");
		Pad(pads[0][4]).setup("YellowFace", 38, "edge");
		Pad(pads[0][5]).setup("YellowFace", 39, "corner");
		Pad(pads[1][3]).setup("YellowFace", 40, "edge");
		pads[1][4].setup("YellowButton", 41, "middle", this, yellowCycle);
		Pad(pads[1][5]).setup("YellowFace", 42, "edge");
		Pad(pads[2][3]).setup("YellowFace", 43, "corner");
		Pad(pads[2][4]).setup("YellowFace", 44, "edge");
		Pad(pads[2][5]).setup("YellowFace", 45, "corner");

		Pad(pads[3][0]).setup("BlueFace", 28, "corner");
		Pad(pads[3][1]).setup("BlueFace", 29, "edge");
		Pad(pads[3][2]).setup("BlueFace", 30, "corner");
		Pad(pads[4][0]).setup("BlueFace", 31, "edge");
		pads[4][1].setup("BlueButton", 32, "middle", this, blueCycle);
		Pad(pads[4][2]).setup("BlueFace", 33, "edge");
		Pad(pads[5][0]).setup("BlueFace", 34, "corner");
		Pad(pads[5][1]).setup("BlueFace", 35, "edge");
		Pad(pads[5][2]).setup("BlueFace", 36, "corner");

		Pad(pads[3][3]).setup("WhiteFace", 1, "corner");
		Pad(pads[3][4]).setup("WhiteFace", 2, "edge");
		Pad(pads[3][5]).setup("WhiteFace", 3, "corner");
		Pad(pads[4][3]).setup("WhiteFace", 4, "edge");
		pads[4][4].setup("WhiteButton", 5, "middle", this, whiteCycle);
		Pad(pads[4][5]).setup("WhiteFace", 6, "edge");
		Pad(pads[5][3]).setup("WhiteFace", 7, "corner");
		Pad(pads[5][4]).setup("WhiteFace", 8, "edge");
		Pad(pads[5][5]).setup("WhiteFace", 9, "corner");

		Pad(pads[3][6]).setup("RedFace", 10, "corner");
		Pad(pads[3][7]).setup("RedFace", 11, "edge");
		Pad(pads[3][8]).setup("RedFace", 12, "corner");
		Pad(pads[4][6]).setup("RedFace", 13, "edge");
		pads[4][7].setup("RedButton", 14, "middle", this, redCycle);
		Pad(pads[4][8]).setup("RedFace", 15, "edge");
		Pad(pads[5][6]).setup("RedFace", 16, "corner");
		Pad(pads[5][7]).setup("RedFace", 17, "edge");
		Pad(pads[5][8]).setup("RedFace", 18, "corner");

		Pad(pads[3][9]).setup("GreenFace", 19, "corner");
		Pad(pads[3][10]).setup("GreenFace", 20, "edge");
		Pad(pads[3][11]).setup("GreenFace", 21, "corner");
		Pad(pads[4][9]).setup("GreenFace", 22, "edge");
		pads[4][10].setup("GreenButton", 23, "middle", this, greenCycle);
		Pad(pads[4][11]).setup("GreenFace", 24, "edge");
		Pad(pads[5][9]).setup("GreenFace", 25, "corner");
		Pad(pads[5][10]).setup("GreenFace", 26, "edge");
		Pad(pads[5][11]).setup("GreenFace", 27, "corner");

		Pad(pads[6][3]).setup("PurpleFace", 46, "corner");
		Pad(pads[6][4]).setup("PurpleFace", 47, "edge");
		Pad(pads[6][5]).setup("PurpleFace", 48, "corner");
		Pad(pads[7][3]).setup("PurpleFace", 49, "edge");
		pads[7][4].setup("PurpleButton", 50, "middle", this, purpleCycle);
		Pad(pads[7][5]).setup("PurpleFace", 51, "edge");
		Pad(pads[8][3]).setup("PurpleFace", 52, "corner");
		Pad(pads[8][4]).setup("PurpleFace", 53, "edge");
		Pad(pads[8][5]).setup("PurpleFace", 54, "corner");

		/* Add actions to buttons */
		addAction("reset", click);
		addAction("scramble", click);
		addAction("lastScramble", click);
		addAction("undo", click);
		addAction("record", click);
		addAction("a", click);
		addAction("b", click);
		addAction("c", click);
		addAction("d", click);
		addAction("e", click);
		addAction("f", click);
		addAction("g", click);
		addAction("h", click);

		Label(_root.recorder).setStyle("color", 0xffffff);
		Label(_root.moves).setStyle("color", 0xffffff);
		Label(_root.by).setStyle("color", 0xffffff);
		
		enableSoftButtons(false);
		
	}
	
	function addAction(name:String, action:Function):Void {
		_root[name].addEventListener("click", Delegate.create(this, action));
	}
		
	function click(evt:Object):Void {
		// switch on the instance name of the target button
		switch(evt.target._name) {
			case "reset":
			    reset();
				break;
			case "scramble":
				scramble(_root.scrambleCount.value);
				break;
			case "lastScramble":
				lastScramble();
				break;
			case "undo":
				undo();
				break;
			case "record":
				record(evt);
				break;
			case "a":
			case "b":
			case "c":
			case "d":
			case "e":
			case "f":
			case "g":
			case "h":
				replayRecord(evt.target._name);
				break;
			default:
				trace("Unknown button: " + evt.target._name);
		}
	}
	
	function reset():Void {
		for(var i:Number = 0; i < squares.length; i++) {
			var p:Pad = padId(i);
			p.reset();
		}
		turnStack = [];
		recording = null;
		visibleSoftButtons(true);
	}
	
	function log(name:String, turn:Function):Void {
		turnStack.push({name:name, turn:turn});
		if(recording != null) {
			addCommand(name, turn);
		}
	}
	
	function undo():Void {
		var t:Object = turnStack.pop();
		if(t != null) {
			var f:Function = Function(t.turn);
			f.call(this, false);
			f.call(this, false);
			f.call(this, false);
		}
	}
	
	var scrambleTurns:Array;
	function scramble(n:Number):Void {
		reset();
		scrambleTurns = [];
		for(var i:Number = 0; i < n; i++) {
			var k:Number = Math.floor(Math.random()*turns.length);
			var turn:Function = turns[k < turns.length ? k : turns.length-1];
			turn.call(this, true);
			scrambleTurns.push(turn);
		}
	}

	function lastScramble():Void {
		reset();
		for(var i:Number = 0; i < scrambleTurns.length; i++) {
			var turn = Function(scrambleTurns[i]);
			turn.call(this, true);
		}
	}
	
	static var recording:Array;
	function record(evt:Object):Void {
		var b:Button = evt.target;
		var combo:ComboBox = _root.combo;
		if(recording == null) {
			recording = [];
			b.selected = false;
			b.label = "Stop and Save";
			visibleSoftButtons(false);
		}
		else {
			b.selected = true;
			b.label = "Start";
			trace(combo.selectedItem);
			combo.selectedItem.data = recording;
			recording = null;
			_root["abcdefgh".charAt(combo.selectedIndex)].enabled = true;
			visibleSoftButtons(true);
			//_root["abcdefgh".charAt(combo.selectedIndex)].enabled = true;
		}
	}
	
	function addCommand(name:String, turn:Function):Void {
		recording.push({name:name, turn:turn});
	}
	
	function replayRecord(name:String):Void {
		var combo:ComboBox = _root.combo;
		var item:Object = combo.getItemAt(name.charCodeAt(0)-"a".charCodeAt(0));
		var recording:Array = item.data;
		for(var i:Number = 0; i < recording.length; i++) {
			var f:Function = recording[i].turn;
			trace(recording[i].name);
			//trace("SIZE="+SIZE + " f="+f);
			//greenCycle(true);
			f.call(this,true);
		}
	}
	
	function enableSoftButtons(b:Boolean):Void {
		_root.a.enabled = b;
		_root.b.enabled = b;
		_root.c.enabled = b;
		_root.d.enabled = b;
		_root.e.enabled = b;
		_root.f.enabled = b;
		_root.g.enabled = b;
		_root.h.enabled = b;
	}
	
	function visibleSoftButtons(b:Boolean):Void {
		_root.a.visible = b;
		_root.b.visible = b;
		_root.c.visible = b;
		_root.d.visible = b;
		_root.e.visible = b;
		_root.f.visible = b;
		_root.g.visible = b;
		_root.h.visible = b;
		_root.a._alpha = _root.a.enabled ? 100 : 20;
		_root.b._alpha = _root.b.enabled ? 100 : 20;
		_root.c._alpha = _root.c.enabled ? 100 : 20;
		_root.d._alpha = _root.d.enabled ? 100 : 20;
		_root.e._alpha = _root.e.enabled ? 100 : 20;
		_root.f._alpha = _root.f.enabled ? 100 : 20;
		_root.g._alpha = _root.g.enabled ? 100 : 20;
		_root.h._alpha = _root.h.enabled ? 100 : 20;
	}
	//
	// the turns
	//
	function greenCycle(save:Boolean):Void {
		if(save) log("G", greenCycle);
		cycle(false, 37, 38, 39, 12, 15, 18, 54, 53, 52, 34, 31, 28);
		cycleFace(true, 19, 20, 21, 24, 27, 26, 25, 22);
	}

	function yellowCycle(save:Boolean):Void {
		if(save) log("Y", yellowCycle);
		 cycle(false, 1, 2, 3, 10, 11, 12, 19, 20, 21, 28, 29, 30);		
		 cycleFace(true, 37, 38, 39, 42, 45, 44, 43, 40);
	}
	
	function blueCycle(save:Boolean):Void {
		if(save) log("B", blueCycle);
		 cycle(false, 7, 4, 1, 43, 40, 37, 21, 24, 27, 52, 49, 46);
		 cycleFace(true, 30, 33, 36, 35, 34, 31, 28, 29);
	}
	
	function redCycle(save:Boolean):Void {
		if(save) log("R", redCycle);
		 cycle(true, 9, 6, 3, 45, 42, 39, 19, 22, 25, 54, 51, 48);
		 cycleFace(true, 10, 11, 12, 15, 18, 17, 16, 13);		
	}
	
	function whiteCycle(save:Boolean):Void {
		if(save) log("W", whiteCycle);
		 cycle(true, 10, 13, 16, 48, 47, 46, 36, 33, 30, 43, 44, 45);
		 cycleFace(true, 1, 2, 3, 6, 9, 8, 7, 4);		
	}
	
	function purpleCycle(save:Boolean):Void {
		if(save) log("P", purpleCycle);
		 cycle(true, 7, 8, 9, 16, 17, 18, 25, 26, 27, 34, 35, 36);
		 cycleFace(true, 46, 47, 48, 51, 54, 53, 52, 49);		
	}
	
	function cycle(clockwise:Boolean, a:Number, b:Number, c:Number, d:Number, e:Number, f:Number, g:Number, h:Number, i:Number, j:Number, k:Number, l:Number):Void {
		var A:Pad = padId(a);
		var B:Pad = padId(b);
		var C:Pad = padId(c);
		var D:Pad = padId(d);
		var E:Pad = padId(e);
		var F:Pad = padId(f);
		var G:Pad = padId(g);
		var H:Pad = padId(h);
		var I:Pad = padId(i);
		var J:Pad = padId(j);
		var K:Pad = padId(k);
		var L:Pad = padId(l);
		
		if(clockwise) {
			var t1:Face = A.face;
			A.face = D.face;
			D.face = G.face;
			G.face = J.face;
			J.face = t1;
			
			var t2:Face = B.face;
			B.face = E.face;
			E.face = H.face;
			H.face = K.face;
			K.face = t2;
			
			var t3:Face = C.face;
			C.face = F.face;
			F.face = I.face;
			I.face = L.face;
			L.face = t3;
		}
		else {
			
			var t1:Face = J.face;
			J.face = G.face;
			G.face = D.face;
			D.face = A.face;
			A.face = t1;
			
			var t2:Face = K.face;
			K.face = H.face;
			H.face = E.face;
			E.face = B.face;
			B.face = t2;
			
			var t3:Face = L.face;
			L.face = I.face;
			I.face = F.face;
			F.face = C.face;
			C.face = t3;			
		}
	}

	function cycleFace(clockwise:Boolean, a:Number, b:Number, c:Number, d:Number, e:Number, f:Number, g:Number, h:Number):Void {

		var A:Pad = padId(a);
		var B:Pad = padId(b);
		var C:Pad = padId(c);
		var D:Pad = padId(d);
		var E:Pad = padId(e);
		var F:Pad = padId(f);
		var G:Pad = padId(g);
		var H:Pad = padId(h);
		
		if(clockwise) {
			var t1:Face = A.face;
			A.face = C.face;
			C.face = E.face;
			E.face = G.face;
			G.face = t1;
			
			var t2:Face = B.face;
			B.face = D.face;
			D.face = F.face;
			F.face = H.face;
			H.face = t2;
		}
		else {
			var t1:Face = G.face;
			G.face = E.face;
			E.face = C.face;
			C.face = A.face;
			A.face = t1;
			
			var t2:Face = H.face;
			H.face = F.face;
			F.face = D.face;
			D.face = B.face;
			B.face = t2;
		}
	}


	function padId(n:Number):Pad {
		return Pad(squares[n]);
	}
	
	static function blackened():Boolean {
		for(var i = 0; i < Pad.allPads.length; i++) {
			var p:Pad = Pad(Pad.allPads[i]);
			if(p.black._visible)
				return true;
		}
		return false;
	}
	
	static function faceBlacken(type:String):Void {
		for(var i = 0; i < Pad.allPads.length; i++) {
			var p:Pad = Pad(Pad.allPads[i]);
			if(p.type == type) {
				p.black._visible = !p.black._visible;
			}
		}
	}
}