﻿class Grid extends MovieClip {
	var _xSquares = 10;
	var _ySquares = 10;
	var _squareSize = 20;
	var _lineThickness = 1;
	var _lineColour = 0xFFFFFF;
	var _lineAlpha = 30;
	var _oij:Object;
	var _oxy:Object;
	var _grid:MovieClip;
	var _gridBack:MovieClip;
	var _axes:MovieClip;
	var depth = 0;
	function init(oij:Object, xSquares:Number, ySquares:Number, squareSize:Number) {
		_xSquares = xSquares;
		_ySquares = ySquares;
		_squareSize = squareSize;
		_oij = oij;
		_oxy = ij2xy(oij);
	}
	//
	// Coordinate transforms:
	//	i,j are integer square count coords with origin bottom left of grid
	//  m,n are integer square count coords with origin at _oij
	//  x,y are pixel coordinates relative to grid top-left origin.
	//
	function ij2xy(ij:Object):Object {
		return {x:ij.i*_squareSize, y:(_ySquares-ij.j)*_squareSize};
	}
	function mn2xy(mn:Object):Object {
		return {x:(_oij.i+mn.m)*_squareSize, y:(-_oij.j+_ySquares-mn.n)*_squareSize};
	}
	function xy2mn(xy:Object):Object {
		var m = -_oij.i+Math.round(xy.x/_squareSize);
		var n = -_oij.j+_ySquares-Math.round(xy.y/_squareSize);
		return {m:m, n:n};
	}
	function xy2ij(xy:Object):Object {
		var i = Math.round(xy.x/_squareSize);
		var j = _ySquares-Math.round(xy.y/_squareSize);
		return {i:i, j:j};
	}
	function mn2ij(mn:Object):Object {
		return {i:mn.m+_oij.i, j:mn.n+_oij.j};
	}
	function ij2mn(ij:Object):Object {
		return {m:ij.i-_oij.i, n:ij.j-_oij.j};
	}
	function get width():Number {
		return _xSquares*_squareSize;
	}
	function get height():Number {
		return _ySquares*_squareSize;
	}
	function setLineStyle(i:Number) {
		if ((i)%10 == 0) {
			_grid.lineStyle(_lineThickness*3, _lineColour, _lineAlpha);
		} else if (i%5 == 0) {
			_grid.lineStyle(_lineThickness*2, _lineColour, _lineAlpha);
		} else {
			_grid.lineStyle(_lineThickness, _lineColour, _lineAlpha);
		}
	}
	function draw() {
		_gridBack = attachMovie("GridBack", "gridBack", ++depth);
		_gridBack._width = width;
		_gridBack._height = height;
		_gridBack._x = _oxy.x-width/2;
		_gridBack._y = _oxy.y-height/2;
		_grid = createEmptyMovieClip("grid", ++depth);
		_grid._x = 0;
		//_oxy.x;
		_grid._y = 0;
		//_oxy.y;
		_grid.lineStyle(_lineThickness, _lineColour, _lineAlpha);
		for (var i = 0; i<=_ySquares; i++) {
			setLineStyle(_oij.i-i);
			var xy0:Object = ij2xy({i:0, j:i});
			_grid.moveTo(xy0.x, xy0.y);
			var xy1:Object = ij2xy({i:_xSquares, j:i});
			_grid.lineTo(xy1.x, xy1.y);
		}
		for (var i = 0; i<=_xSquares; i++) {
			setLineStyle(_oij.j-i);
			var xy0:Object = ij2xy({i:i, j:0});
			_grid.moveTo(xy0.x, xy0.y);
			var xy1:Object = ij2xy({i:i, j:_ySquares});
			_grid.lineTo(xy1.x, xy1.y);
		}
		_axes = attachMovie("Axes", "axes", ++depth);
		_axes._x = _oxy.x;
		_axes._y = _oxy.y;
	}
	function clear():Void {
		depth = 0;
		_grid.removeMovieClip();
		_gridBack.removeMovieClip();
		_axes.removeMovieClip();
	}
	function ijHash(ij:Object):String {
		return "("+ij.i+","+ij.j+")";
	}
	function mnHash(mn:Object):String {
		var ij:Object = mn2ij(mn);
		return ijHash(ij);
	}
	function drawLineSegment(style:Object, mn1:Object, mn2:Object) {
		var layer = createEmptyMovieClip("line", ++depth);
		var xy1 = mn2xy(mn1);
		var xy2 = mn2xy(mn2);
		layer.lineStyle(style.thickness, style.rgb, style.alpha);
		layer.moveTo(xy1.x, xy1.y);
		layer.lineTo(xy2.x, xy2.y);
	}
}
