﻿class EquationDisplayer extends MovieClip {
	var eqObject:EquationObject;
	var equation = "";
	var depth = 1;
	var symbolName = "EquationDisplayer";
	function EquationDisplayer() {
	}
	function setEquation(str) {
		eqObject = new EquationObject(str);
		equation = str;
	}
	function setEquationObject(obj) {
		eqObject = obj;
		equation = eqObject.equation;
	}
	function getEquationObject() {
		return eqObject;
	}
	function clean() {
		for (var p in this) {
			if (this[p]._parent == this) {
				this[p].removeMovieClip();
			}
		}
	}
	//######################################################
	function render() {
		clean();
		var obj = eqObject;
		var info = obj.info;
		if (info == null) {
			return;
		}
		if (info.type == "operator") {
			operatorLayout(info);
			return;
		}
		if (info.type == "function") {
			functionLayout(info);
			return;
		}
		stringLayout(info);
	}
	//#######################################################
	function lineUp() {
		//clips in arguments
		var offset = 0;
		for (var k = 0; k<arguments.length; k++) {
			var clip = arguments[k];
			var b = clip.getBounds(clip._parent);
			clip._x += offset-b.xMin;
			offset += clip._width;
		}
	}
	//#########################################################
	function operatorLayout(info) {
		var hiddenMultiplier = "\u0012";
		var operatorChar = info.typeData;
		var childObjects = info.childObjects;
		var clip1 = attachMovie(symbolName, "p"+depth, depth++);
		clip1.setEquationObject(childObjects[0]);
		clip1.render();
		var clip2 = attachMovie(symbolName, "p"+depth, depth++);
		clip2.setEquationObject(childObjects[1]);
		clip2.render();
		//------------------------
		if (operatorChar == "^") {
			var b = clip1.getBounds(this);
			clip2._y = b.yMin+5;
			clip2._xscale = clip2._yscale=60;
			lineUp(clip1, clip2);
			return;
		}
		if (operatorChar == "/") {
			var w = Math.max(clip1._width, clip2._width);
			var b1 = clip1.getBounds(this);
			var b2 = clip2.getBounds(this);
			var line = attachMovie("divideX", "p"+depth, depth++); 
			var w = line._width=w+6;
			clip1._y += b1.yMin;
			clip1._x += (w/2-(b1.xMax+b1.xMin)/2);
			clip2._y += b2.yMax+3;
			clip2._x += (w/2-(b2.xMax+b2.xMin)/2);
			return;
		}
		//others
		if (operatorChar == "*") {
			var opClip = attachMovie("multiply", "p"+depth, depth++);
		} else if (operatorChar == hiddenMultiplier) {
			var opClip = createEmptyMovieClip("p"+depth, depth++);
		} else {
			//var opClip = attachMovie("char", "p"+depth, depth++, {label:operatorChar});
			var opClip = attachMovie("char", "p"+depth, depth++);
			opClip.txt.text = operatorChar;
			opClip.txt.autoSize = true;
		}
		lineUp(clip1, opClip, clip2);
	}
	//#####################################################
	function functionLayout(info) {
		var functionName = info.typeData;
		var childObjects = info.childObjects;
		var clipArray = [];
		for (var i = 0; i<childObjects.length; i++) {
			var clip = clipArray[i]=attachMovie(symbolName, "p"+depth, depth++);
			clip.setEquationObject(childObjects[i]);
			clip.render();
		}
		//-----------------------
		if (functionName == "sqrt") {
			var line = attachMovie("sqrtLine", "p"+depth, depth++);
			var hook = attachMovie("sqrtHook", "p"+depth, depth++);
			var clip = clipArray[0];
			var b = clip.getBounds(this);
			clip._y -= (b.yMin+b.yMax)/2;
			clip._x = hook._width+3;
			line._x = hook._width;
			hook._height = clip._height;
			var b2 = hook.getBounds(this);
			line._y = b2.yMin;
			line._width = clip._width+6;
			return;
		}
		//-----------------------------------------------
		if (functionName == "pow") {
			var d = 2;
			var clip1 = clipArray[0];
			var clip2 = clipArray[1];
			var b = clip1.getBounds(this);
			//var offset = clip1._width;
			if (childObjects[0].info.type != "string") {
				//-------- add parenthesis to clip1 to avoid this condition: pow(3+4,2); ->2+4^2
				//var leftParen = attachMovie("char", "p"+depth, depth++, {label:"("});
				var leftParen = attachMovie("char", "p"+depth, depth++);
				leftParen.txt.text = "(";		
				leftParen.txt.autoSize = true;					   
				//var rightParen = attachMovie("char", "p"+depth, depth++, {label:")"});
				var rightParen = attachMovie("char", "p"+depth, depth++);
				rightParen.txt.text = ")";
				rightParen.txt.autoSize = true;
				lineUp(leftParen, clip1, rightParen, clip2);
				leftParen._height = rightParen._height=2*Math.max(b.yMax, -b.yMin);
			} else {
				lineUp(clip1, clip2);
			}
			clip2._y = b.yMin+5;
			clip2._xscale = clip2._yscale=60;
			return;
		}
		//------------------------------------------------
		if (functionName == "exp") {
			var clip1 = attachMovie("exp", "p"+depth, depth++);
			var clip2 = clipArray[0];
			clip2._x = clip1._width+4;
			var b = clip1.getBounds(this);
			clip2._y = b.yMin;
			clip2._xscale = clip2._yscale=60;
			return;
		}
		//--------------------------------------------------
		var d = 50;
		//var funClip = attachMovie("char", "p"+depth, depth++, {label:functionName});
		var funClip = attachMovie("char", "p"+depth, depth++);
		funClip.txt.text = functionName;
		funClip.txt.autoSize = true;
		//var leftParen = attachMovie("char", "p"+depth, depth++, {label:"("});
		var leftParen = attachMovie("char", "p"+depth, depth++);
		leftParen.txt.text = "(";
		leftParen.txt.autoSize = true;
		//var rightParen = attachMovie("char", "p"+depth, depth++, {label:")"});
		var rightParen = attachMovie("char", "p"+depth, depth++);
		rightParen.txt.text = ")";
		rightParen.txt.autoSize = true;
		var tempArray = [funClip, leftParen];
		var yMin = 0;
		var yMax = 0;
		for (var k = 0; k<clipArray.length; k++) {
			tempArray.push(clipArray[k]);
			var b = clipArray[k].getBounds(this);
			if (b.yMin<yMin) {
				yMin = b.yMin;
			}
			if (b.yMax>yMax) {
				yMax = b.yMax;
			}
			if (k<clipArray.length-1) {
				//var comaClip = attachMovie("char", "p"+depth, depth++, {label:","});
				var comaClip = attachMovie("char", "p"+depth, depth++);
				comaClip.txt.text = ",";
				comaClip.txt.autoSize = true;
				tempArray.push(comaClip);
			}
		}
		tempArray.push(rightParen);
		lineUp.apply(null, tempArray);
		rightParen._height = leftParen._height=2*Math.max(yMax, -yMin);
	}
	//#######################################################
	function stringLayout(info) {
		//trace("info="+info);
		//trace("stringData="+info.stringData);
		var str = info.typeData;
		//trace("---------------end str="+str);
		if (str == "PI" || str == "pi") {
			attachMovie("pi", "p"+depth, depth++);
			return;
		}
		//var clip = attachMovie("char", "p"+depth, depth++, {label:str});
		var clip = attachMovie("char", "p"+depth, depth++);
		clip.txt.text = str;
		clip.txt.autoSize = true;
	}
}
