﻿class DiamondLines extends MovieClip {
	var n:Number; //Number of lines which are drawn
	var nRan:Number; //Number of lines with diamonds
	var cols:Array; //Array of colours, one per line.
	//var index:Number;
	var m_num:Array;//Array of m_numerator for each line y = mx + c
	var m_den:Array; //Array of m_denominator for each line y = mx + c
	var c_num:Array;//Array of c for each line y = mx + c
	var c_den:Number; // Somebody might want to have c as a fraction one day :-)
	var m_numRan:Array;
	var m_denRan:Array;
	var cRan:Array;
	var lines:Array;
	var diamondsGrid:Array; // 24 x 24 array with 1's where diamonds are placed
	var diamonds:Array; // array containing gem's (MovieClips)
	var diamondsCollected:Array; // array containing overlay colour for gem's (MovieClips)
	var score:Number = 0;
	var computerScore:Number = 0;
	//var square_width:Number = 10; //Width of square from grid.
	var L:Number = 180;
	var dx:Number;
	var dy:Number;
	function DiamondLines() {
		initDiamonds();
		randomLines();
		attachLines();
	}
	//initialize array with coordinates, where diamonds will be placed
	function initDiamonds() {
		if (diamonds != undefined) {
			for (var i:Number = 0; i<diamonds.length; i++) {
				diamonds[i].removeMovieClip();
			}
		}
		if (diamondsCollected != undefined) {
			for (var i:Number = 0; i<diamondsCollected.length; i++) {
				diamondsCollected[i].removeMovieClip();
			}
		}
		diamonds = new Array;
		diamondsCollected = new Array;
		diamondsGrid = new Array();
		for (var i:Number = 0; i<=24; i++) {
			diamondsGrid[i] = new Array();
		}
	}
	// Creat random lines
	function randomLines() {
		var same:Boolean = true;
		// line 1
		m_numRan[0] = ranSgn()*Math.round(Math.random()*3);// 0,1,2,3
		m_denRan[0] = Math.round(Math.random()*2+1); //1,2,3
		cRan[0] = ranSgn()*Math.floor(Math.random()*8); //0, ..., 7
		simplify(0);
		// line 2
		while (same) {
			m_numRan[1] = ranSgn()*Math.round(Math.random()*2+2); //2,3,4
			m_denRan[1] =  Math.round(Math.random()*2+1); //1,2,3
			cRan[1] = ranSgn()*Math.floor(Math.random()*8); //0,...,7
			simplify(1);
			same = sameLine(1,m_numRan[1],m_denRan[1],cRan[1]);
		}
		// line 3
		same = true;
		while (same) {
			m_numRan[2] = ranSgn()*Math.round(Math.random()*4+2); //2,3,4,5,6
			m_denRan[2] = Math.round(Math.random()*3+1); //1,2,3,4
			cRan[2] = ranSgn()*Math.floor(Math.random()*10); //0,...,9
			simplify(2);
			same = sameLine(2,m_numRan[2],m_denRan[2],cRan[2]);
		}
		// lines 4, 5, 6
		for (var i:Number = 3; i < 6; i++) {
			same = true;
			while (same) {
				m_numRan[i] = ranSgn()*Math.round(Math.random()*6+2); //2,3,4,5,6,7,8
				m_denRan[i] = Math.round(Math.random()*3+2); //2,3,4,5
				cRan[i] = ranSgn()*Math.floor(Math.random()*12); //0,...,11
				simplify(i);
				same = sameLine(i,m_numRan[i],m_denRan[i],cRan[i]);
			}
		}
		findNodes();
	}
	// simplify the equation
	function simplify (ii:Number) {
		var h:Number = hcf(Math.abs(m_numRan[ii]),Math.abs(m_denRan[ii]));
		if (h > 1) {
			m_numRan[ii] /= h;
			m_denRan[ii] /= h;
		}
	}
	// check the line is unique
	function sameLine(ii:Number, m_num:Number, m_den:Number, c:Number) : Boolean {
		for (var i:Number = 0; i<ii; i++) {
			if (m_num != m_numRan[i]) {
				continue;
			}
			else if (m_den != m_denRan[i]) {
				continue;
			}
			else if (c != cRan[i]) {
				continue;
			}
			else {
				return true;
			}
		}
		return false;
	}
	// find points with integer coordinates
	function findNodes() {
		for (var i:Number = 0; i < nRan; i++) {
			trace("random line ["+i+"]: y = "+m_numRan[i]+"/"+m_denRan[i]+"x + "+cRan[i]);
			lines[i] = new Array;
			if (m_numRan[i] == 0) {
				for (var j:Number = 0; j<=24; j++) {
					lines[i][j] = {X:j-12,Y:cRan[i]};
				}
			}
			else if (m_numRan[i] > 0) {
				var j:Number = 0;
				var a:Number = 0; // x axe
				var b:Number = cRan[i]; // y axe
				while ((a<=12) && (b<=12)) {
					lines[i][j] = {X:a,Y:b};
					a += m_denRan[i];
					b += m_numRan[i];
					j ++;
				}
				a = -m_denRan[i]; b = cRan[i]-m_numRan[i];;
				while ((a>=-12) && (b>=-12)) {
					lines[i][j] = {X:a,Y:b};
					a -= m_denRan[i];
					b -= m_numRan[i];
					j ++;
				}
			}
			else {
				var j:Number = 0;
				var a:Number = 0; // x axe
				var b:Number = cRan[i]; // y axe
				while ((a<=12) && (b>=-12)) {
					lines[i][j] = {X:a,Y:b};
					a += m_denRan[i];
					b += m_numRan[i];
					j ++;
				}
				a = -m_denRan[i]; b = cRan[i]-m_numRan[i];;
				while ((a>=-12) && (b<=12)) {
					lines[i][j] = {X:a,Y:b};
					a -= m_denRan[i];
					b -= m_numRan[i];
					j ++;
				}
			}
			
		}
		points();
	}
	// chose points on lines + random points where diamonds will be dropped
	// upto 6 to 1. line, upto 5 to 2. line, upto 4 to 3. line and upto 3 to 4.-6. lines
	function points() {
		for (var i:Number = 0; i<3; i++) {
			var l:Number = lines[i].length;
			if (l > 6-i) {
				var ind:Array = randomIndex(l,6-i);
				for (var index in ind) {
					if (diamondsGrid[lines[i][ind[index]].X+12][lines[i][ind[index]].Y+12] != 1) {
						diamondsGrid[lines[i][ind[index]].X+12][lines[i][ind[index]].Y+12] = 1;
					}
				}
			}
			else {
				for (var j:Number = 0; j<l; j++) {
					if (diamondsGrid[lines[i][j].X+12][lines[i][j].Y+12] != 1) {
						diamondsGrid[lines[i][j].X+12][lines[i][j].Y+12] = 1;
					}
				}
			}
			trace("line "+i+": "+ind);
		}
		for (var i:Number = 3; i<nRan; i++) {
			l = lines[i].length;
			if (l > 3) {
				var ind:Array = randomIndex(l,3);
				for (var index in ind) {
					if (diamondsGrid[lines[i][ind[index]].X+12][lines[i][ind[index]].Y+12] != 1) {
						diamondsGrid[lines[i][ind[index]].X+12][lines[i][ind[index]].Y+12] = 1;
					}
				}
			}
			else {
				for (var j:Number = 0; j<l; j++) {
					if (diamondsGrid[lines[i][j].X+12][lines[i][j].Y+12] != 1) {
						diamondsGrid[lines[i][j].X+12][lines[i][j].Y+12] = 1;
					}
				}
			}
			trace("line "+i+": "+ind);
		}
		// get computers score
		var mn:Object;
		for (var i:Number = 0; i<=24; i++) {
			for (var j:Number = 0; j<=diamondsGrid[i].length; j++) {
				if (diamondsGrid[i][j] == 1) {
					mn = {m:i-12, n:j-12};
					for (var ii:Number = 0; ii < n; ii++) {
						if (m_numRan[ii]/m_denRan[ii]*mn.m + cRan[ii] == mn.n) {
							computerScore++;
							break;
						}
					}
				}
			}
		}
		trace("COMPUTER'S SCORE: "+computerScore);
		//
		drop();
	}
	// drop diamonds to points with "1" in diamonds array;
	function drop() {
		for (var i:Number = 0; i<=24; i++) {
			for (var j:Number = 0; j<=diamondsGrid[i].length; j++) {
				if (diamondsGrid[i][j] == 1) {
					var mn:Object = {m:i-12, n:j-12};
					//trace("mn: "+mn.m+", "+mn.n);
					_parent.dropDiamond(mn);
				}
			}
		}
	}
	// gives array of K random indexes from 0-(N-1)
	function randomIndex(N:Number, K:Number):Array {
		var ind:Array = new Array();
		var a:Number;
		for (var i:Number = 0; i<N; i++) {
			ind[i] = i;
		}
		for (var i:Number = N-1; i>K-1; i--) {
			a = Math.floor(Math.random()*(i+1));
			for (var j:Number = a; j<ind.length; j++) {
				ind[j] = ind[j+1];
			}
			ind.pop();
		}
		return ind;
	}
	//Attach the lines and the algebra.
	function attachLines() {
		for (var i:Number = 0; i != n; i++) { 
			this.createEmptyMovieClip("graph"+i,this.getNextHighestDepth());
			var a = AlgebraBox(attachMovie("AlgebraBox","algbox"+i,this.getNextHighestDepth(),
			{_x:220,_y:-98+102.5*i,h:60,w:80,colour:0xFFFFFF}));
		}
	}
	// Clear lines and the algebra
	function clearLines() {
		for (var i:Number = 0; i != n; i++) { 
			this["graph"+i].clear();
			this["algbox"+i].algebra = "";
			this["algbox"+i].createMaths();
		}
	}
	//
	//Draw computer lines and update equations
	//
	function drawComputerLines() {
		for (var i:Number = 0; i<n; i++) {
			updateEquation(i,m_numRan[i],m_denRan[i],cRan[i]);
			drawLines(i,false);
		}
	}
	//Draw lines
	function drawLines(i:Number, player:Boolean) {
		this["graph"+i].clear();
		this["graph"+i].lineStyle(2,cols[i],100);
		
		//Cleanest method of drawing graph is probably to find the end points.
		//Let end points be (p,q) and (u,v).
		
		var p,q,u,v:Number;
		if (player) {
			var c = (c_num[i]/c_den)*(L/12);
			var m = (m_num[i]/m_den[i]);
		}
		else {
			var c = cRan[i]*(L/12);
			var m = (m_numRan[i]/m_denRan[i]);
		}
		//
		// find y for x = L on the border of square
		var yy = m*L+c;
		if ((yy>= -L) && (yy <= L)) {
			p=L;
			q=yy;
		}
		else if (yy < -L) {
			p=(-L-c)/m;
			q=-L;
		}
		else {
			p=(L-c)/m;
			q=L;
		}
		// find y for x = -L on the border of square
		yy = -m*L+c;
		if ((yy>= -L) && (yy <= L)) {
			u=-L;
			v=yy;
		}
		else if (yy < -L) {
			u=(-L-c)/m;
			v=-L;
		}
		else {
			u=(L-c)/m;
			v=L;
		}
		dy = 85; // found the difference with trying
		/*// insert a dot where line crosses y axe
		var dot = attachMovie("Dot","dot",this.getNextHighestDepth(), {_x:0, _y:-c+dy});*/ 
		this["graph"+i].moveTo(p,-q+dy);
		this["graph"+i].lineTo(u,-v+dy);
		//trace("line "+i+": p= "+p+", q= "+q+", u= "+u+", v= "+v)
		evaluate(i);
	}
	// evaluate how many diamonds were collected by the line
	function evaluate(ii:Number) {
		var mn:Object;
		for (var i:Number = 0; i<=24; i++) {
			for (var j:Number = 0; j<=diamondsGrid[i].length; j++) {
				if (diamondsGrid[i][j] == 1) {
					mn = {m:i-12, n:j-12};
					if (m_num[ii]/m_den[ii]*mn.m + c_num[ii] == mn.n) {
						_parent.colorDiamond(mn);
						score++;
						diamondsGrid[i][j] = 0;
					}
				}
			}
		}
		trace("*** S C O R E : "+score);
		//_parent.endGame();
	}
	function updateEq(i:Number) {
		m_num[i] = _parent.panel.mStepper.value;
		m_den[i] = _parent.panel.m2Stepper.value;
		c_num[i] = _parent.panel.cStepper.value;
		updateEquation(i,m_num[i],m_den[i],c_num[i]);
	}
	
	//Update equation i. y=mx+c
	function updateEquation(i,m_num,m_den,cc:Number) {
		
		//var cc = -cc/square_width;
		var algebra:String = null;
		if (m_num==null) algebra = "x=0";
		else if (m_num==0) algebra = "y = "+cc;
		else {
			var c:Number = (cc>0) ? cc : -cc;
			var plus_or_minus:String = (cc>0) ? "+" : "-";
			var h:Number = hcf(Math.abs(m_num),Math.abs(m_den));
			var top:String = (Math.abs(m_num/h)==1) ? "" : Math.abs(m_num/h);
			var bot:Number = Math.abs(m_den/h);
			var sign:String = (m_num*m_den>0) ? "" : "-";
			
			if (c != 0) {
				if (bot==1) algebra = "y = "+sign+top+" x "+plus_or_minus+c;
				else algebra = "y = "+sign+top+" x "+"/"+bot+plus_or_minus+c;
			} else {
				if (bot==1) algebra = "y = "+sign+top+" x ";
				else algebra = "y = "+sign+top+" x "+"/"+bot;
			}
		}
		
		this["algbox"+i].algebra = algebra;
		this["algbox"+i].createMaths();
	}
	// Random function for plus/minus sign
	function ranSgn() : Number{
		if (Math.random() < 0.5) {
			return 1;
		}
		else {
			return -1;
		}
	}
	//Finds hcf.
	function hcf(m_num,m_den:Number):Number {
		var h:Number = 1;
		for (var i:Number = 1; i!=Math.min(m_num,m_den)+1; i++) 
			if (m_num % i == 0 && m_den % i == 0) h = i;
		return h;
	}
}