﻿/**
	The Snapper class allows you to define snapping behaviour. The idea is that:
	   the centre of any object will snap to the centre of the snapper;
	   and the object will snap to that point if its centre lands anywhere on the snapper.
	   
	Us this class in conjunction with class SnapSet. A SnapSet contains all the Snappers that 
	an object is allowed to snap to.
	   
	Look at the sample code in Example.fla and ObjectToSnap.as.
	
	How to use this class: 
 	1) Draw movieClips on the stage where you want things to snap.
	2) Draw each one as big as its snap area.
	3) Make them all class Snapper in the usual way (Library > Properties > AS2.0 Class = Snapper).
	4) Make a SnapSet with snapSet = new SnapSet();
	5) Add all your snappers to the SnapSet with snapSet.addSnapper(aSnapper);
	6) Tell any object that will snap to these places about the snapSet.
	
	Look at the sample code in Example.fla and ObjectToSnap.as. 
	You should not need to change Snapper.as and SnapSet.as.


*/
	
	
class Snapper extends MovieClip {
	var cx:Number;
	var cy:Number;
	function Snapper() {
		var snapperBounds:Object = this.getBounds(_parent);
		cx = (snapperBounds.xMin+snapperBounds.xMax)/2;
		cy = (snapperBounds.yMin+snapperBounds.yMax)/2;
		this._visible = false;
	}
	function inside(ob:Object):Boolean { 
		var bounds:Object = MovieClip(ob).getBounds(_parent);
		var xx:Number = (bounds.xMin+bounds.xMax)/2;
		var yy:Number = (bounds.yMin+bounds.yMax)/2;
		return this.hitTest(xx, yy, true);
	}
	function snap(ob:Object) {
		var bounds:Object = MovieClip(ob).getBounds(_parent);
		var dx:Number = (bounds.xMin+bounds.xMax)/2;
		var dy:Number = (bounds.yMin+bounds.yMax)/2;
		ob._x += (cx - dx);
		ob._y += (cy - dy);
	}
}