package org.maths
{
	public class Fraction extends Object {
		public var p:int;
		public var q:int;
		//public var data:*;
		
		function Fraction(p:int, q:int) {
			this.p = p;
			this.q = q;
		}
		
		public function clone():Fraction {
			return new Fraction(p,q);
		}
		
		public function simplify():void {
			normalise();
			var pp:int = p;
			var qq:int = q;
			var rr:int = 1;
			if(q == 0) {
				if (p > 0) p = 1;
				if (p < 0) p = -1;
				return;
			}
			while(qq != 0) {
				var t:int = qq;
				qq = pp % qq;
				pp = t;
			}
			p /= pp; 
			q /= pp;
		}
		
		public function get reciprocal():Fraction {
			var f:Fraction = new Fraction(q,p);
			f.normalise();
			return f;
		}
		
		public function negate():void {
			p = -p;
		}
		
		public function plus(f:Fraction):Fraction {
			var frac:Fraction = new Fraction(p*f.q + q*f.p, q*f.q);
			frac.simplify();
			return frac;
		}
		
		public function normalise():void {
			if(q < 0) {
				p = -p;
				q = -q;
			}
		}
		
		public function toString():String {
			normalise();
			if(q == 1) 
				return ""+p;
			else
				return ""+p+"/"+q;
		}
	}
}