package away3dPlus.objects
{
	import away3d.core.mesh.Mesh;
	import away3d.core.material.ISegmentMaterial;
	import away3d.core.utils.Init;
	import away3d.core.mesh.WireMesh;
	import away3d.core.mesh.Vertex;
	import away3d.core.mesh.Segment;
	import away3d.core.math.Number3D;
	
    
    /** Wire curve */ 
    public class WireCurve extends WireMesh
    {
    	private var _vertices:Array;
    	
    	override public function get vertices():Array {
    		return _vertices;
    	}
    	
    	public function get lastVertex():Vertex {
    		var lastx:int = _vertices.length - 1;
    		if(lastx < 0)
    			return null;
    		return _vertices[lastx];
    	}
     	
        public function WireCurve(init:Object = null)
        {
            super(init);
            
            init = Init.parse(init);
            
            _vertices = [];

        }
 
 		public function addVertex3D(v:Vertex):Vertex {
 			if(v != lastVertex) {
 			
	 			// make new segment
	 			if(vertices.length > 1) {
	  				addSegment(new Segment(lastVertex, v)); 
	 			}
	 			_vertices.push(v);
 			}
 			return v;
 		}
 
  		public function addSegmentedLine(start:Vertex, end:Vertex, segments:uint):void {
  			
 			if(segments == 0) 
 				return;
 				
  			var len:int = vertices.length;
 			var delta:Number3D = Number3D.sub(end.position, start.position);
 			delta = Number3D.scale(delta, 1/segments);
 			
 			// add the start vertex
	 		addVertex3D(start);
	 		
	 		// add the middle vertices
 			for(var i:int = 1; i < segments; i++) {
 				addVertex3D(new Vertex()).position = Number3D.add(start.position, Number3D.scale(delta,i));
 			}
 			
 			// add the last vertex
 			addVertex3D(end);
		}

  		public function addWire(wire:WireCurve):void {
  			
  			for(var i:int = 0; i < wire.vertices.length; i++) {
  				addVertex3D(wire.vertex(i));
  			}
 		}

        public function vertex(ix:int):Vertex
        {
            return vertices[ix];
        }

    }
}
