package away3dPlus.objects
{
	import away3d.core.proto.Object3D;
	import away3d.core.material.ISegmentMaterial;
	import away3d.core.Init;
	import away3d.core.material.WireframeMaterial;
	import away3d.core.geom.Vertex3D;
	import away3d.core.proto.ObjectContainer3D;

	public class Axes extends ObjectContainer3D
	{
        private var unit:Number;
        private var guage:int;
        private var _xUnits:Number;
        private var _yUnits:Number;
        private var _zUnits:Number;
        private var xRGB:int;
        private var yRGB:int;
        private var zRGB:int;
        private var wireAlpha:Number;
        
        public var xAxis:WireCurve;
        public var xAxisMaterial:ISegmentMaterial;
        public var yAxis:WireCurve;
        public var yAxisMaterial:ISegmentMaterial;
        public var zAxis:WireCurve;
        public var zAxisMaterial:ISegmentMaterial;
        
         function Axes(init:Object = null) {
        	
        	super(init);
            init = Init.parse(init);

            unit = init.getNumber("unit", 100);
            guage = init.getNumber("guage", 3);
            _xUnits = init.getNumber("xUnits", 5);
            _yUnits = init.getNumber("yUnits", 5);
            _zUnits = init.getNumber("zUnits", 5);
            xRGB = init.getNumber("xRGB", 0xff0000);
            yRGB = init.getNumber("yRGB", 0x0000ff);	// y and z swap places in the render
            zRGB = init.getNumber("zRGB", 0x00ff00);
            wireAlpha = init.getNumber("alpha", 1.0);

 	       	// Draw axes
			xAxisMaterial = new WireframeMaterial(xRGB, wireAlpha, guage);
	       	xAxis = new WireCurve(xAxisMaterial);
	       	xAxis.addVertex3D(new Vertex3D());
	       	xAxis.addVertex3D(new Vertex3D(xUnits*unit, 0, 0));
	       	addChild(xAxis);
	       	
			yAxisMaterial = new WireframeMaterial(yRGB, wireAlpha, guage);
	       	yAxis = new WireCurve(yAxisMaterial);
	       	yAxis.addVertex3D(new Vertex3D());
	       	yAxis.addVertex3D(new Vertex3D(0, yUnits*unit, 0));
	       	addChild(yAxis);
	       	
			zAxisMaterial = new WireframeMaterial(zRGB, wireAlpha, guage);
	       	zAxis = new WireCurve(zAxisMaterial);
	       	zAxis.addVertex3D(new Vertex3D());
	       	zAxis.addVertex3D(new Vertex3D(0, 0, zUnits*unit));
	       	addChild(zAxis);      	
        }
        
        public function get xUnits():Number {
        	return _xUnits;
        }
        
		public function set xUnits(u:Number):void {
			_xUnits = u;
			xAxis.vertex(1).x = xUnits*unit;
		}
        
        public function get yUnits():Number {
        	return _yUnits;
        }
        
		public function set yUnits(u:Number):void {
			_yUnits = u;
			yAxis.vertex(1).y = yUnits*unit;
		}
        
        public function get zUnits():Number {
        	return _zUnits;
        }
        
		public function set zUnits(u:Number):void {
			_zUnits = u;
			zAxis.vertex(1).z = zUnits*unit;
		}
        
	}
}