package away3dPlus.cameras
{
	//import away3d.core.proto.Camera3D;
	import away3d.core.scene.Object3D;
	import away3d.core.math.Number3D;
	import away3d.cameras.TargetCamera3D;
	
	/**
	 * A camera which keeps looking at a target when it is translated.
	 * This makes the camera easier to use with Tweener
	 */
	public class TargetedCamera extends TargetCamera3D
	{
		//private var _target:Object3D;
		public var upAxis:Number3D;
		
		function TargetedCamera(target:Object3D) {
			super({target:target})
			//_target = target;
			upAxis = new Number3D(0,1,0);
		}
		
		override public function set x(value:Number):void {
			super.x = value;
			if (target!= null) lookAt(target.position, upAxis);
		}
		
		override public function set y(value:Number):void {
			super.y = value;
			if (target!= null) lookAt(target.position, upAxis);
		}
		
		override public function set z(value:Number):void {
			super.z = value;
			if (target!= null) lookAt(target.position, upAxis);
		}

		/*
		override public function lookAt(target:*, upAxis:Number3D=null):void {
			this.target = target;
			super.lookAt(target, upAxis);
		}
		*/
		
		public function get upAxisX():Number {
			return upAxis.x; 
		}
		
		public function set upAxisX(n:Number):void {
			upAxis.x = n; 
			if (target!= null) lookAt(target.position, upAxis);
		}
		
		public function get upAxisY():Number {
			return upAxis.y; 
		}
		
		public function set upAxisY(n:Number):void {
			upAxis.y = n; 
			if (target!= null) lookAt(target.position, upAxis);
		}
		
		public function get upAxisZ():Number {
			return upAxis.z; 
		}
		
		public function set upAxisZ(n:Number):void {
			upAxis.z = n; 
			if (target!= null) lookAt(target.position, upAxis);
		}
		
		/*
		public function get target():Object3D {
			return target;
		}
		
		public function set target(t:Object3D):void {
			_target = t;
			if (t != null) lookAt(t, upAxis);
		}
		*/
	}
}