package
{
	import mx.core.UIComponent;
	import away3d.core.material.WireframeMaterial;
	import mx.controls.Button;
	import flash.events.MouseEvent;
	import caurina.transitions.Tweener;
	import away3d.core.scene.ObjectContainer3D;
	import mx.controls.Text;
	import mx.controls.TextArea;
	//import org.maths.CFraction;
	import flash.events.Event;
	import org.maths.Fraction;
	
	public class TangleScene extends Away3DSprite
	{
		private var tangle:Tangle;
		private var tangleBox:ObjectContainer3D;
		private var zero:Button;
		private var turn:Button;
		private var twist:Button;
		private var untwist:Button;
		private var cfrac:TextArea;
		private var cfraction:TangleFraction;
		private var lagrange:Button;
		public var p:Text;
		public var q:Text;
		//private var parity:int = 1;
		
		function TangleScene(controls:UIComponent) {
		
			tangleBox = new ObjectContainer3D();
		
			tangle = new Tangle(new WireframeMaterial(0xFF7700), this, target, 
				{width:400, height:400, segments:10});
				
			tangleBox.addChild(tangle);
			
			container = tangleBox;
			
			zero = controls.getChildByName("zero") as Button;
			zero.addEventListener(MouseEvent.CLICK, doZero);
			
			turn = controls.getChildByName("turn") as Button;
			turn.addEventListener(MouseEvent.CLICK, doTurn);
			
			twist = controls.getChildByName("twist") as Button;
			twist.addEventListener(MouseEvent.CLICK, doTwist);
			
			untwist = controls.getChildByName("untwist") as Button;
			untwist.addEventListener(MouseEvent.CLICK, doUntwist);
			//untwist.visible = false;
			
			cfrac = controls.getChildByName("cfrac") as TextArea;
			
			cfraction = new TangleFraction();
			cfraction.addEventListener("cfracChanged", cfracChanged);
			cfraction.lag.addEventListener("cfracChanged", cfracChanged);
			cfraction.unshift(new Fraction(0,1));
			
			lagrange = controls.getChildByName("lagrange") as Button;
			lagrange.addEventListener(MouseEvent.CLICK, doLagrange);
			
			
			p = controls.getChildByName("p") as Text;
			q = controls.getChildByName("q") as Text;
				
			this.addEventListener(MouseEvent.MOUSE_DOWN, onPress);
			this.addEventListener(MouseEvent.MOUSE_UP, onRelease);

			super(controls, tangleBox);
		}
		
		private function cfracChanged(event:Event):void {
			cfrac.text = cfraction.text;
		}
		
		private function onPress(event:MouseEvent):void {
			this.startDrag();;
		}
		
		private function onRelease(event:MouseEvent):void {
			this.stopDrag();
			invalidate();
		}
		
		override protected function preRender():void {
 			tangle.preRender();
		}
		
		private function doTwist(event:MouseEvent):void {
			cfraction.twist(); //add(new Fraction(1,1));
			tangle.twist();
		}
		
		private function doUntwist(event:MouseEvent):void {
			cfraction.untwist(); //add(new Fraction(-1,1));
			tangle.untwist();
		}
		
		private function doTurn(event:MouseEvent):void {
			//parity = -parity;
			cfraction.turn(); // negate();
			//cfraction.push(new Fraction(0,1));
			tangle.turn();
			startTween();
			Tweener.addTween(tangle, {rotationY:(tangle.rotationY + 90), time:1, transition:"easeOutCubic", onComplete:endTween});
		}

		private function doZero(event:MouseEvent):void {
			//parity = 1;
			cfraction.zero();
			tangle.zero();
		}
		
		private function doLagrange(event:MouseEvent):void {
			cfraction.lagrange();
		}
		
		override public function startTween():void {
			super.startTween();
			enabled = false;
		}
		
		override public function endTween():void {
			super.endTween();
			enabled = true;
		}
		
		public function get enabled():Boolean {
			if(stage == null) return false;
			return zero.enabled && turn.enabled && twist.enabled && untwist.enabled;
		}
		
		public function set enabled(b:Boolean):void {
			if(stage == null) return;
			zero.enabled = b;
			turn.enabled = b;
			twist.enabled = b;
			untwist.enabled = b;
		}
	}
}