package
{
	import org.maths.CFraction;
	import org.maths.Fraction;

	public class TangleFraction extends CFraction
	{
		
		public var lag:CFraction;
		
		function TangleFraction() {
			super();
			lag = new CFraction();
			lag.parts = [new Fraction(0,1)];
		}
		
		/**
		 * 
		 */
		public function lagrange():void {
			lag.simplify();
			lag.notifyChange();	
		}
		
		public function zero():void {
			sign = +1;
			parts = [new Fraction(0,1)];
			lag.parts = [new Fraction(0,1)];
			notifyChange();
		}

		public function twist():void {
			add(new Fraction(1,1));
			/*
			if(sign < 0) {
				lag.negate();
				sign = 1;
			}
			*/
			lag.add(new Fraction(1,1));
			notifyChange();
		}
		
		public function untwist():void {
			add(new Fraction(-1,1));
			/*
			if(sign < 0) {
				lag.negate();
				sign = 1;
			}
			*/
			lag.add(new Fraction(-1,1));
			notifyChange();
		}
		
		public function turn():void {
			negate();
			unshift(new Fraction(0,1));
			/*
			if(sign < 0)
				sign = 1;
			else 
				lag.negate();
			*/
			lag.negate();
			lag.unshift(new Fraction(0,1));
			notifyChange();
		}
		
		override public function toString():String {
			/*
			var sn:String = (sign > 0 ? "" : "-");
			var s:String = "[";
			var sep:String = "";
			for(var i:int=0; i < parts.length; i++) {
				var f:Fraction = getPartAt(i);
				if(i>0)
					sep = (f.data == null) ? "," : ';';
				s += (sep + f);
			}
			return s + "] = " + sn + lag + " = " + sn + lag.evaluate();;
			*/
			return lag.toString() + " " + super.toString();
		}		
	}
}