package
{
	import away3d.core.scene.ObjectContainer3D;
	import away3dPlus.objects.WireCurve;
	import away3d.core.material.WireframeMaterial;
	import away3d.core.utils.Init;
	import flash.display.BitmapData;
	import away3d.objects.Triangle;
	import away3d.core.sprite.Sprite2D;
	import away3d.core.mesh.Vertex;
	import away3d.core.math.Number3D;

	public class Rope extends ObjectContainer3D
	{
		private var _rgb:int;
		private var	_alpha:Number;
		private var _thickness:Number;
		private var _topRope:Boolean = true;
		private var _unit:Number;
		private var _iconScale:Number;
		private var _start:Number3D;
		private var _end:Number3D;
		private var _segments:uint;
		private var _ropeStart:RopeEnd;
		private var _ropeEnd:RopeEnd;
		
		// Rope end labels
		private var triangle:Sprite2D;
		private var star:Sprite2D;
		private var square:Sprite2D;
		private var disc:Sprite2D;
		
		// Default rope colours
		//public const WHITE:int = 0xffffff;
		//public const BLUE:int = 0x0099CC;
		public const WHITE:int = 0xffff00;
		public const BLUE:int = 0xff5500;
		
		public var wire:WireCurve;
	
		function Rope(init:Object = null) {
	    	super(init);
	        init = Init.parse(init);
	
	        _rgb = init.getInt("rgb", BLUE);
	        _alpha = init.getNumber("alpha", 1.0);
	        _thickness = init.getNumber("thickness", 200);
	        
	        _topRope = init.getBoolean("topRope", true);
	        if(_topRope)
	        	_rgb = init.getInt("rgb", WHITE);
	        else
	        	_rgb = init.getInt("rgb", BLUE);
	        	
	        _unit = init.getNumber("unit", 200);
	        _iconScale = init.getNumber("iconScale", 1);
	        
	        _start = init.getNumber3D("start");
	        _end = init.getNumber3D("end");
	        
	        _segments = init.getInt("segments", 8);
	        
	        buildRope();
	  	}

		/**
		 * Splice a wire onto an end
		 */
 		public function splice(newWire:WireCurve, end:RopeEnd):void {
 			var oldWire:WireCurve = wire;
 			if(end.index == 0) {
 				// splice in BEFORE current rope
	 			wire = new WireCurve({material:new WireframeMaterial(_rgb, {alpha:_alpha, width:_thickness})});
	 			//addVertices(start.position, end.position);
 			}
 			else {
 				// insert AFTER current rope
 			}
		}
 
	
 	 	private function buildRope():void {
	 		wire = new WireCurve({material:new WireframeMaterial(_rgb, {alpha:_alpha, width:_thickness})});
	 		wire.addSegmentedLine(new Vertex(_start.x, _start.y, _start.z), new Vertex(_end.x, _end.y, _end.z), _segments);
			addChild(wire);
	 		if(_topRope) {
	 			name="0";
							
				//triangle = new Sprite2D(new Triangle().bitmapData, _iconScale);
				//addChild(triangle);
				_ropeStart = new RopeEnd(this, 0 /*triangle*/);
				

				//star = new Sprite2D(new Star().bitmapData, _iconScale);
				//addChild(star);
				_ropeEnd = new RopeEnd(this, wire.vertices.length - 1 /*star*/);
	 		}
	 		else {
	 			name="1"
				
				//square = new Sprite2D(new Square().bitmapData, _iconScale);
				//addChild(square);
				_ropeStart = new RopeEnd(this, 0 /*square*/);

				//disc = new Sprite2D(new Disc().bitmapData, _iconScale);
				//addChild(disc);
				_ropeEnd = new RopeEnd(this, wire.vertices.length - 1 /*disc*/);
	 		}
	 	}
	 		 	
	 	public function rewire():WireCurve {
	 		var oldWire:WireCurve = wire;
			removeChild(wire);
	 		wire = new WireCurve({material:new WireframeMaterial(_rgb, {alpha:_alpha, width:_thickness})});
	 		addChild(wire);
	 		return oldWire;		
	 	}	
	 	
	 	public function updateEnd():void {
	 		_ropeEnd.index = wire.vertices.length-1;
	 	}
	 	
	 	public function get ropeStart():RopeEnd { 
	 		return _ropeStart;
	 	}
	 	
	 	public function get ropeEnd():RopeEnd {
	 		return _ropeEnd;
	 	}
	 	
	 	public function get thickness():Number {
	 		return _thickness;
	 	}
	 	
	 	public function set thickness(t:Number):void {
	 		_thickness = t;
	 		(wire.material as WireframeMaterial).width = Math.max(t, 5);
	 	}
	 	
	 	public function get unit():Number {
	 		return _unit;
	 	}
	 	
	 	public function set(n:Number):void {
	 		_unit = n;
	 	}
	 	
	 	public function get segments():uint {
	 		return _segments;
	 	}
	 	public function set segments(n:uint):void {
	 		_segments = n;
	 	}
	}
}