package
{
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.utils.*;

    import mx.core.BitmapAsset;
    
    import away3d.cameras.*;
    import away3d.objects.*;
    import away3d.loaders.*;
//    import away3d.test.*;
    import away3d.core.*;
    import away3d.core.material.*;
    import away3d.core.render.*;
    import away3d.core.proto.*;
    import away3d.core.geom.*;
    import away3d.core.draw.*;
    import away3d.core.math.*;
    
    
    [SWF(backgroundColor="#000022", frameRate="60")]
    public class Earth extends BaseDemo
    {

    	private function onResize(event:Event):void 
        {
            centergroup.x = stage.stageWidth / 2;
            centergroup.y = stage.stageHeight / 2;
            titlegroup.x = 10;
        }

        public function Earth()
        {
            super("Click on Sphere");
            startlabel.htmlText = "Start";
            titlegroup.visible = false;
            infogroup.visible = false;
            statsgroup.visible = false;

            //stage.addEventListener(Event.RESIZE, onResize);
/*
            camera.tiltangle = 0;
            camera.targettiltangle = 0;

            camera.panangle = 0;
            camera.targetpanangle = 0;

            camera.mintiltangle = 0;
*/
            addSlide("Earth", "Description", new Scene3D(new Morphing()), Renderer.CORRECT_Z_ORDER/*Renderer.INTERSECTING_OBJECTS*/); 

        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.geom.*;

import mx.core.BitmapAsset;

import away3d.cameras.*;
import away3d.objects.*;
import away3d.loaders.*;
import away3d.core.*;
import away3d.core.render.*;
import away3d.core.proto.*;
import away3d.core.geom.*;
import away3d.core.draw.*;
import away3d.core.material.*;

import away3d.core.math.Number3D;
import away3d.core.math.Matrix3D;

class Asset
{
    [Embed(source="images/cube2.dae",mimeType="application/octet-stream")]
    public static var OrthoCyl:Class;

    [Embed(source="images/circle.dae",mimeType="application/octet-stream")]
    public static var CircleModel:Class;

    [Embed(source="images/tri.dae",mimeType="application/octet-stream")]
    public static var TriModel:Class;

    [Embed(source="images/square.dae",mimeType="application/octet-stream")]
    public static var SquareModel:Class;

    [Embed(source="images/earthmap-otp.jpg")]
    public static var EarthImage:Class;

    public static function get earth():BitmapData
    {
        return (new EarthImage as BitmapAsset).bitmapData;
    }
    
    [Embed(source="images/sunmapbaked.jpg")]
    public static var SunImage:Class;

    public static function get sun():BitmapData
    {
        return (new SunImage as BitmapAsset).bitmapData;
    }

    public static function get black1x1():BitmapData
    {
        return fill(0x000000, 1, 1);
    }

    public static function get white1x1():BitmapData
    {
        return fill(0xFFFFFF, 1, 1);
    }

    public static function color1x1(color:int):BitmapData
    {
        return fill(color, 1, 1);
    }

    public static function fill(color:int, width:int, height:int):BitmapData
    {
        var b:BitmapData = new BitmapData(width, height, false);
        for (var i:int = 0; i < width; i++)
            for (var j:int = 0; j < height; j++)
            {
                //b.setPixel(i, j, int(Math.max(i-j/2, 0))*0x10000 + int(i/2)*0x100 + int(Math.max(j-i/2, 0)));
                b.setPixel(i, j, color);
                //if (i % 20 == 1)
                //    b.setPixel(i, j, 0);
                //if (j % 20 == 1)
                //    b.setPixel(i, j, 0xEE7700);
            }
        return b;
    }

    public static function get bwwb():BitmapData
    {
        var b:BitmapData = new BitmapData(2, 2, false);
        b.setPixel(0, 0, 0xFFFFFF);
        b.setPixel(1, 1, 0xFFFFFF);
        b.setPixel(0, 1, 0);
        b.setPixel(1, 0, 0);
        return b;
    }
}

class Morphing extends ObjectContainer3D
{
    private var orthoCyl:Mesh3D;
    private var circle:Mesh3D;
    private var tri:Mesh3D;
    private var square:Mesh3D;
    private var morph:Mesh3D;
    private var morpher:Morpher;
    private var texture:WireColorMaterial;

    public function Morphing()
    {
        texture = new WireColorMaterial();
		orthoCyl = Collada.parse(Asset.OrthoCyl, {face:texture}).children[0];
        //circle = Collada.parse(Asset.CircleModel, {face:texture}).children[0];
        //tri    = Collada.parse(Asset.TriModel, {face:texture}).children[0];
        //square = Collada.parse(Asset.SquareModel, {face:texture}).children[0];
        //morph  = Collada.parse(Asset.CircleModel, {face:texture}).children[0];
        //morpher = new Morpher(morph);

        super(orthoCyl);
    }

    public override function tick(time:int):void
    {
    	/*
        var kt:Number = Math.min(Math.max(Math.sin(time/3000), 0), 1);
        var ks:Number = Math.min(Math.max(Math.sin(time/3000+2*Math.PI/3), 0), 1);
        morpher.start();
        morpher.mix(tri, kt);
        morpher.mix(square, ks);
        morpher.finish(circle);
        texture.fillColor = int(255*kt)*0x10000 + int(255*(1-kt-ks))*0x100 + int(255*ks);
        */
    }
}
 
class Globe extends ObjectContainer3D
{
    private var sphere:Sphere;
    private var geoData:BitmapData
    private var savedData:BitmapData;
    private var savedPhi:Number;
                       
    public function Globe()
    {
    	geoData = Asset.sun;
    	
        sphere = new Sphere(new BitmapMaterial(geoData), {x:0, y:0, z:0, radius:200, segmentsW:20, segmentsH:20});

        sphere.events.addEventListener(MouseEvent.MOUSE_DOWN, onGlobeMouseDown);
        super(sphere );
    }
    /*
    private function phi2height(phi:Number):int {
    	return Math.floor(278-250*(2*phi/Math.PI));
    }
    
    private function drawLatitude(phi:Number):void {
    	var lheight:int = phi2height(phi);
    	var rect:Rectangle = new Rectangle(0, lheight, geoData.width, 2);
        if(savedData == null) {
	        savedData = new BitmapData(geoData.width, 2);
	    }
 	    savedPhi = phi;
        savedData.copyPixels(geoData, rect, new Point(0,0));
        geoData.fillRect(rect,0);
    }
    
    private function restoreLatitude(phi:Number, savedData:BitmapData):void {
    	var lheight:int = phi2height(phi);
    	geoData.copyPixels(savedData, new Rectangle(0,0,savedData.width, savedData.height),new Point(0,lheight));
    }
    
    private function drawPixel(x:int, y:int, rgb:uint):void {
    	var col:uint = geoData.getPixel(x,y);
    	for(var i:int=-1; i < 2; i++)
    		for(var j:int=-1; j < 2; j++)
    			geoData.setPixel(x+i, y+j, rgb);
     }
    
	private function otp(x:int, y:int):void {
		var pole:int;
		var h:int;
		pole = y > 278 ? 530 : 0;
		h = Math.max(y-pole);
		if(y < 278) {
			pole = 0;
			h = y;
			geoData.fillRect(new Rectangle(x-1,pole,2,h),0);
			geoData.fillRect(new Rectangle((x-1+geoData.width/2)%geoData.width,pole,2,h),0);
		}
		else {
			pole = 530;
			h = 530-y;
			geoData.fillRect(new Rectangle(x-1,y,2,h),0);
			geoData.fillRect(new Rectangle((x-1+geoData.width/2)%geoData.width,y,2,h),0);
			
		}
	}
	*/
    public override function tick(time:int):void
    {
        //sphere.rotationY = -time / 300;
        /*
        if(savedData != null) {
        	var phi:Number = ((time/50) % 180 - 90)*Math.PI/180;
        	restoreLatitude(savedPhi, savedData);
        	drawLatitude(phi);
        }
        */
    }
    
    /*
    public function onMouseDown(e:MouseEvent3D):void
    {
        if (e.object is Mesh3D)
        {
            var mesh:Mesh3D = e.object as Mesh3D;
            mesh.material = new WireColorMaterial();
        }
    }
    */
	private static var lastx:int;
	private static var lasty:int;
	
    public function onGlobeMouseDown(e:MouseEvent3D):void
    {
		//var torus:WireTorus = new WireTorus(new WireColorMaterial(0x00ff00, 0xff0000), {radius:300, tube:10, segmentsT:5, segmentsR:20});
		//this.addChild(torus);
    	//trace("uv="+e.uv);
    	//trace("focus = " + e.view.camera.focus);
    	var f:Face3D = (e.drawpri as DrawTriangle).face;
    	if(f==null) return;
    	//trace("face.v0="+f.v0 + " uv="+f.uv0);
    	//trace("face.v1="+f.v1 + " uv="+f.uv1);
    	//trace("face.v2="+f.v2 + " uv="+f.uv2);
    	// uv0.u*a0 + uv1.u*a1 + uv2.u*a2 = uv.u
    	// uv0.v*a0 + uv1.v*a1 + uv2.u*a2 = uv.v
    	// 1 * a0 + 1 *a1 + 1 * a2 = 1
    	// m * a = uv,1 
    	var fv0:Number3D = f.v0;
    	var fv1:Number3D = f.v1;
    	var fv2:Number3D = f.v2;
    	var m:Matrix3D = new Matrix3D();
    	m.n11 = f.uv0.u;
    	m.n12 = f.uv1.u;
    	m.n13 = f.uv2.u;
   		m.n21 = f.uv0.v;
     	m.n22 = f.uv1.v;
     	m.n23 = f.uv2.v;
  		m.n31 = 1;
     	m.n32 = 1;
    	m.n33 = 1;
		//trace("m=\n"+m);
		var a:Number3D = new Number3D(e.uv.u, e.uv.v, 1).rotate(Matrix3D.inverse(m));
		var b:Number = a.x + a.y + a.z;
		//trace("a = "+a);
		var obj:Number3D = new Number3D();
		obj.x = (a.x*fv0.x + a.y*fv1.x + a.z*fv2.x)/b;
		obj.y = (a.x*fv0.y + a.y*fv1.y + a.z*fv2.y)/b;
		obj.z = (a.x*fv0.z + a.y*fv1.z + a.z*fv2.z)/b;
		//trace("obj = " + obj);
		//
		// Horizontal plane
		//
		var material:ISegmentMaterial = new WireColorMaterial(0xffffff,0xffffff,0.3,0.6);
		//var wiremat2:WireColorMaterial = new WireColorMaterial(0xffffdd,0,0.3,0);
    	var p1:Object3D = getChildByName("plane1");
    	if(p1 != null)
    		removeChild(p1);
    	//if(p1 == null) {
    		//p1 = new Cube(material, {name:"plane1", width:500, height:5, depth:500});
    		var r:Number = (8+Math.sqrt(obj.x*obj.x+obj.z*obj.z));
    		trace("obj="+obj + "  r="+r);
    		p1 = new WireCircle(material, {name:"plane1", segmentsR:20, radius:r});
    		//p1 = new Plane(wiremat,{name:"plane1", width:500, height:500, segmentsW:2, segmentsH:2, bothsides:true});
   			addChild(p1);
   		//}
    	p1.y=obj.y;
     	//
    	// Vertical Plane
    	//
    	var p2:Object3D = this.getChildByName("plane2");
    	if(p2 == null) {
    		//p2 = new Cube(material, {name:"plane2", width:500, height:5, depth:500});
    		p2 = new WireCircle(material, {name:"plane2", segmentsR:20, radius:208});
    		//p2 = new Plane(wiremat,{name:"plane2", width:500, height:500, segmentsW:2, segmentsH:2, bothsides:true});
    		addChild(p2);
    	}
    	p2.rotationX = 90;
    	p2.rotationY = Math.atan2(-obj.z, obj.x)*180/Math.PI;
		p2.rotationZ = 0;
    	//trace(p1);
    	/*
        var camera:Camera3D = e.view.camera;
        var cam:Number3D = camera.position;
        var screen:Number3D = new Number3D(e.screenX, e.screenY, cam.modulo-e.screenZ);
        //var m:Matrix3D = camera.transform;
        //var m:Matrix3D = camera.getView();
        trace("cam = "+cam);
        trace("screen = "+screen);
        var m:Matrix3D = camera.getView();
        trace("matrix\n"+m);
        var obj:Number3D = screen.rotate(m);
        trace("obj="+obj);
        trace("===");
        */
        //lastx = e.uv.u*geoData.width;
        //lasty = (1-e.uv.v)*geoData.height;
        //drawPixel(lastx, lasty, 0);
        //otp(lastx, lasty);
        //trace("("+lastx+", "+lasty+")");
        
     }
/*	
    public function onGlobeMouseMove(e:MouseEvent3D):void
    {
     
            var x:Number = e.uv.u*geoData.width;
            var y:Number = (1-e.uv.v)*geoData.height;
            var n:Number = Math.sqrt((lastx-x)*(lastx-x) + (lasty-y)*(lasty-y)) * (2+1.2);
            for (var i:int = 0; i < n; i++)
            {
                var k:Number = Math.random();
                var dx:Number = (2*Math.random()-1)*(2*(0.2));
                var dy:Number = (2*Math.random()-1)*(2*(0.2));
                var bx:Number = k*x + (1-k)*lastx + dx;
                var by:Number = k*y + (1-k)*lasty + dy;

                geoData.setPixel(int(Math.round(bx)), int(Math.round(by)), 0);

                if (i % 20 == 0)
                {
                    var px:Number = (bx / geoData.width * 2 - 1) * 500;
                    var py:Number = (1 - by / geoData.height * 2) * 500;
                }

            }
            lastx = x;
            lasty = y;
    }
    */
}
