﻿import RimPoint;
class Protractor extends MovieClip {
	var d_alpha:Number = Math.PI/180;
	var tick:Number = Math.PI/36;
	var radius:Number = 200;
	var tickLength:Number = 4;
	var rgb:Number = 0x333333;
	var p:RimPoint;
	var pressedx:Number;
	var pressedy:Number;
	var pressedr:Number;
	var rotation:Number;
	var t0, t1:Number;
	var time:Number = 10000;
	var progress, position:Number = 0;
	var phase:Number = 1;
	var mcS, mcC:MovieClip;
	var xLabel, yLabel, zeroLabel, xOne, yOne, xMinusOne, yMinusOne:TextField;
	var panel:MovieClip;
	function Protractor() {
		mcS = createEmptyMovieClip("mcS",1);
		mcC = createEmptyMovieClip("mcC",2);
		panel = this["panel"];
		xLabel = this["xLabel"];
		xLabel._x = 220; xLabel._y = 0;
		yLabel = this["yLabel"];
		yLabel._x = 0; yLabel._y = -230;
		zeroLabel = this["zeroLabel"];
		zeroLabel._x = 0; zeroLabel._y = 0;
		xOne = this["xOne"];
		xOne._x = 200; xOne._y = 0;
		xMinusOne = this["xMinusOne"];
		xMinusOne._x = -220; xMinusOne._y = 0;
		yOne = this["yOne"];
		yOne._x = 0; yOne._y = -198;
		yMinusOne = this["yMinusOne"];
		yMinusOne._x = 0; yMinusOne._y = 200;
		draw();
		//doAnimation();
		panel.back.onRelease = backButton;
		panel.play.onRelease = playButton;
		panel.pause.onRelease = pauseButton;
		panel.forward.onRelease = forwardButton;
		panel.oneButton.onRelease = oneButton;
		panel.twoButton.onRelease = twoButton;
		panel.threeButton.onRelease = threeButton;
		highlight(0);
		panel.pause._visible=false;
		//onReleaseOutside = onRelease;
	}
	function backButton(){
		if (_parent._parent.phase >= 5) {
			_parent._parent.skipOne();
		}
		else if (_parent._parent.phase >= 3){
			_parent._parent.startAgain();
		}
	}
	function playButton(){
		_parent._parent.doAnimation();
		_parent._parent.panel.pause._visible=true;
	}
	function pauseButton(){
		_parent._parent.onEnterFrame = null;
		_parent._parent.position = _parent._parent.progress;
		_parent._parent.panel.pause._visible=false;
	}
	function forwardButton(){
		if (_parent._parent.phase < 3) {
			_parent._parent.skipOne()
		}
		else if (_parent._parent.phase < 5){
			_parent._parent.skipTwo();
		}
	}
	function oneButton(){
		_parent._parent.startAgain();
	}
	function twoButton(){
		_parent._parent.skipOne();
	}
	function threeButton(){
		_parent._parent.skipTwo();
	}
	function doAnimation () {
		if (onEnterFrame == null) {
			t0 = getTimer();
			t1 = t0 + time;
			onEnterFrame = doMove;
		}
	}
	function doMove() {
		var t:Number = getTimer();
		progress = (t-t0)/(t1-t0) + position;
		if (progress <= 1) { 
			dotAround(progress);
			switch(phase) {
				case 1: highlight(1);
					break;
				case 2: break;
				case 3: 
					highlight(2);
					drawAxes(); 
					break;
				case 4: drawLabels();
					break;
				case 5: highlight(3);
					drawSin(progress);
					break;
				case 6: drawSin(progress);
					break;
				case 7: mcS.clear();
					drawCos(progress);
					break;
				case 8: drawCos(progress);
					break;
				case 9: mcC.clear();
					drawSin(progress);
					drawCos(progress);
					break;
			}
		}
		else {
			if (phase < 9) { 
				dotAround(1);
				position = 0;
				phase++;
				onEnterFrame = null;
				doAnimation();
				
			}
			else {
				dotAround(1);
				mcS.clear();
				mcC.clear();
				onEnterFrame = null;
			}
		}
	}
	function highlight(step:Number) {
		panel.high1._visible = false;
		panel.high2._visible = false;
		panel.high3._visible = false;
		switch(step) {
			case 0: break;
			case 1: panel.high1._visible = true;
			break;
			case 2: panel.high2._visible = true;
			break;
			case 3: panel.high3._visible = true;
			break;
		}
	}
	function dotAround(angle:Number) {
		p._x = Math.cos(-angle*2*Math.PI)*radius;
		p._y = Math.sin(-angle*2*Math.PI)*radius;
	}
	function drawAxes() {
		lineStyle(1, rgb);
		var r:Number = radius + 30;
		if (progress > 0) {
			moveTo(0,0);
			lineTo(r,0);
		}
		if (progress > 0.25) {
			moveTo(0,0);
			lineTo(0, -r);
		}
		if (progress > 0.5) {
			moveTo(0,0);
			lineTo(-r,0);
		}
		if (progress > 0.75) {
			moveTo(0,0);
			lineTo(0,r);
			}
	}
	function drawLabels() {
		xLabel.htmlText = "<i>x</i>";
		yLabel.htmlText = "<i>y</i>";
		zeroLabel.text = "0";
		xOne.text = "1";
		yOne.text = "1";
		xMinusOne.text = "-1";		
		yMinusOne.text = "-1";
		moveTo(225,-5);
		lineTo(230,0);
		lineTo(225,5);
		moveTo(-5,-225);
		lineTo(0,-230);
		lineTo(5,-225);
	}
	function clearLabels(){
		xLabel.htmlText = "";
		yLabel.htmlText = "";
		zeroLabel.text = "";
		xOne.text = "";
		yOne.text = "";
		xMinusOne.text = "";		
		yMinusOne.text = "";
	}
	function drawSin(angle:Number) {
		mcS.clear();
		mcS.lineStyle(2, 0x0000FF, 100);
		mcS.moveTo(Math.cos(-angle*2*Math.PI)*radius,0);
		mcS.lineTo(Math.cos(-angle*2*Math.PI)*radius, Math.sin(-angle*2*Math.PI)*radius);
	}
	function drawCos(angle:Number) {
		mcC.clear();
		mcC.lineStyle(2, 0xFF0000, 100);
		mcC.moveTo(0,Math.sin(-angle*2*Math.PI)*radius);
		mcC.lineTo(Math.cos(-angle*2*Math.PI)*radius, Math.sin(-angle*2*Math.PI)*radius);
	}
	function startAgain(){
		clear();
		clearLabels();
		mcC.clear();
		mcS.clear();
		draw();
		onEnterFrame = null;
		dotAround(1);
		phase = 1;
		position = 0;
		doAnimation();
		panel.pause._visible=true;
	}
	function skipOne():Void{
		clear();
		clearLabels();
		mcC.clear();
		mcS.clear();
		draw();
		onEnterFrame = null;
		dotAround(1);
		phase = 3;
		position = 0;
		doAnimation();
		panel.pause._visible=true;
	}
	function skipTwo():Void{
		mcC.clear();
		mcS.clear();
		onEnterFrame = null;
		dotAround(1);
		phase = 5;
		progress = 1;
		drawAxes();
		drawLabels();
		position = 0;
		doAnimation();
		panel.pause._visible=true;
	}
	function draw():Void {
		clear();
		fillCircle(radius);
		drawCircle(radius);
		//drawTicks();
		//drawAxes();
	}
	function drawCircle(r:Number) {
		lineStyle(1, rgb, 50);
		moveTo(r, 0);
		for (var alpha:Number = d_alpha; alpha<2*Math.PI; alpha += d_alpha) {
			lineTo(r*Math.cos(alpha), r*Math.sin(alpha));
		}
	}
	function fillCircle(r:Number) {
		lineStyle(0,0,0);
		moveTo(r, 0);
		beginFill(0x000000, 10);
		for (var alpha:Number = d_alpha; alpha<2*Math.PI; alpha += d_alpha) {
			lineTo(r*Math.cos(alpha), r*Math.sin(alpha));
		}
		endFill();
	}
	function drawTicks() {	
		//moveTo(radius, 0);
		lineStyle(1, rgb);
		for (var alpha:Number = 0; alpha<2*Math.PI; alpha += tick) {
			moveTo((radius-tickLength)*Math.cos(alpha), (radius-tickLength)*Math.sin(alpha));
			lineTo((radius+tickLength)*Math.cos(alpha), (radius+tickLength)*Math.sin(alpha));
		}
	}
	/*function onPress() {
		_parent.onMouseMove = null;
		//trace("Hello");
		var d:Number = Math.sqrt(_xmouse*_xmouse+_ymouse*_ymouse);
		if(d > radius+3*tickLength) {
			pressedx = _root._xmouse - _parent._x;
			pressedy = _root._ymouse - _parent._y;
			pressedr = radius;
			onMouseMove = scale;
			
		}
		else if (d > radius-3*tickLength) {
			pressedx = _root._xmouse - _parent._x;
			pressedy = _root._ymouse - _parent._y;
			rotation = _parent._rotation;
			onMouseMove = turn;
		}
		else {
			_parent.startDrag();
			onMouseMove = move;
		}
	}
	function onRelease() {
		_parent.stopDrag();
		onMouseMove = _parent.doMouseMove;
	}
	function turn() {
		//trace("ahoj")
		var angle1:Number = Math.atan2(_root._ymouse-_parent._y,_root._xmouse-_parent._x);
		var angle2:Number = Math.atan2(pressedy,pressedx);
		//trace("angle1 = " + angle1 + " angle2 = " + angle2); 
		_parent._rotation = rotation+(angle1-angle2)*180/Math.PI;
		p.moveText();
	}
	
	function move() {
		p.moveText();
	}
	
	function scale() {
		var rx:Number = _root._xmouse-_parent._x;
		var ry:Number = _root._ymouse-_parent._y;
		radius = pressedr*Math.sqrt((rx*rx+ry*ry)/(pressedx*pressedx+pressedy*pressedy));
		draw();
		p.draw();
		//p.moveText();
	}*/
	
	/*
	var alpha:Number = d_alpha; 
	while(alpha<2*Math.PI) {
	lineTo(radius*Math.cos(alpha),radius*Math.sin(alpha));
	alpha+=d_alpha;
	}
	*/
}
