﻿import Card;
import mx.core.UIComponent;
import mx.controls.NumericStepper;
import mx.controls.Button;
class Cards extends UIComponent {
	var cards:Array;
	var order:Array;
	var redNumber:Number = 3;
	var depths:Array;
	var stepper:NumericStepper;
	var restartButton, tryAgain:Button;
	var table:MovieClip;
	var frame:MovieClip;
	var amount, bet, colour, result:TextField;
	var amountTitle, betTitle, colourTitle, resultTitle, title, endTitle, endNote:TextField;
	var amountTitlePosition, betTitlePosition, framePosition, endNotePosition, tryAgainPosition:Number;
	var amountN:Number;
	var history:Array;
	var t0, t1:Number;
	var l:Number;
	var red:Boolean;
	var cardActive:Boolean;
	var time:Number = 5000;
	function Cards() {
		stepper = this["stepper"];
		restartButton = this["restartButton"];
		tryAgain = this["tryAgain"];
		doLater(this, "initialize");
		amount = this["amount"];
		bet = this["bet"];
		colour = this["colour"];
		result = this["result"];
		title = this["title"];
		amountTitle = this["amountTitle"];
		betTitle = this["betTitle"];
		history = new Array();
		for (var i=0; i < 10; i++){
			history[i]={
				amount:this["amount"+i],
				bet:this["bet"+i],
				colour:this["colour"+i],
				result:this["result"+i]
			}
		}
	}
	function initialize() : Void {
		stepper.addEventListener("change", this);
		restartButton.addEventListener("click", this);
		tryAgain.addEventListener("click", this);
		framePosition = frame._y;
		amountTitlePosition = amountTitle._y;
		betTitlePosition = betTitle._y;
		endNotePosition = endNote._y;
		tryAgainPosition = tryAgain._y;
		restart();
	}
	function change(event:Object) : Void {
		/*trace(event.target);
		for(var name:String in event) {
			trace("event[" + name + "] = " + event[name]);
		}*/
		redNumber = stepper.value;
		//trace("stepper="+stepper.value);
		makeCards();
	}
	function click() : Void {
		//trace("click");
		if (cardActive){
			restart();
		}
	}
	function restart(){
		restartButton.visible = false;
		tryAgain.visible = false;
		endNote._visible = false;
		redNumber = stepper.value;
		for (var i=0; i < redNumber + 5; i++){
			history[i].amount.text="",
			history[i].bet.text="",
			history[i].colour.text="",
			history[i].result.text=""
		}
		amountN = 128;
		cardActive = true;
		amountTitle.text = "You now have";
		betTitle.text = "and you'll bet";
		endTitle.text="";
		frame._y = framePosition;
		amountTitle._y = amountTitlePosition;
		betTitle._y = betTitlePosition;
		endNote._y = endNotePosition;
		tryAgain._y = tryAgainPosition;
		colourTitle.text = "";
		resultTitle.text = "";
		history[0].amount.text = "£ "+amountN;
		title.textColor = 0x000000;
		title.text = "Choose a red card to win or a black card to lose!"
		history[0].bet.text = "£ "+(amountN/2);
		result.text="";
		makeCards();
	}
	function makeCards(){
		if (cards != null) {
			for (var i:Number = 0; i < cards.length; i++) {
				cards[i].removeMovieClip()
			}
		}
		stepper.visible = true;
		restartButton.visible = false;
		cards = new Array();
		order = new Array();
		depths = new Array();
		for (var i:Number = 0; i < redNumber; i += 1) {
			var c:MovieClip = attachMovie("RedCard", "rc"+i, i, {_x:i*40, _y:i*10, red:true});
			cards.push(c);
			depths[i] = c;
		}
		for (var j:Number = 0; j<3; j += 1) {
			var c:MovieClip = attachMovie("BlackCard", "bc"+j, i+j, {_x:300+j*40, _y:j*10, red:false});
			cards.push(c);
			depths[i+j] = c;
		}
	}
	function dropCard(card:Card) : Object {
		if (cardActive) {
			cardActive = false;
			order.push(card);
			if (order.length == 1) {
				stepper.visible = false;
				restartButton.label = "Restart";
				restartButton.visible = true;
			}
			red = card.red;
			l = order.length-1;
			if (onEnterFrame == null) {
				t0 = getTimer();
				t1 = t0 + time;
				onEnterFrame = doAnimation;
			}
			return {x: table["slot"+(order.length-1)]._x+table._x, y: table["slot"+(order.length-1)]._y+table._y};}
	}
	function makeTop(card:Card) : Void {
		for (var i:Number = card.getDepth() +1; i < depths.length; i++) {
			card.swapDepths(depths[i]);
			var mc:MovieClip = depths[i];
			depths[i] = card;
			depths[i-1] = mc;
		}
	}
	function doAnimation () {
		var t:Number = getTimer();
		var p:Number = (t-t0)/(t1-t0);
		var progress:Number = p*5;
		if (progress <= 1) { 
			stepOne();
		}
		else if (progress <= 3) {
			stepTwo();
		}
		/*else if (progress <= 5) {
			stepThree();
		}*/
		else {
			if (red){
				amountN *= 3/2;
			}
			else {
				amountN *= 1/2;
			}
			if (order.length < redNumber + 3) {
				doStart();
			}
			else {
				doEnd();
			}
		}
	}
	function doStart() {
		moveFrame();
		history[l+2].amount.text = "£ "+amountN;
		history[l+2].bet.text = "£ "+(amountN/2); 
		title.textColor=0x000000;
		title.text = "\n Choose \n another \n card! ";
		onEnterFrame = null;
		cardActive = true;
		}
	function doEnd() {
		cardActive = true;
		restartButton.label = "Try again";
		moveFrame();
		history[l+2].amount.text = "£ "+amountN;
		betTitle.text = "";
		title.textColor=0xFF0000;
		title.text = "\n The game \n is over ";
		endTitle._y = amountTitle._y;
		endTitle.text = "You started with £ 128\n so you lost this time!";
		var pom:Number = 7 - l;
		tryAgain._y -= pom * 20;
		endNote._y -= pom * history[0].amount._height;
		tryAgain.visible = true;
		endNote._visible = true;
		onEnterFrame = null;
	}
	function moveFrame() {
		var h:Number = history[0].amount._height;
		if (l == 0) {
			frame._y +=  2*h;
			amountTitle._y +=  2*h;
			betTitle._y +=  2*h;
		}
		else {
			frame._y +=  h;
			amountTitle._y +=  h;
			betTitle._y +=  h;
			history[l+1].amount.text = "";
			history[l+1].bet.text = ""; 
		}
		history[l].amount._visible = true;
		history[l].bet._visible = true;
	}
	function stepOne() {
		title.text = "";
		if (l==0){
			colourTitle.text = "You chose";
		}
		else {
			history[l].amount._visible = false;
			history[l].bet._visible = false;
		}
		history[l].amount.text = "£ "+amountN;
		history[l].bet.text = "£ "+(amountN/2); 
		if (red){
			history[l].colour.textColor=0xFF0000;
			history[l].colour.text = "red";
		}
		else {
			history[l].colour.textColor=0x000000;
			history[l].colour.text = "black";
		}
	}
	function stepTwo() {
		if (l==0){
			resultTitle.text = "Result";
		}
		if (red){
			history[l].result.textColor=0xFF0000;
			history[l].result.text = "+ £ "+(amountN/2);
			title.textColor=0xFF0000;
			title.text = "\n You won \n £ "+amountN/2;
		}
		else {
			history[l].result.textColor=0x000000;
			history[l].result.text = "- £ "+(amountN/2);
			title.textColor=0x000000;
			title.text = "\n You lost \n £ "+amountN/2;
		}
	}
	/*function stepThree() {
		
	}*/
}
