﻿class EquationObject {
	//Takes a string as input.
	function EquationObject(str) {
		equation = str;
		parse();
	}
	//#########################################################
	var equation = "";
	var className = "EquationObject";
	var hiddenMultiplier = "\u0012";
	var info = {type:"string", typeData:"", childObjects:{}};
	//type: operator, function and string; and childObject
	//equation supplied by initObject
	var operatorSet = "+-=><*/"+hiddenMultiplier+"^+-";
	//becareful, it is important  for the order of operator in this operatorSet 
	//the first  +- is for addition and subtracftion and the last +- is for sign
	//###############################################################
	function setEquation(str) {
		if (str == null) {
			str = "";
		}
		equation = str;
		parse();
	}
	//##############################################################
	function parse() {
		if (equation == null) {
			return;
		}
		var str = equation;
		//trim space
		str = str.split(" ").join("");
		//-----------------------------------------------------
		//handle the hidden multiplier such as (a-b)(c+d); there is an omitted multiplier between parenthesis block
		var strArr = str.split(")");
		for (var k = 1; k<strArr.length; k++) {
			if (strArr[k].substr(0, 1) == "(") {
				strArr[k] = hiddenMultiplier+strArr[k];
			}
		}
		str = strArr.join(")");
		var str2 = maskParenthesis(str);
		//search for  +,-,=,>,<    , skip string in parenthesis and cut into pieces accordingly
		//after the first step ,  only function and parenthesis and variable or number is left
		for (var k = 0; k<operatorSet.length; k++) {
			var op = operatorSet.charAt(k);
			var start = str.length-1;
			var i = 0;
			while ((i=str2.lastIndexOf(op, start))>=0) {
				if ((k<=1) && operatorSet.indexOf(str2.charAt(i-1))>=0) {
					//something like 3*-4;  
					start = i-1;
					continue;
				}
				//split  to recursive function and return;
				var lStr = str.substr(0, i);
				var rStr = str.substr(i+1, str.length-i-1);
				//trace(lStr+"["+op+"]"+rStr);
				var childObjects = [];
				childObjects[0] = new EquationObject(lStr);
				childObjects[1] = new EquationObject(rStr);
				info = {type:"operator", typeData:op, childObjects:childObjects};
				return;
			}
		}
		//------------------------------------------
		//now we get only the parenthesis,function and pure number/variable here;
		var start = str.indexOf("(");
		if (start>=0) {
			var functionName = (str.substr(0, start)).toLowerCase();
			var contentInParenthesis = str.substr(start+1, str.length-start-2);
			//trace("content="+contentInParenthesis);
			//there might be more than one parameters separated by ',', so parese the parameter and create clip for each parameter;
			var childObjects = parseFunctionArgument(contentInParenthesis);
			info = {type:"function", typeData:functionName, childObjects:childObjects};
			//layoutManager.layout(info);
			//here arrange these clips, parenthesis and function name
			return;
		}
		//---------------------------------------------
		//After those steps , only pure number, and variable left here now
		info = {type:"string", typeData:str};
		//layoutManager.layout(info);
		//most of the time, we display Number, but sometime we need to convert PI  into symbol, so I add this function here
	}
	//#################################################
	function parseFunctionArgument(str) {
		// cut arguments into parameters
		var childObjects = [];
		var start = 0;
		var paramStr = [];
		var parenthesisStack = 0;
		for (var i = 0; i<str.length; i++) {
			var char = str.substr(i, 1);
			if (char == "(") {
				parenthesisStack++;
			}
			if (char == ")") {
				parenthesisStack--;
			}
			if ((char == ",") && parenthesisStack == 0) {
				paramStr.push(str.substr(start, i-start));
				start = i+1;
			}
		}
		paramStr.push(str.substr(start, str.length-start));
		for (var j = 0; j<paramStr.length; j++) {
			childObjects[j] = new EquationObject(paramStr[j]);
		}
		return childObjects;
	}
	//---------------------------------------------------
	function maskParenthesis(str) {
		var parenthesisStack = 0;
		//prepare to skip the first level parenthesis
		var temp = [];
		for (var i = 0; i<str.length; i++) {
			var char = str.substr(i, 1);
			if (char == ")") {
				parenthesisStack++;
			}
			if (char == "(") {
				parenthesisStack--;
			}
			if (parenthesisStack == 0) {
				temp.push(char);
			} else {
				temp.push("(");
			}
		}
		if (parenthesisStack != 0) {
			trace("parenthesis not match");
			return;
		}
		var str2 = temp.join("");
		//trace(str+"=="+str2);
		return str2;
	}
}
