﻿
class Lines extends MovieClip {
	
	var n:Number = 2; //Number of lines.
	var cols:Array; //Array of colours, one per line.
	var square_width:Number = 10; //Width of square from grid.
	var number_squares:Number = 30;// Number of squares across in grid.
	var intervalID:Number = null; //Set interval left running.
	
	//Constructor.
	function Lines() {
		drawGrid();
		attachLines();
		intervalID = setInterval(this,"drawLines",10);
	}
	
	//Draw the grid.
	function drawGrid():Void {
		
		//New grid.
		this["grid"].removeMovieClip();
		this.createEmptyMovieClip("grid",this.getNextHighestDepth());
		
		//Make sure number_squares is even.
		if (number_squares % 2 == 1) number_squares++;
		var L:Number = number_squares*0.5*square_width;
		
		//Draw grid lines.
		this["grid"].lineStyle(1,0x000000,50);
		for (var i:Number = 1; i != number_squares; i++) {
			this["grid"].moveTo(L,-L+i*square_width);
			this["grid"].lineTo(-L,-L+i*square_width);
			this["grid"].moveTo(-L+i*square_width,-L);
			this["grid"].lineTo(-L+i*square_width,L);
		}
		
		//Draw outline of box.
		this["grid"].lineStyle(1,0x000000,100);
		this["grid"].moveTo(L,L);
		this["grid"].beginFill(0xcccccc,50);
		this["grid"].lineTo(L,-L);
		this["grid"].lineTo(-L,-L);
		this["grid"].lineTo(-L,L);
		this["grid"].lineTo(L,L);
		this["grid"].endFill();
		
		//Draw axes.
		this["grid"].lineStyle(2,0x000000,100);
		this["grid"].moveTo(-L,0);
		this["grid"].lineTo(L,0);
		this["grid"].moveTo(0,-L);
		this["grid"].lineTo(0,L);
	}
	
	//Attach the lines and the algebra.
	function attachLines() {
		
		for (var i:Number = 0; i != n; i++) { 
			this.createEmptyMovieClip("graph"+i,this.getNextHighestDepth());
			var a = AlgebraBox(attachMovie("AlgebraBox","algbox"+i,this.getNextHighestDepth(),
			{_x:-30,_y:150+50*i,h:60,w:80,colour:cols[i]}));
		}
			
		for (var i:Number = 0; i != n; i++) {	
			//Attach ith red and blue spots.
			var r = this.attachMovie("red_spot","red"+i,this.getNextHighestDepth(),{_y:square_width*i});
			var b = this.attachMovie("blue_spot","blue"+i,this.getNextHighestDepth(),{_x:square_width*(i+2)});
			r.go = b.go = false; //True iff should be moving.
			r.onPress = b.onPress = r.onRelease = r.onReleaseOutside = b.onRelease = 
			b.onReleaseOutside = function() { this.go = (this.go) ? false : true;}
		}			
	}
	
	//Adjust position of points then draw the lines between the points.
	function drawLines() {
		
		//Record mouse positions.
		var X = this._xmouse;
		var Y = this._ymouse;
		var L = number_squares*0.5*square_width;
		
		//Adjust red and blue points.
		for (var i:Number = 0; i != n; i++) {
			
			if (this["red"+i].go) {
				var old = this["red"+i]._y;
				if (Math.abs(Y) < L+0.1)
					this["red"+i]._y = Math.round(Y/square_width)*square_width;
				else if (Y>L) this["red"+i]._y  = L;
				else if (Y<-L) this["red"+i]._y  = -L;
				this["blue"+i]._y += this["red"+i]._y-old;
			}
			if (this["blue"+i].go) {
				if (Math.abs(Y) < L+0.1)
					this["blue"+i]._y = Math.round(Y/square_width)*square_width;
				else if (Y>L) this["blue"+i]._y  = L;
				else if (Y<-L) this["blue"+i]._y  = -L;
				if (Math.abs(X) < L+0.1)
					this["blue"+i]._x = Math.round(X/square_width)*square_width;
				else if (X>L) this["blue"+i]._x  = L;
				else if (X<-L) this["blue"+i]._x  = -L;
			}
			//Make blue invisible if off screen.
			this["blue"+i]._visible = (this["blue"+i]._y > L || this["blue"+i]._y < -L) ? false : true;
			
		}
		
		//Redraw graph.
		for (var i:Number = 0; i != n; i++) {
			this["graph"+i].clear();
			this["graph"+i].lineStyle(2,cols[i],100);
			
			//Cleanest method of drawing graph is probably to find the end points.
			//Let end points be (p,q) and (u,v).
			var p,q,u,v:Number;
			var a = 0; var b = this["red"+i]._y;
			var c = this["blue"+i]._x; var d = this["blue"+i]._y;
			if (c<0) { c = -c; d = 2*b-d;}
			if (c<0.1) {
				p=u=0;
				q = -L;
				v = L; 
				updateEquation(i,null,null,null);
			} else {
				updateEquation(i,(d-b),c,b);
				if (Math.abs(b+(d-b)*L/c)<L+0.1) {
					p = L;
					q = b+(d-b)*L/c;
				} else {
					q = (d>b) ? L : -L;
					p = (q-b)*c/(d-b);
					
				}
				if (Math.abs(b-(d-b)*L/c)<L+0.1) {
					u = -L;
					v = b-(d-b)*L/c;
				} else {
					v = (d>b) ? -L : L;
					u = -(b-v)*c/(d-b);
				}
			}
			this["graph"+i].moveTo(p,q);
			this["graph"+i].lineTo(u,v);
			
		}
	}
	
	//Update equation i. y=mx+c
	function updateEquation(i,m_num,m_den,cc:Number) {
		
		var cc = -cc/square_width;
		var algebra:String = null;
		if (m_num==null) algebra = "x=0";
		else if (m_num==0) algebra = "y = "+cc;
		else {
			var c:Number = (cc>0) ? cc : -cc;
			var plus_or_minus:String = (cc>0) ? "+" : "-";
			var h:Number = hcf(Math.abs(m_num),Math.abs(m_den));
			var top:String = (Math.abs(m_num/h)==1) ? "" : Math.abs(m_num/h);
			var bot:Number = Math.abs(m_den/h);
			var sign:String = (m_num*m_den>0) ? "-" : "";
			
			if (c != 0) {
				if (bot==1) algebra = "y = "+sign+top+"x"+plus_or_minus+c;
				else algebra = "y = "+sign+top+"x"+"/"+bot+plus_or_minus+c;
			} else {
				if (bot==1) algebra = "y = "+sign+top+"x";
				else algebra = "y = "+sign+top+"x"+"/"+bot;
			}
		}
		
		this["algbox"+i].algebra = algebra;
		this["algbox"+i].createMaths();
	}
	
	//Finds hcf.
	function hcf(m_num,m_den:Number):Number {
		var h:Number = 1;
		for (var i:Number = 1; i!=Math.min(m_num,m_den)+1; i++) 
			if (m_num % i == 0 && m_den % i == 0) h = i;
		return h;
	}
	
}