﻿import RimPoint;
class Protractor extends MovieClip {
	var d_alpha:Number = Math.PI/180;
	var tick:Number = Math.PI/36;
	var radius:Number = 100;
	var tickLength:Number = 4;
	var rgb:Number = 0x333333;
	var white:Number = 0xFFFFFF;
	var p:RimPoint;
	var pressedx:Number;
	var pressedy:Number;
	var pressedr:Number;
	var rotation:Number;
	var over:Boolean = false;
	function Protractor() {
		draw();
		onMouseMove = pos;
		over = false;
		_parent._parent.mouse_pos.text = "";
	}
	function draw():Void {
		clear();
		fillCircle(radius+20);
		drawCircle(radius, rgb);
		drawCircle(radius+3*tickLength, white);
		drawCircle(radius-3*tickLength, white);
		//drawTicks();
		drawAxes();
	}
	function drawCircle(r:Number, col:Number) {
		lineStyle(1, col, 50);
		moveTo(r, 0);
		for (var alpha:Number = d_alpha; alpha<2*Math.PI; alpha += d_alpha) {
			lineTo(r*Math.cos(alpha), r*Math.sin(alpha));
		}
	}
	function fillCircle(r:Number) {
		lineStyle(0,0,0);
		moveTo(r, 0);
		beginFill(0x22CC00, 34);
		for (var alpha:Number = d_alpha; alpha<2*Math.PI; alpha += d_alpha) {
			lineTo(r*Math.cos(alpha), r*Math.sin(alpha));
		}
		endFill();
	}
	function drawTicks() {	
		//moveTo(radius, 0);
		lineStyle(1, rgb);
		for (var alpha:Number = 0; alpha<2*Math.PI; alpha += tick) {
			moveTo((radius-tickLength)*Math.cos(alpha), (radius-tickLength)*Math.sin(alpha));
			lineTo((radius+tickLength)*Math.cos(alpha), (radius+tickLength)*Math.sin(alpha));
		}
	}
	function drawAxes() {
		lineStyle(1, rgb);
		moveTo(-radius,0);
		lineTo(radius,0);
		moveTo(0,-radius);
		lineTo(0,radius);
	}
	function onPress() {
		//trace("Hello");
		_parent._parent.mouse_pos._visible = false;
		var d:Number = Math.sqrt(_xmouse*_xmouse+_ymouse*_ymouse);
		if(d > radius+3*tickLength) {
			pressedx = _root._xmouse - _parent._x;
			pressedy = _root._ymouse - _parent._y;
			pressedr = radius;
			onMouseMove = scale;
		}
		else if (d > radius-3*tickLength) {
			pressedx = _root._xmouse - _parent._x;
			pressedy = _root._ymouse - _parent._y;
			rotation = _parent._rotation;
			onMouseMove = turn;
		}
		else {
			_parent.startDrag();
			onMouseMove = move;
		}
	}
	function onRelease() {
		_parent.stopDrag();
		_parent._parent.my_status.text = "";
		onMouseMove = pos;
		over = true;
	}
	function onReleaseOutside() {
		_parent.stopDrag();
		_parent._parent.my_status.text = "";
		onMouseMove = pos;
		over = false;
	}
	function onRollOut() {
		_parent._parent.my_status.text = "";
		over = false;
	}
	function onRollOver() {
		over = true;
	}
	function turn() {
		//trace("ahoj")
		var angle1:Number = Math.atan2(_root._ymouse-_parent._y,_root._xmouse-_parent._x);
		var angle2:Number = Math.atan2(pressedy,pressedx);
		//trace("angle1 = " + angle1 + " angle2 = " + angle2); 
		_parent._rotation = rotation+(angle1-angle2)*180/Math.PI;
		p.moveText();
	}
	
	function move() {
		p.moveText();
	}
	
	function scale() {
		var rx:Number = _root._xmouse-_parent._x;
		var ry:Number = _root._ymouse-_parent._y;
		radius = pressedr*Math.sqrt((rx*rx+ry*ry)/(pressedx*pressedx+pressedy*pressedy));
		draw();
		p.draw();
		//p.moveText();
	}
	
	function pos() {
		if (!over)
			return;
		var d:Number = Math.sqrt(_xmouse*_xmouse+_ymouse*_ymouse);
		if(d > radius+3*tickLength) {
			_parent._parent.my_status.text = "scale protractor";
		}
		else if (d > radius-3*tickLength) {
			_parent._parent.my_status.text = "turn protractor";
		}
		else {
			_parent._parent.my_status.text = "move protractor";
		}
	}
			
	
	/*
	var alpha:Number = d_alpha; 
	while(alpha<2*Math.PI) {
	lineTo(radius*Math.cos(alpha),radius*Math.sin(alpha));
	alpha+=d_alpha;
	}
	*/
}
