﻿class Board extends MovieClip {
	var x1, y1, x2, y2:Number;
	var numTriangles = 0;
	var triangles:Array = Array();
	var triangle:MovieClip;
	var xc, yc, r:Number;
	var hint1:String = "click to start the hypotenuse";
	var hint2:String = "drag and click to fix";
	var hint3:String = "click to place last corner";
	function Board() {
		onPress = onPress1;
	}
	function reset() {
		onPress = onPress1;
		onMouseMove = null;
		if (triangle != null) triangle.clear();
		triangle = null;
	}
	function removeTriangle() {
		if (numTriangles == 0)
			return;
		numTriangles--;
		var obj:Object = triangles.pop();
		obj.clear();
		removeMovieClip(obj);
		triangle = null;
		if (enabled) {
			onMouseMove = null;
			onPress = onPress1;
			_parent.my_status.text = hint1;
		}
	}
	function onPress1():Void {
		x1 = _xmouse;
		y1 = _ymouse;
		triangle = attachMovie("MyTriangle", "triangle"+numTriangles++, getNextHighestDepth());
		triangles.push(triangle);
		onMouseMove = onMouseMove2;
		onPress = onPress2;
		_parent.my_status.text = hint2;
	}
	function onMouseMove2():Void {
		triangle.clear();
		triangle.lineStyle(1);
		triangle.moveTo(x1, y1);
		triangle.lineTo(_xmouse, _ymouse);
	}
	function onPress2():Void {
		x2 = _xmouse;
		y2 = _ymouse;
		triangle.clear();
		triangle.lineStyle(1);
		triangle.moveTo(x1, y1);
		triangle.lineTo(x2, y2);
		xc = (x1 + x2) / 2;
		yc = (y1 + y2) / 2;
		r = 0.5 * Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
		onMouseMove = onMouseMove3;
		onPress = onPress3;
		_parent.my_status.text = hint3;
	}
	function onMouseMove3():Void {
		var my_x, my_y, my_r:Number;
		my_r = Math.sqrt((_xmouse - xc) * (_xmouse - xc) + (_ymouse - yc) * (_ymouse - yc));
		if (my_r == 0)
			return;
		if (_parent.snap_angles.selected) {
			var angle1 = Math.atan2(y2 - y1, x2 - x1);
			var angle2 = Math.atan2(_ymouse - yc, _xmouse - xc);
			var angle = 360 * (angle1 - angle2) / (2 * Math.PI);
			angle = 10 * (Math.round(angle / 10));
			angle2 = angle1 - 2 * Math.PI * angle / 360;
			my_x = xc + r * Math.cos(angle2);
			my_y = yc + r * Math.sin(angle2);
		}
		else {
			my_x = xc + r * (_xmouse - xc) / my_r;
			my_y = yc + r * (_ymouse - yc) / my_r;
		}
		if ((my_x == x1 && my_y == y1) ||
			(my_x == x2 && my_y == y2))
			return;
		triangle.clear();
		triangle.lineStyle(1);
		triangle.beginFill(0xFFFF00, 10);
		triangle.moveTo(x1, y1);
		triangle.lineTo(x2, y2);
		triangle.lineTo(my_x, my_y);
		triangle.lineTo(x1, y1);
		triangle.endFill();
	}
	function onPress3():Void {
		var my_x, my_y, my_r:Number;
		my_r = Math.sqrt((_xmouse - xc) * (_xmouse - xc) + (_ymouse - yc) * (_ymouse - yc));
		if (my_r == 0)
			return;
		if (_parent.snap_angles.selected) {
			var angle1 = Math.atan2(y2 - y1, x2 - x1);
			var angle2 = Math.atan2(_ymouse - yc, _xmouse - xc);
			var angle = 360 * (angle1 - angle2) / (2 * Math.PI);
			angle = 10 * (Math.round(angle / 10));
			angle2 = angle1 - 2 * Math.PI * angle / 360;
			my_x = xc + r * Math.cos(angle2);
			my_y = yc + r * Math.sin(angle2);
		}
		else {
			my_x = xc + r * (_xmouse - xc) / my_r;
			my_y = yc + r * (_ymouse - yc) / my_r;
		}
		if ((my_x == x1 && my_y == y1) ||
			(my_x == x2 && my_y == y2))
			return;
		triangle.clear();
		triangle.lineStyle(1);
		triangle.beginFill(0xFFFF00, 60);
		triangle.moveTo(x1, y1);
		triangle.lineTo(x2, y2);
		triangle.lineTo(my_x, my_y);
		triangle.lineTo(x1, y1);
		triangle.endFill();
		triangle = null;
		onMouseMove = null;
		onPress = onPress1;
		_parent.my_status.text = hint1;
	}
}