﻿class Colour {
	//
	// Hue, Saturation & Brightness control
	// a = colour, v = a greyscale [0..255], mix = amount of grey.
	//
	static function tintColor(a:Number, v:Number, mix:Number):Number {
		var r1 = a >> 16;
		var g1 = (a >> 8) & 0xFF;
		var b1 = a & 0xFF;
		r1 = r1*(1-mix)+v*mix;
		g1 = g1*(1-mix)+v*mix;
		b1 = b1*(1-mix)+v*mix;
		return (r1 << 16) | (g1 << 8) | b1;
	}
	//
	// returns a random bright color
	//
	static function getRainbowColor():Number {
		var a = Math.PI*2*Math.random();
		var r = 128+Math.cos(a)*127;
		var b = 128+Math.cos(a+2*Math.PI/3)*127;
		var g = 128+Math.cos(a+4*Math.PI/3)*127;
		return (r << 16) | (g << 8) | b;
	}
	//
	// returns a random light colour
	//
	static function getCandyColor(r:Number):Number {
		var v = 128+random(127);
		return tintColor(getRainbowColor(), v, .5);
	}
}
