﻿//import Constants;
class BallPot extends Ball implements SourcePot {
	var __balls:Array;
//	var __radius:Number = 100;
	var _alpha = 100;
	var _colour:Number = 0xdddddd;
	var _baseRadius:Number = 100;
	var isPot:Boolean = true;
	//
	// constructor
	//
	function BallPot() {
	}
	//
	// accessors
	//
	function get guys():Array {
		return __balls;
	}
	function set guys(balls:Array):Void {
		__balls = balls;
	}
	function get maxBallRadius():Number {
		var max = 0;
		for(var i = 0; i < __balls.length; i++) {
			max = Math.max(max, __balls[i].radius);
		}
		return max;
	}
	function addBall(b:Ball):Void {
		if (__balls == null) {
			__balls = new Array();
		}
		for (var i = 0; i<__balls.length; i++) {
			if (__balls[i] == b) {
				return;
			}
		}
		__balls.push(b);
	}
	function removeBall(b:Ball):Void {
		if (__balls == null) {
			return;
		}
		for (var i = 0; i<__balls.length; i++) {
			if (__balls[i] == b) {
				__balls.splice(i, 1);
				return;
			}
		}
	}
	function drop():Ball {
		var b = __balls.pop();
		b.pot = null;
		//_dropped.push(b);
		return b;
	}
	function activate() {
		for (var i = 0; i<guys.length; i++) {
			guys[i].wakeup();
		}
	}
	//
	// Initialise BallPot
	//
	var pop_snd:Sound;
	static var ballId:Number = 10000;
	function init(x:Number, y:Number, r:Number, balls:Number, colour:Number, alpha:Number):Void {
		//trace("Pot("+x+","+y+")");
		__balls = new Array();
		_alpha = alpha;
		_colour = colour;
		//__ballCount = balls;
		//_baseRadius=radius = r;
		_baseRadius = radius=r;
		//_baseRadius = 100*radius/_global.scale;
		xcentre = x;
		ycentre = y;
		// Setup balls in random positions in the well
		var pos:Array = Constants["relpos"+balls];
		for (var i = 0; i<balls; ++i) {
			//var depth = _global.depth++;
			var mc = _level0.attachMovie("Ball", "ball"+(++BallPot.ballId), _global.depth++);
			//trace(this+" ballId="+ballId);
			if (pos[i] != null) {
				var xpos = x+pos[i][0];
				var ypos = y+pos[i][1];
				mc.init(xpos, ypos, Constants.kMaxRadius, this);
			} else {
				mc.init(x+Math.random()-0.5, y+-Math.random()-0.5, Constants.kMaxRadius, this);
			}
			//__balls.push(mc);
			//trace("__balls.length="+__balls.length);
			drawBall(mc, 0x008800/*Constants.getCandyColor(null)*/);
		}
		/*
		if(colour == null) {
			_colour = Constants.getCandyColor(null);
		}
		*/
		drawSphere(_colour, alpha);
		
		//trace("colour="+_colour+" alpha="+_alpha);
		//activate();
	}
	function drawBall(mc:MovieClip, rgb:Number):Void {
		mc.drawSphere(rgb, 100);
	}
	static var potId:Number = 0;
	function clone(gridPot:GridPot):BallPot {
		//this.duplicateMovieClip("pot"+(++potId), _parent.depth());
		//return BallPot(this["pot"+potId]);
		//trace("cloning: "+this+" guys.length="+(guys == null ? "null" : guys.length));
		var newPot:BallPot = BallPot(_level0.attachMovie("Group", "pot"+(++potId), _global.depth++));
		//trace("newPot="+newPot);
		//trace("guys[0]="+guys[0]);
		//trace("guys[1]="+guys[1]);
		if (guys == null || guys.length == 0) {
			trace("null guys should not happen?");
		}
		var pos:Array = Constants["relpos"+guys.length];
		if (BallPot(guys[0]) == null) {
			//trace("balls");
			newPot.init(xcentre, ycentre, __radius, 0, _colour, _alpha);
			for (var i = 0; i<guys.length; i++) {
				var ball = gridPot.drop();
				ball.pot = newPot;
				if (ball.getDepth()<newPot.getDepth()) {
					ball.swapDepths(newPot);
				}
				ball.wakeup();
			}
			return newPot;
		} else {
			//trace("guys[0]="+guys[0]);
			//trace("guys[1]="+guys[1]);
			var r = requiredRadius(guys[0].radius, guys.length);
			//trace("radius = "+r);
			newPot.init(xcentre, ycentre, r, 0, _colour, _alpha);
			for (var i = 0; i<__balls.length; i++) {
				var pot:BallPot = __balls[i];
				var c = pot.clone(gridPot);
				c.pot = newPot;
				if (c.getDepth()<newPot.getDepth()) {
					c.swapDepths(newPot);
				}
				//newPot.guys.push(c);
				c.radius = pot.radius;
				c.vx = 0;
				c.vy = 0;
				c.wakeup();
			}
		}
		return newPot;
	}
	function reOrderDepths() {
		// make sure this is under its children
		if (guys == null || guys.length == 0 || BallPot(this) == null) {
			return;
		}
		for (var i = 0; i<guys.length; i++) {
			var ball = guys[i];
			ball.reOrderDepths();
			if (getDepth()>ball.getDepth()) {
				swapDepths(ball);
			}
		}
	}
	static function requiredRadius(r:Number, n:Number):Number {
		return r*(Math.sqrt(6.5*n/3));
	}
	function settled():Boolean {
		//trace("s");
		if (guys == null || guys.length == 0) {
			return true;
		}
		var active = false;
		for (var i = 0; i<guys.length; i++) {
			var b:Ball = guys[i];
			b.radius*(b.xcentre-xcentre)/radius;
			if (!hitTest(b.xcentre+b.radius*(b.xcentre-xcentre)/(2*radius), b.ycentre+b.radius*(b.ycentre-ycentre)/(2*radius), true)) {
				return false;
			}
			if (b.vx*b.vx+b.vy*b.vy>0.1) {
				return false;
			}
		}
		for (var i = 0; i<guys.length; i++) {
			guys[i].sleep();
		}
		return true;
	}
	function remove() {
		//trace("removing "+__balls.length + " from " + this);
		while (__balls.length>0) {
			var b = __balls.pop();
			if (BallPot(b) == null) {
				//trace("sendTotrash");
				b.sendToTrash();
			} else {
				//trace("don't sendToTrash");
				b.remove();
			}
		}
		//}
		this.removeMovieClip();
	}
	function removeAndDestroy() {
		while (__balls.length>0) {
			var b = __balls.pop();
			b.remove();
		}
		//}
		this.removeMovieClip();
	}
	function rescale() {
		for (var i = 0; i<__balls.length; i++) {
			var b = __balls[i];
			b.rescale();
			b.wakeup();
		}
		__radius = _baseRadius*(_global.scale/100);
		_xscale = _global.scale;
		_yscale = _global.scale;
		wakeup();
	}
	function wakeupAll() {
		for(var i = 0; i < __balls.length; i++) {
			var b = __balls[i];
			b.wakeupAll();
		}
		wakeup();
	}
	function setRadius(r:Number) {
		_baseRadius = r;
		__radius = _baseRadius*_global.scale/100;
		_xscale = _global.scale;
		_yscale = _global.scale;
		wakeup();
	}
}
