﻿class GraphPanel extends Panel {
	
	var points:Array; //Points that are plotted.
	var nPoints:Number = 100; //Number of points.
	
	//Constructor.
	function GraphPanel() {
		
		blankPanel();
		
		//Array to store points.
		points = new Array(100);
		var gap = 200/(nPoints-1);
		for (var i:Number = 0; i!=100; i++) points[i] = [-100+gap*i,0];
	}
	
	//Blank panel.
	function blankPanel() {
		this.createEmptyMovieClip("blank",this.getNextHighestDepth());
		this.createEmptyMovieClip("maskIt",this.getNextHighestDepth());
		this["maskIt"].attachMovie("black","black",this["maskIt"].getNextHighestDepth());
		this["blank"].setMask(this["maskIt"]["black"]);
	}

	
	//This part needs changing to plot different graphs.
	function moveControl() {
		this["blank"].clear();
		this._parent.drawCurve(this["blank"]);		
	}
	
	
}