﻿//Move p and q around.

class CoefficientPanel extends Panel {
	
	var drag:Boolean = false; //True iff dragging spot.
	var obj:Object; //For key control of the spot.
	
	//Constructor
	function CoefficientPanel() {
		
		axesSpots();
		spotControl();
		position();
		keyControl();
		
		//Label axes.
		this["x_label"].text = "p";
		this["y_label"].text = "q";
	}
	
	//Attach axes markers.
	function axesSpots() {
		var t = this.createEmptyMovieClip("q_spot",this.getNextHighestDepth());
		t.lineStyle(2,0x000000,100);
		t.moveTo(-3,0);
		t.lineTo(3,0);
		t.duplicateMovieClip("p_spot",this.getNextHighestDepth());
		this["p_spot"]._rotation = 90;
	}
	
	//Add a spot at (0,0) and give it control.
	function spotControl(){
		//Attach spot.
		var spot = this.attachMovie("spot","spot",this.getNextHighestDepth(),{_x:0,_y:0});
		spot.onPress = pressControl;
		spot.onRelease = releaseControl;
		spot.onReleaseOutside = releaseControl;
		spot.onMouseMove = moveControl;
	}
	
	//What happens when spot pressed.
	function pressControl(){
		this.startDrag();
		this._parent.drag=true;
	}
	
	//What happens when spot released.
	function releaseControl(){
		this.stopDrag();
		this._parent.drag=false;
	}
	
	//Records the position of p and q.
	function position(){
		this.createTextField("ptext",this.getNextHighestDepth(),-98,-100,70,20);
		this.createTextField("qtext",this.getNextHighestDepth(),-98,-85,70,20);
		this["ptext"].selectable = this["qtext"].selectable = false;
		this["ptext"].text = "p = 0.00";
		this["qtext"].text = "q = 0.00";	
	}
	
	//What happens when mouse moved.
	function moveControl(){
		var tp = this._parent;
		if (tp.drag) {
			
			//Stop dragging if go outside region.
			var b:Boolean = true;
			if (this._x>100) {this._x = 100; b = false;}
			if (this._x<-100) {this._x = -100; b = false;}
			if (this._y>100) {this._y = 100; b = false;}
			if (this._y<-100) {this._y = -100; b = false;}
			if (!b) tp.releaseControl();
			
			//Arrange p and q spots.
			tp.p_spot._x = _x;
			tp.q_spot._y = _y;
			
			this._parent._parent.output();
			
			var pp = Math.floor(_x*100/tp.u)/100;
			var qq = -Math.floor(_y*100/tp.u)/100;
			this._parent["ptext"].text = "p = "+pp;
			this._parent["qtext"].text = "q = "+qq;
			
			updateAfterEvent();
		}
	}
	
	//Control of the spot via keys.
	function keyControl() {
		
		//On pressing the shift key, switch between the different actions.
		obj = new Object();
		var mc = this;
		obj.onKeyDown = function() { 
			if ( Key.isDown(Key.UP) && mc["spot"]._y > -100) mc["spot"]._y--;
			if ( Key.isDown(Key.DOWN) && mc["spot"]._y < 100) mc["spot"]._y++;
			if ( Key.isDown(Key.LEFT) && mc["spot"]._x > -100) mc["spot"]._x--;
			if ( Key.isDown(Key.RIGHT) && mc["spot"]._x < 100) mc["spot"]._x++;
			
			mc.p_spot._x = mc["spot"]._x;
			mc.q_spot._y = mc["spot"]._y;
			
			mc._parent.output();
			mc._parent.ro.moveControl();
			mc._parent.gr.moveControl();
			
			var pp = Math.floor(mc["spot"]._x*100/mc.u)/100;
			var qq = -Math.floor(mc["spot"]._y*100/mc.u)/100;
			mc["ptext"].text = "p = "+pp;
			mc["qtext"].text = "q = "+qq;
			
			updateAfterEvent();
		}
		Key.addListener(obj);
		
	}
	
	
	
}