﻿//We attach n spots and the control of these spots is determined by coef.

class RootPanel extends Panel {
	
	//Constructor
	function RootPanel() {
		trails();
		spots();
		
		//Label axes.
		this["x_label"].text = "u";
		this["y_label"].text = "v";
	}
	
	//Attach  spots.
	function spots() {
		for (var i:Number = 0; i!=this._parent.n; i++) {
			var s =this.attachMovie("spot","spot"+i,this.getNextHighestDepth(),{_x:0,_y:0});
			s.onPress = function() {
				for (var i:Number = 0; i!=this._parent._parent.n; i++) {
					this._parent["blank"+i].clear();
					this._parent["blank"+i].lineStyle(1,0x000000,50);
					this._parent["blank"+i].moveTo(this._parent["spot"+i]._x,this._parent["spot"+i]._y);
				}
			}
		}
	}
	
	
	//What happens when mouse moved.
	function moveControl(){ 
		for (var i:Number = 0; i!=this._parent.n; i++) {
			this["spot"+i]._x = this._parent.points[i][0];
			this["spot"+i]._y = this._parent.points[i][1];
			this["blank"+i].lineTo(this["spot"+i]._x,this["spot"+i]._y);
		}
		
		updateAfterEvent();
	}
	
	//Blank canvas for adding trails.
	function trails() {
		for (var i:Number = 0; i!=this._parent.n; i++) {
			var s = this.createEmptyMovieClip("blank"+i,this.getNextHighestDepth());
			s.moveTo(0,0);
			s.lineStyle(1,0x000000,50);
		}
	}
		
}