﻿class Panel extends MovieClip {
	
	var frameColour:String = "red"; //Colour of frame.
	var u:Number = 5; //Number of pixels in a unit.
	
	function Panel() {
		setColour();
		frameControl();
		axesLabels();
		axesMarkers();
		
		this.onMouseMove = moveControl;
	}
	
	function setColour() {
		switch (frameColour) {
			case "red":
				this.attachMovie("redFrame","frame",0);
				this.attachMovie("redPane","redPane",1);
			break;
			case "green":
				this.attachMovie("greenFrame","frame",0);
				this.attachMovie("greenPane","greenPane",1);
			break;
			case "blue":
				this.attachMovie("blueFrame","frame",0);
				this.attachMovie("bluePane","bluePane",1);
			break;
		}
	}
	
	//Movement of the frame.
	function frameControl() {
		this["frame"].onPress = function() { this._parent.startDrag();}
		this["frame"].onRelease = function() { this._parent.stopDrag();}
		this["frame"].onReleaseOutside = function() { this._parent.stopDrag();}
	}
	
	//Name the axes.
	function axesLabels() {
		this.createTextField("x_label",this.getNextHighestDepth(),90,0,40,20);
		this["x_label"].text = "x";
		this.createTextField("y_label",this.getNextHighestDepth(),2,-100,40,20);
		this["y_label"].text = "y";
		this["x_label"].selectable = this["y_label"].selectable = false;
	}

	
	//Markers along the axes.
	function axesMarkers() {
		this.createEmptyMovieClip("markers",this.getNextHighestDepth());
		var m = Math.floor(100/u);
		var tm = this["markers"];
		tm.lineStyle(1,0x000000,100);
		for (var i:Number = 1; i!=m; i++) {
			var q = (i%5 == 0) ? 4 : 2;
			tm.moveTo(i*u, -q); tm.lineTo(i*u,q);
			tm.moveTo(-i*u, -q); tm.lineTo(-i*u,q);
			tm.moveTo(-q,i*u); tm.lineTo(q,i*u);
			tm.moveTo(-q,-i*u); tm.lineTo(q,-i*u);
		}
	}
	

	
	//What happens to class when mouse moved.
	function moveControl() {}
}