﻿//Move p and q around.

class CoefficientPanel extends Panel {
	
	var drag:Boolean = false; //True iff dragging spot.
	var obj:Object;
	
	//Constructor
	function CoefficientPanel() {
		
		parabola();
		axesSpots();
		spotControl();
		position();
		keyControl();
		
		//Label axes.
		this["x_label"].text = "p";
		this["y_label"].text = "q";
		
	}
	
	//Attach axes markers.
	function axesSpots() {
		var t = this.createEmptyMovieClip("q_spot",this.getNextHighestDepth());
		t.lineStyle(2,0x000000,100);
		t.moveTo(-3,0);
		t.lineTo(3,0);
		t.duplicateMovieClip("p_spot",this.getNextHighestDepth());
		this["p_spot"]._rotation = 90;
	}
	
	//Add a spot at (0,0) and give it control.
	function spotControl(){
		//Attach spot.
		var spot = this.attachMovie("spot","spot",this.getNextHighestDepth(),{_x:0,_y:0});
		spot.onPress = pressControl;
		spot.onRelease = releaseControl;
		spot.onReleaseOutside = releaseControl;
		spot.onMouseMove = moveControl;
	}
	
	//What happens when spot pressed.
	function pressControl(){
		this.startDrag();
		this._parent.drag=true;
	}
	
	//What happens when spot released.
	function releaseControl(){
		this.stopDrag();
		this._parent.drag=false;
	}
	
	
	//Records the position of p and q.
	function position(){
		this.createTextField("ptext",this.getNextHighestDepth(),-98,-100,60,20);
		this.createTextField("qtext",this.getNextHighestDepth(),-98,-85,60,20);
		this["ptext"].selectable = this["qtext"].selectable = false;
		this["ptext"].text = "p = 0.0";
		this["qtext"].text = "q = 0.0";	
	}
	
	//What happens when mouse moved.
	function moveControl(){
		var tp = this._parent;
		if (tp.drag) {
			
			//Stop dragging if go outside region.
			var b:Boolean = true;
			if (this._x>100) {this._x = 100; b = false;}
			if (this._x<-100) {this._x = -100; b = false;}
			if (this._y>100) {this._y = 100; b = false;}
			if (this._y<-100) {this._y = -100; b = false;}
			if (!b) tp.releaseControl();
			
			//Arrange p and q spots.
			tp.p_spot._x = _x;
			tp.q_spot._y = _y;
			
			this._parent._parent.output();
			
			//Wherever spot lands, make a mark on the plane.
			tp.makeAMark(_x,_y);
			
			var pp = Math.floor(_x*10/tp.u)/10;
			var qq = -Math.floor(_y*10/tp.u)/10;
			this._parent["ptext"].text = "p = "+pp;
			this._parent["qtext"].text = "q = "+qq;
			
			updateAfterEvent();
		}
	}
	
	//A parabolic shape that becomes revealed as the (p,q) spot rolls over it.
	function parabola(){
		//First create a parabola shape.
		var s = this.createEmptyMovieClip("parabolaMask",this.getNextHighestDepth());
		var max = Math.floor(10*Math.sqrt(400/u))/10;
		s.lineStyle(1,0xcc0000,60);
		s.beginFill(0xcc0000,60);
		s.moveTo(u*max,-u*max*max/4);
		s.lineTo(-u*max,-u*max*max/4);
		for (var i:Number = 0; i!=20*max+1; i++) {
			var k = -max+i/10;
			s.lineTo(u*k,-u*k*k/4);
		}
		s.endFill();
		
		//Now create a blank screen for the spot to print on.
		var t = this.createEmptyMovieClip("plane",this.getNextHighestDepth());
		t.setMask(s);
		
		//Redraw the axes.
		this.attachMovie("axes","axes",this.getNextHighestDepth());
		this["markers"].swapDepths(1000);
	}
	
	//Make a mark on "plane" at the point (a,b).
	function makeAMark(a,b:Number) {
		var s = this["plane"]
		s.lineStyle(1,0xcc0000,60);
		s.beginFill(0xcc0000,60);
		s.moveTo(a-3,b-3);
		s.lineTo(a-3,b+3);
		s.lineTo(a+3,b+3);
		s.lineTo(a+3,b-3);
		s.lineTo(a-3,b-3);
		s.endFill();
	}

	//Control of the spot via keys.
	function keyControl() {
		
		//On pressing the shift key, switch between the different actions.
		obj = new Object();
		var mc = this;
		obj.onKeyDown = function() { 
			if ( Key.isDown(Key.UP) && mc["spot"]._y > -100) mc["spot"]._y--;
			if ( Key.isDown(Key.DOWN) && mc["spot"]._y < 100) mc["spot"]._y++;
			if ( Key.isDown(Key.LEFT) && mc["spot"]._x > -100) mc["spot"]._x--;
			if ( Key.isDown(Key.RIGHT) && mc["spot"]._x < 100) mc["spot"]._x++;
			
			mc.p_spot._x = mc["spot"]._x;
			mc.q_spot._y = mc["spot"]._y;
			
			//Wherever spot lands, make a mark on the plane.
			mc.makeAMark(mc["spot"]._x,mc["spot"]._y);
			
			mc._parent.output();
			mc._parent.ro.moveControl();
			mc._parent.gr.moveControl();
			
			var pp = Math.floor(mc["spot"]._x*10/mc.u)/10;
			var qq = -Math.floor(mc["spot"]._y*10/mc.u)/10;
			mc["ptext"].text = "p = "+pp;
			mc["qtext"].text = "q = "+qq;
			
			updateAfterEvent();
		}
		Key.addListener(obj);
		
	}
	
	
	
}