﻿import mx.events.EventDispatcher;
import Expression;
import ComplexView;
import Line;
import SubjectView;
import ComplexState;
import Constraint;
//
// This class contains information about some subject that is probably represented by
// some screen graphic.  Subjects group together the data that
// will appear in a hoverPanel if the mouse hovers over the graphic.
//
// See Also: ComplexState - which collects Subjects
//
class Subject extends EventDispatcher {
	public static var state:ComplexState;
	var id:String;
	var lines:Array;
	var _isFree:Boolean = null;
	
	var complexView:ComplexView;
	var view:SubjectView;
	var panel:SubjectPanel;
	var penDownLike:Subject;
	var copycats:Object;

	// variables associated with curve following
	var oldValue:Complex = null;
	var expression:Expression;
	var differential:Expression;
	var maxStep:Number = 5; // pixels
	
	//variables associated with constraints
	var constraint:Constraint;
	static var barf:Sound;
	
	//variables associated with icon drawing
	private var _icon:Array;

	function Subject(id:String, rvalue:Expression, complexView:ComplexView, line:Line) {
		//trace("new Subject("+id+")");
		this.id = id;
		lines = [line];
		definition = rvalue;
		penDownLike = null;
		copycats = {};
		this.complexView = complexView;
		complexView.createSubjectView(this);
		updateView();
		//view.clearIcon();
		//revalue({type:"revalue", target:[]});
	}
	
	function set definition(e:Expression):Void {
		//trace("Subject:37: definition = " + e);
		lines[0].statement = id + "=" +e.displayString(0);
		oldValue = state.getValue(id);
		state.define(id, e);
		//var values:Object = state.getValue(id);
		_isFree = e.isFreePoint();
		view.clearIcon();
		revalue({type:"revalue", target:[]});
	}
	
	function get definition():Expression {
		return state.getDefinition(id);
	}
	
	function getValue():Complex {
		return state.getValue(id);
	}
	
	function isFree():Boolean {
		if(_isFree == null) {
			_isFree = state.getDefinition(id).isFreePoint();
		}
		return _isFree;
	}
	
	function evtLoop(evt:Object):Boolean {
		for(var i:Number = 0; i < evt.target.length; i++) {
			if(id == Subject(evt.target[i]).id) {
				return true;
			}
		}
		return false;
	}
	
	function evtTrace(evt:Object):String {
		var s:String = "";
		var sep:String = "";
		for(var i:Number = 0; i < evt.target.length; i++) {
			s += (sep + Subject(evt.target[i]).id);
			sep = ", ";
		}
		return s;
	}
	
	function revalue(evt:Object):Void {
		/*
		{
			var s = "Subject 83: revalue " + id
			for(var i=evt.target.length-1; i >= 0; i--) {
				s +=" << "+ Subject(evt.target[i]).id;
			}
			trace(s);
		}
		*/
		
		if(evtLoop(evt)) {
			return;
		}
		
		var values:Object = state.revalue(id);
		/*
		if(evt.target.length == 0) {
			trace(id + " free from: "+ oldValue + " to: " + values.current);
		}
		*/
		var s:Subject = Subject(evt.target[0]);
		if(s != null) {
			var z0:Complex = s.oldValue;
			var z1:Complex = state.revalue(s.id).current;
			var w1:Complex = complexView.complexToScreen(values.current);
			var w0:Complex = complexView.complexToScreen(values.prev);
			drawCurve(evt.target, z0, z1, w0, w1, updateView);
			drawIcon(evt.target);
		}
		else {
			drawRawIcon(values.current);
			updateView();
		}
		
		
		evt.target.push(this)
		//trace("revalue " + id + " evts="+evtTrace(evt));
		dispatchEvent(evt);

		if(panel._visible) {
			panel.update();
		}
	}
	
	function drawCurve(dependencies:Array, z0:Complex, z1:Complex, w0:Complex, w1:Complex, plot:Function):Void {

		//trace("drawCurve " + id + " plot = " + plot);
		
		if(dependencies.length == 1) {
			var s:Subject = Subject(dependencies[0]);
			
			//if(complexView.onScreen(w0) || complexView.onScreen(w1)) {
				//
				// Calculate a curved path if necessary from previous position to current
				//
				var wjump:Complex = complexView.complexToScreen(w1).minus(complexView.complexToScreen(w0));
				var jumps:Number = Math.floor(wjump.length/maxStep);
				
				// jumps can get to be too many to render in a sensible time
				if(jumps > 20) jumps = 20;
				//trace("wjump = " + wjump + " length = " + wjump.length + " jumps = " + jumps + " maxStep = " + maxStep);
				//
				// TODO: We should attempt to determine _which_ dependency has changed here rather than limiting this to the
				//	special case where there is only one. However this could easily slow things up a lot.
				//
				if(jumps >= 1) {
					//trace(jumps);
					var zjump:Complex = z1.minus(z0); //state.getValue(s.id).minus(s.oldValue);
					//trace("Possibly inserting " + jumps + " jumps"); 
					var _z:Expression = new Expression({type:Expression.VARIABLE, name:"_z", value:z0});
					var _w:Expression = state.getDefinition(id).substitute(s.id, _z);
					state.define("_w", _w);
					if(differential == null) {
						differential = _w.differentiate(_z.name);
						//trace("expression = " + _w + " differential = " + differential + " ["+differential.type+"]");
					}
					// insert jumps to smooth the path unless we are linear in _z
					if(!differential.isConstant()) {
						for(var j:Number = 1; j < jumps; j++) {
							state.define("_z", new Expression(z0.plus(zjump.times(j/jumps))));
							//trace(id + " hop to " + values.prev.plus(j/jumps) + " getValue="+state.getValue("_z"));
							state.revalue("_w");
							//trace("_z = " + state.getDefinition("_z") + " _w="+state.getDefinition("_w"));
							plot.call(this,"_w");
						}
					}
					//trace(id + " jump from: "+ values.prev + " to: " + values.current + " on " + s.id + " from: " + s.oldValue + " to " + state.getValue(s.id));
				}
			//}
		}

		// always do final jump - even if off screen
		plot.call(this);
	
	}
	
	private var _transformedIcon:Array;

	function get icon():Array {
		if(_icon == null || _icon[0][0] == null) {
			_icon = [[false,new Complex(0,0)],[true,new Complex(1,0)],[true,new Complex(0.5,-0.25)],[true,new Complex(0.5,0.25)]];
			for(var i=0; i < _icon.length; i++) {
				var c:Complex = Complex(_icon[i][1]);
				c = complexView.screenToDelta(c);
				if(c==null) {					
					trace(c);
					_icon = null;
					return null;
				}
				_icon[i][1] = c;
			}
		}
		return _icon;
	}
	
	function set icon(ipath:Array):Void {
		_icon = ipath;
	}
	
	function set transformedIcon(a:Array) {
		//trace("ZAP " + id);
		_transformedIcon = a;
	}
	
	function get transformedIcon():Array {
		if(_transformedIcon == null) {
			_transformedIcon = [];
			for(var i=0; i < icon.length; i++) {
				var t:Array = icon[i].concat();
				//trace("Icon["+i+", 1]="+t + "step="+view.complexStep);
				t[1] = Complex(t[1]).times(view.velocity.conjugate());
				_transformedIcon[i] = t;
				//trace("tIcon["+i+", 1]="+t);
			}
		}
		return _transformedIcon;
	}
	
	function drawIcon(dependencies:Array):Void {
		//trace("DRAWICON "+id);
		if(dependencies.length != 1)
			return;
		var s:Subject = Subject(dependencies[0]);
		var ico:Array = s.transformedIcon;
		var z:Complex = state.getValue(s.id);
		var z0:Complex = z;
		var _t:Expression = new Expression({type:Expression.VARIABLE, name:"_t", value:z});
		state.define("_t", _t);
		state.define("_w1", state.getDefinition(id).substitute(s.id, _t));
		var w0 = state.revalue("_w1").current;
		//var w0:Complex = oldValue;
		view.clearIcon();
		for(var i=0; i < ico.length; i++) {
			var command:Array = ico[i];
			//trace(ico);
			var z1:Complex = z.plus(Complex(command[1]));
			state.setValue("_t", z1);
			var values:Object = state.revalue("_w1");
			var w1:Complex = Complex(values.current);
			if(command[0])
				drawCurve([s], z0, z1, w0, w1, updateIcon);
			//trace((command[0]? "line " : "move ") + "w0="+w0+" w1="+w1);
			w0 = w1;
			z0 = z1;
		}
		//trace("");
	}
	
	function drawRawIcon(w0:Complex) {
		//trace("id = " + id + " w0="+w0 + " view = "+view);
		var ico:Array = transformedIcon;
		for(var i=0; i < ico.length; i++) {
			var command:Array = ico[i];
			view.plotIcon(w0.plus(Complex(command[1])));
		}
	}
	
	function updateView(varName:String):Void {
		//trace("update SubjectView on " + id);
		if(varName == null) {
			varName = id;
		}
		view.move(state.getValue(varName));
	}
	
	function updateIcon(varName:String):Void {
		//trace("update SubjectView on " + id);
		if(varName == null) {
			varName = "_w1";
		}
		//trace("plot " + state.getValue(varName));
		view.plotIcon(state.getValue(varName));
	}
	
	function get evaluated():Complex {
		return state.getValue(id);
	}
		
	function isSet():Boolean {
		/*
		if(_isSet == null && evaluated != null) {
			_isSet = evaluated.isSet();
		}
		return _isSet;
		*/
		return evaluated.isSet();
	}
	
	function remove():Void {
		if(view != null) {
			//trace("Removing view on "+id);
			view.removeMovieClip();
			view = null;
		}
		if(panel != null) {
			//trace("Removing panel on "+id);
			panel.removeMovieClip();
			panel = null;
		}
	}
	
	function addLine(line:Line):Boolean {
		for(var i = 0; i < lines.length; i++) {
			var l = lines[i];
			if(l.lineNumber == line.lineNumber) {
				return true; // already exists
			}
		}
		lines.push(line);
		
	}

	function command(cmd:String, arg:Expression, line:Line):Void {
		//trace("subject command: " + id + " " + cmd + " " + arg  + "["+line.lineNumber+"]");
		if(cmd == "assignValue") {
			lines = [line];
			complexView.statusMessage(id + " has been redefined", 5000);
			
			// this is a redefinition; we have to replace the old one
			var newv:Complex = arg.evaluate();
			//if(state.getValue().isSet() == newv.isSet()) {
				// new is same type of thing as old: just move it
				definition = arg;
				updateView();
			//}
			//else {
			//	remove();
			//	complexView.createSubjectView(this);
			//}
			return;
		}
		else {
			// validate command
			var local:Boolean = this[cmd] instanceof Function;
			if(!local && !state.hasCommand(cmd)) {
				throw new Error("Unknown command: " + cmd);
			}
			// remember command
			lines.push(line);
			// execute command
			if(local) {
				this[cmd](arg);
			}
			else {
				state.executeCommand(cmd, id, arg);
			}
		}
	}
	
	//command
	function penDown():Void {
		trace(id + " pen down");
		view.penDown = true;
		penDownLike.copycats[id]=null;
		penDownLike = null;
	}
	
	//command
	function penUp():Void {
		trace(id + " pen up");
		view.penDown = false;
		penDownLike.copycats[id]=null;
		penDownLike = null;
	}
	
	//command
	function useMouse():Void {
		trace(id + " use Mouse");
		view.useMouseMode = true;
		penDownLike.copycats[id]=null;
		penDownLike = null;
	}
	
	//command
	function useKeys():Void {
		trace(id + "use Keys");
		view.useKeys = true;
		view.penDown = true;
	}
	
	//command
	function drawLike(rvalue:Expression) {
		var s:Subject = state.getSubjectOf(rvalue);
		if(s == null) {
			throw new Error(rvalue + " has not been defined");
		}
		s.copycats[id]=this;
		penDownLike = s;
	}
	
	//command
	function constrain(rvalue:Expression):Void {
		var constraintId:String = rvalue.toString();
		constraint = complexView.createSubjectConstraint(this, constraintId);
		if(constraint != null) {
			//constraint._visible = false;
			if(barf == null) {
				barf = new Sound();
				barf.attachSound("Barf");
				barf.setVolume(20);
			}
		}
	}
	
	//command
	function hide():Void {
		trace(id + " hide");
		view.visible=false;
	}
	
	//command
	function clear():Void {
		trace(id + " clear");
		view.clearPane();
		for(var sid:String in copycats) {
			Subject(copycats[sid]).clear();
		}
	}
	
	// command
	function paints(rvalue:Expression):Void {
		var colour:Complex = rvalue.evaluate();
		trace(id + " paints 0x" + colour.x.toString(16));
		if(colour == null || colour.nan()) {
			throw new Error("Try 'z setColor pink' or z setColor (32*red + 100*green)'");
		}
		view.rgb = colour.x //& 0xffffff;
	}

	// command 
	function hideLabel():Void {
		view.labelVisible = false;
	}
	
	function showLabel():Void {
		view.labelVisible = true;
	}
	
	// View delegates
	function set rgb(colour:Number):Void {
		view.rgb = colour;
	}

	function get rgb():Number {
		return view.rgb;
	}

	// Misc
	function toString():String {
		var s:String = id + ": def=" + state.getDefinition(id) + " val=" + state.getValue(id);
		return s;
	}
}