﻿import Complex;
import SetValue;
import RealInterval;
class PrimitiveSet extends SetValue {
	public static var CC:PrimitiveSet = null;
	public static var RR:RealInterval = null;
	public static var RAY:RealInterval = null;
	public static var UI:RealInterval = null;
	public static var UD:PrimitiveSet = null;
	public static var HX:PrimitiveSet = null;
	public static var ZZ:PrimitiveSet = null;
	
	public var id:String="CC";

	static function classInit():Void {
		CC = new PrimitiveSet("CC");
		RR = new RealInterval("RR");
		RAY = new RealInterval("RAY");
		UI = new RealInterval("UI");
		UD = new PrimitiveSet("UD");
		HX = new PrimitiveSet("HX");
		//ZZ = new PrimitiveSet("ZZ");
	}
	
	private function PrimitiveSet(id:String) {
		this.id = id;
		switch(id) {
			case "CC":
			case "UD":
			case "HX": {
				trace("Primitive Set: " + id + " not implemented");
			}
		}
	}
	
	function isPrimitive():Boolean {
		// the set is defined as a primitive set (like the reals)
		return true;
	}
	
	function isExpression():Boolean {
		return false;
	}
	
	function isList():Boolean {
		return false;
	}
	
	function isEmpty():Boolean {
		return false;
	}
	
	public function contains(z:Complex):Boolean {
		switch(this) {
			case CC: return true;
			case UD: return z.length <= 1;
			case HX: return z.x > 0;
			default:
				trace("unknown primitive set: " + this);
		}
		return null;
	}
	
	function intersectList(s:SetValue):SetValue {
		var sv = new SetValue();
		for(var m:String in s.members) {
			var el:Complex = Complex(members[m]);
			if(contains(el)) {
				sv.addMember(el);
			}
		}
		return sv;
	}
	
	function intersect(s:SetValue):PrimitiveSet {
		if(s.isPrimitive()) {
		}
		trace("TODO: PrimitiveSet intersect not implemented");
		return null;
	}
	
	function toString():String {
		return id;
	}
}