﻿//
// Path provides a sequence of points needed to draw a Path defined by an expression
// whose domain is PrimitiveSet.RR (the Reals).
//
import Expression;
import Complex;
import ComplexView;
import SetValue;
import PrimitiveSet;
import RealInterval;
import PathBuffer;

class Path {
	// phiResolution is the minimum length of a phi interval that may be represented 
	// as a straight line. 
	public static var phiResolution:Number = Math.PI/20;
	public static var maxError:Number = 0.75;
	public static var maxSegLen:Number = 1;
	public static var maxLevel:Number = 20;
	public var map:Function = null;
	
	private var expression:Expression;
	private var view:ComplexView;
	private var _partition:Object;
	private var domain:RealInterval;
	private var tVar:String;
	
	private var pathBuffer:PathBuffer;
	
	// cached set of RR->f(RR) points
	private var points:Array;
	
/*
	function Path(expression:Expression, view:ComplexView) {
		this.expression = expression;
		this.view = view;
		//interval = setInterval(this, "init", 20);
		
		// create a screen buffer to hold the drawn path
		pathBuffer = view.getPathBuffer();
		
		RR = PrimitiveSet.RR.id;
		_partition = partition({type:"interval", phi0:(-phiCover*Math.PI/2), phi1:(phiCover*Math.PI/2)},0);

		points = [];
	}
*/	
	function Path(view:ComplexView) {
		this.view = view;
		points = [];
		pathBuffer = view.getPathBuffer();
		pathBuffer.clear();
	}
	
	// Create a Path: t in RealInterval -> expression(t) in ComplexView
	static function fromExpression(expression:Expression, t:String, domain:RealInterval, view:ComplexView):Path {
		var path:Path = new Path(view);
		path.expression = expression;
		path.tVar = t;
		path.domain = domain;
		if(domain.map == null) {
			path.map = identityMap;
			phiResolution = 0.01;
		}
		else {
			path.map = domain.map;
		}
		//trace("path.map is identity?="+(path.map == identityMap));
		path.generate();
		return path;
	}
	
	function generate():Void {
		_partition = partition({type:"interval", phi0:domain.interval[0], phi1:domain.interval[1]},0);
	}
	
	static function identityMap(t:Number):Number {
		//trace(t);
		return t;
	}

	/*
	function init() {
		
		this.expression = expression;
		this.view = view;
		//interval = setInterval(this, "init", 20);
		
		// create a screen buffer to hold the drawn path
		pathBuffer = view.createPathBuffer();
		
		RR = PrimitiveSet.RR.id;
		_partition = partition({type:"interval", phi0:(-phiCover*Math.PI/2), phi1:(phiCover*Math.PI/2)},0);
		//_partition = partition({type:"interval", phi0:-Math.PI/2, phi1:Math.PI/2},0);
		
	}
	*/
	
	static var idn:Number=0;
	
	static var golden:Number = (Math.sqrt(5)+1)/2;
	static var golden1:Number = 1/((Math.sqrt(5)+1)/2+1);
	
	function partition(interval:Object, level:Number):Object {
		if(level++ > maxLevel) return interval;
		var f0:Complex = Complex(interval.f0);
		var f1:Complex = Complex(interval.f1);
		var phi0:Number = interval.phi0;
		var phi1:Number = interval.phi1;
		//trace("partition("+phi0+","+phi1+")");
		if(f0==null) {
			interval.f0 = f0 = screenPoint(phi0);
		}
		if(f1==null) {
			interval.f1 = f1 = screenPoint(phi1);
		}
		var smallEnough:Boolean = (Math.abs(phi1-phi0) < phiResolution);
		if(smallEnough) {
			if(f0.minus(f1).length < maxSegLen) {
				//trace("segment length: " + f0.minus(f1).length + " ("+f0+" :: "+f1+")");
				//MovieClip(view).attachMovie("SimplePoint", "sid"+idn++, 10000+idn, {_x:f0.x, _y:f0.y});
				pathBuffer.moveTo(f0.x,f0.y);
				pathBuffer.lineTo(f1.x,f1.y);
				return interval;
			}
			
			//check whether we've already drawn this interval
			if(pathBuffer.goldenLineDrawn(f0.x, f0.y, f1.x, f1.y)) {
				interval.type = "invisible";
				return interval;
			}
		}
		var f0isOn:Boolean = interval.f0isOn;
		if(f0isOn == null) {
			f0isOn = view.onScreen(f0);
		}
		var f1isOn:Boolean = interval.f1isOn;
		if(f0isOn) {
			if(f1isOn == null) {
				f1isOn = view.onScreen(f1);
			}
			if(f1isOn) {
				var interpG:Complex = f0.times(golden).plus(f1).times(golden1);
				var mphi0=map(phi0);
				var mphi1=map(phi1);
				//trace("mphis=" + mphi0 + " " +mphi1);
				var phiG:Number = (mphi0*golden+mphi1)*golden1;
				Expression.state.define(tVar, new Expression(""+phiG));
				var linest:Complex = view.complexToScreen(expression.evaluate());
				if(linest.minus(interpG).length < maxError) {
					/*
					var interpG2:Complex = f1.times(golden).plus(f0).times(golden1);
					var phiG2:Number = (mphi1*golden+mphi0)*golden1;
					Expression.variables[tVar] = new Complex(phiG2);
					var linest2:Complex = view.complexToScreen(expression.evaluate());
					if(linest2.minus(interpG2).length < maxError) {
						*/
						// OK to simply draw a line between f0 and f1
						//trace("["+f0+" < "+linest+" < "+f1+"] FINAL error = "+error+ " phiMid="+phiMid);
						//MovieClip(view).attachMovie("SimplePoint", "sid"+idn++, 10000+idn, {_x:f0.x, _y:f0.y});
						pathBuffer.moveTo(f0.x,f0.y);
						pathBuffer.lineTo(f1.x,f1.y);
						return interval;
					//}
				}
			}
		}
		//if((Math.abs(phi1-phi0) < phiResolution) && !f0isOn && !f1isOn) {
		if(smallEnough && !f0isOn && ((f1isOn==false) || f1isOn==null && !(f1isOn=view.onScreen(f1)))) {
			//trace("["+f0+" : "+f1+"] INVISIBLE");
			MovieClip(view).attachMovie("SimplePoint", "sid"+idn++, 10000+idn, {_x:f0.x, _y:f0.y});
			interval.type = "invisible";
			return interval;
		}
		
		//trace("["+f0+" < "+mid+" < "+f1+"] HALVE linest="+linest+" error = " + error);
		var phiMid:Number = (phi0*golden+phi1)*golden1;
		var mid:Complex = screenPoint(phiMid);
		var cut0:Object = {type:"interval", phi0:phi0, f0:f0, f0isOn:f0isOn, phi1:phiMid, f1:mid};
		var cut1:Object = {type:"interval", phi0:phiMid, f0:mid, phi1:phi1, f1:f1, f1isOn:f1isOn};
		var cut:Object = {type:"cut", cut0:partition(cut0,level), cut1:partition(cut1,level)};
		return cut;
	}
	
	
	// Determines whether f(map(phi)) is on screen
	function screenPoint(phi:Number):Complex {
		Expression.state.define(tVar, new Expression(""+map(phi)));
		return view.complexToScreen(expression.evaluate());
	}
	
	//
	// firstPoint() and nextPoint(). These beasts must chase down
	// the interval tree. Current state is maintained by the cutStack which records
	// cuts on the way to the last return value (which will be from an interval).
	//
	static var cutStack:Array;
	
	public function clearCache():Void {
		for(var i:Number = 0; i < points.length; i++) {
			delete points[i];
		}
		points = [];
	}
	
	private function clearPartition(cut:Object):Void {
		if(cut == null && _partition != null) {
			clearPartition(_partition);
			_partition = null;
		}
		if(cut.type=="cut") {
			clearPartition(cut.cut0);
			clearPartition(cut.cut1);
		}
		delete cut;
	}
	
	//
	// Following functions are available to iterate through the points of a path once it's 
	// been defined. First time through any partition that exists is converted to a simple
	// array of intervals 
	//
	static var pointx:Number = 0;
	public function firstPoint(cut:Object, isCut1:Boolean):Object {
		if(_partition == null) {
			pointx=0;
			return points[pointx++];
		}
		if(cut == null) {
			//trace("null cut");
			cutStack = [];
			points = [];
			cut = _partition;
		}
		//trace("fp:cutStack length="+cutStack.length);
		cutStack.push(cut);
		if(cut.type=="interval" || cut.type=="invisible") {
			//trace("fp="+cut.f0);
			var rv:Object = {phi:cut.phi0, f:cut.f0, type:cut.type};
			if(isCut1!=true) {
				points.push(rv);
			}
			return rv;
		}
		return firstPoint(cut.cut0, isCut1);
	}
	
	public function nextPoint():Object {
		//trace("np:cutStack length="+cutStack.length);
		if(_partition == null) {
			//trace("pointx ="+pointx);
			return points[pointx++];
		}
		var cut:Object = cutStack.pop();
		if(cut == null) {
			clearPartition(null);
			return null;
		}
		//if(cut.type =="invisible") return null;
		if(cut.type=="interval" || cut.type=="invisible") {
			//trace("np=f1");
			var rv:Object = {phi:cut.phi1, f:cut.f1, type:cut.type};
			points.push(rv);
			return rv;
		}
		else {
			//trace("(np=fp)");
			firstPoint(cut.cut1, true);
			return nextPoint();
		}
	}
	
	static function iteratorTest(s:String):Void {
		var e:Expression = new Expression(s);
		var p:Path = Path.fromExpression(e, "t", PrimitiveSet.RR, _testView);
		var list:Array = [];
		var t2:Number = getTimer();
		var item:Object = p.firstPoint();
		for(var i:Number=0; (i < 300) && (item != null); i++) {
			item=p.nextPoint()
			list.push(item);
		}
		var t3:Number = getTimer();
		trace("time = "+(t3-t2)/1000);
		t2 = getTimer();
		item = p.firstPoint();
		for(var i:Number=0; (i < 300) && (item != null); i++) {
			var t3:Number = getTimer();
			item=p.nextPoint();
			if(list[i].f != item.f) {
				trace("first = "+list[i].phi+":"+list[i].f+" second="+item.phi+":"+item.f);
			}
		}
		t3 = getTimer();
		trace("time = "+(t3-t2)/1000);
}
	
	function toString() {
		var s:String = "";
		var z:Complex = Complex(firstPoint().f);
		s = z.toString();
		while((z = Complex(nextPoint().f)) != null) {
			s += " -> " + z;
		}
		return s;
	}
	
	private static var _testView:ComplexView;
	private static var plotDepth:Number = 20000;
	static function drawTest(s:String):Number {
		var e:Expression = new Expression(s);
		var t2:Number = getTimer();
		//var p:Path = new Path(e, _testView);
		var p:Path = Path.fromExpression(e, "t", PrimitiveSet.RR, _testView);
		
		var t3:Number = getTimer();
		trace("t="+(t3-t2)/1000 + "\t "+s);
		
		// plot path
		
		var graph:MovieClip = _testView.createEmptyMovieClip("plot"+plotDepth, plotDepth++);
		graph.lineStyle(2,0x888800,100);
		var item = p.firstPoint();
		//trace("item = "+item);
		graph.moveTo(item.f.x, item.f.y);
		if(item !=null) {
			var i =0;
			var item2;
			while((item2 = p.nextPoint())!=null) {
				//trace(item2.phi-item.phi);
				i++;
				/*
				if(Math.abs(item2.f.y-item.f.y)<50) {
					item = item2;
					continue;
				}
				*/
				//if(item.type == "interval" && item2.type=="interval") {
					trace(i + ": "+item.f + " -> " + item2.f + " "+item.type+" -> "+item2.type);
				//}
				if(item2.type == "invisible") {
					graph.moveTo(item2.f.x, item2.f.y);
				}
				else {
					graph.lineTo(item2.f.x, item2.f.y);
				}
				item = item2;
			}
		}
		
		//p.pathBuffer.clear();
		p.clearPartition();
		return (t3-t2);
	}
	
	static function test(testView:ComplexView) {
		var total=0;
		_testView = testView;
		total+=drawTest("L=-2*i+t");
		/*
		total+=drawTest("L=-2+i*t");
		total+=drawTest("L=t*exp(-i*pi/4)");
		total+=drawTest("L=t+i*sin(t)");
		total+=drawTest("L=4*(t-i)/(t+i)");
		//total+=drawTest("L=(t+i*tan(t))*exp(i*pi/4)");
		total+=drawTest("L=(i*t+tan(t))");
		//total+=drawTest("L=(t+i*tan(t))");
		total+=drawTest("L=t+i*t^3/10");
		total+=drawTest("L=t+i*t^2");
		total+=drawTest("L=exp(2*pi*i*t)/2");
		total+=drawTest("L=exp(2*pi*i*t)");
		total+=drawTest("L=2*exp(2*pi*i*t)");
		total+=drawTest("L=4*exp(2*pi*i*t)");
		total+=drawTest("L=8*exp(2*pi*i*t)");
		total+=drawTest("L=16*exp(2*pi*i*t)");
		*/
		//for(var i = 0.1; i < 17; i*=2) {
			//total+=drawTest("L="+13+"*exp(2*pi*i*t)");
		//}
		trace("total="+total/1000);

		//iteratorTest("L=t+i*tan(t)");
		//iteratorTest("L=t+i*sin(t)");
	}
}