﻿import Complex;
class Constraint extends MovieClip {
	
	
	//
	// Note that this class works in screen space
	//
	
	var insidePoint:Complex;
	var stepSize:Number = 1.4;
	var angularStep:Number = 0.1;
	var ip:MovieClip ;
	
	function Constraint() {
		var rStack:Array = [[new Complex(_x,_y), new Complex(_x+_width,_y+_height)]];
		while(rStack.length >= 1 && insidePoint == null) {
			insidePoint = findInsidePoint(rStack);
		}
		trace("insidePoint = "+insidePoint);
		ip = _parent.attachMovie("Dot", "ipview", 1000, {_x:insidePoint.x,_y:insidePoint.y});
	}
	
	function findInsidePoint(rStack):Complex {
		var rectangle:Array = rStack.shift();
		var tl:Complex = Complex(rectangle[0]);
		var br:Complex = Complex(rectangle[1]);
		var middle:Complex = tl.plus(br).over(2);
		if(inside(middle))
			return middle;
		if(middle.minus(tl).length > 1) {
			rStack.push([tl, middle]);
			rStack.push([middle, br]); 
			rStack.push([middle, new Complex(tl.x,br.y)]);
			rStack.push([middle, new Complex(br.x,tl.y)]);
		}
	}
		
	function inside(z:Complex):Boolean {
		if(hitTest(Math.round(z.x), Math.round(z.y), true)) {
			//insidePoint = new Complex(z.x, z.y);
			//trace(z + " i");
			return true;
		}
		//trace(z + " o");
		return false;
	}
	
	function nearestInside(z:Complex, p:Complex, d:Number):Complex {
		// Try to move towards z without moving off the drawing
		//if(inside(z))
		//	p = z;
		//else {
			if(p==null) p = insidePoint;
			if(d==null) d = 0;
			if(d < 5) {
				//trace("ni: "+p);
				var direction:Complex = z.minus(p);
				var l:Number = direction.length;
				if(l > stepSize) {
					var step = direction.over(l).times(stepSize);
					for(var theta:Number = 0; theta < Math.PI/3; theta += angularStep) {
						var testPoint:Complex = p.plus(step.times(new Complex(1, theta, true)));
						if(inside(testPoint)) {
							p = nearestInside(z, testPoint, d+1);
							break;
						}
						if(theta > 0) {
							testPoint = p.plus(step.times(new Complex(1, -theta, true)));
							if(inside(testPoint)) {
								p = nearestInside(z, testPoint, d+1);
								break;
							}
						}
					}
				}
			}
		//}
		ip._x = p.x;
		ip._y = p.y;
		//trace("ni: "+p+ (inside(p)? " in" : " out" ));
 
		return p;
	}
}