﻿import mx.events.EventDispatcher;
import mx.utils.Delegate;
import ComplexView;
import Expression;
import Complex;
import Line;
import Subject;
import BasicStateImpl;
import State;
//
// This class is responsible for storing the state represented by the statements typed in
// together with any state changes caused by user interaction with the different geometrical 
// views and hoverPanels.
//
//
// It's the Model of a Model/View/Controller triplet where View is a ComplexView 
// and Controller is the Console class. It communicates updates to its views using events.
//
// Statements are about Subjects. e.g. z=1 and z>0 are both statements about z. This class
// creates and maintains the subject list.
//
class ComplexState extends BasicStateImpl implements State {
	var subjects:Object;
	var view:ComplexView;
	var lines:Array;
	
	function ComplexState(view:ComplexView) {
		super();
		lines = [];
		Subject.state = this;
		subjects = {};
		this.view = view;
	}
		
	function reset():Void {
		super.reset();
		var s:Subject;
		for(var id:String in subjects) {
			s = getSubject(id);
			s.remove();
		}
		subjects = {};
		lines = [];
		/*
		while((s=Subject(subjects.pop())) != null) {
			s.remove();
		}
		*/
		view.reset();
	}
	
	function clearDrawPane():Void {
		var s:Subject;
		for(var id:String in subjects) {
			s = getSubject(id);
			s.view.clearPane();
		}

	}
	
	function addStatement(line:Line):Void {
		line.lineNumber = lines.length;
		var e:Expression = new Expression(line.statement);
		var id:String = getSubjectId(e);
		lines.push(line);
		
		//trace("ComplexState:56 line='"+line.statement+"' id = " + id + " e.type = " + e.type + " e.name="+e.name + " e.val="+e.expr1);

		/* immediate evaluation disabled for now:
		 * we need to disable command execution from expression evaluation before it will
		 * work properly. 
		 * Problem is that expression evaluation does not have a subject+statement+linenumber context
		 
		trace("before");
		var val:Complex = e.evaluate();
		trace("after");
		if(val.toString() == id) {
			// ignore immediate evaluations
			// TODO: Should we dump out 
			trace(id + "==" + val.toString());
			return;
		}
		*/
		var s:Subject = getSubject(id);
		//var evt:Object = {};
		if(s==null) {
			if(!e.isDefinition()) {
				throw new Error("Expected assignment statement in " + e);
			}
			s = defineSubject(id, e.expr1, line);
		}
		else {
			//trace("ComplexState:82 addStatement: " + e);
			//trace("e.expr1 = " + e.expr1);
			s.command(e.name, e.expr1, line);
			//s.update(e, lnum);
		}
	}

	function defineSubject(id:String, e:Expression, line:Line):Subject {
		define(id, e);
		var s:Subject = new Subject(id, e, view, line);
		return (subjects[id]=s);		
	}
	
	// return a Plex script that would regenerate the current state
	function get text():String {
		var txt:String = "";
		for(var i:Number=0; i < lines.length; i++) {
			txt += Line(lines[i]).statement + "\r";
		}
		return txt;
	}
		
	function chainDependencies():Void {
		// TODO: Detect dependency loops and throw error if found
		// TODO: Make sure event listeners are removed on reset
		for(var id in subjects) {
			var s:Subject = getSubject(id);
			s.definition.callDependencies(this, addLink, s); 
		}
	}
	
	function addLink(s:Subject, variable:Expression):Void {
		//trace(s.id + "->" + variable.name);
		if(s.id == variable.name) {
			throw new Error("Recursive definition of " + variable.name);
		}
		var dependency:Subject = getSubject(variable.name); //subjects[variable.name];
		if(dependency != null) {
			dependency.addEventListener("revalue", Delegate.create(s, s.revalue));
		}
	}
	
	/*
	// State Commands
	function setColor(lvalue:Expression, rvalue:Expression):Void {
		var id:String = getSubjectId(lvalue);
		if(id == null) {
			throw new Error("" + lvalue + " has not been defined");
		}
		var s:Subject = getSubject(id);
		if(s == null) {
			throw new Error(id + " has no metadata");
		}
		var colour:Complex = rvalue.evaluate();
		if(colour == null || colour.nan()) {
			throw new Error("Try 'z setColor pink' or z setColor (32*red + 100*green)'");
		}
		s.rgb = colour.x & 0xffffff;
	}
	*/

	//
	// return true if we understand the command indicated by 'name' in some 
	// local or global namespace. 
	//
	public function hasCommand(name:String):Boolean {
		var s:Subject = null;
		for (var id:String in subjects) {
			s = subjects[id];
			break;
		}
		var local = (s != null) && (s[name] instanceof Function);
		var global = (commands[name] instanceof Function);
		/*
		if(local)
			trace("ComplexState:178: has local command "+name);
		if(global)
			trace("ComplexState:178: has global command "+name);
		*/
		return local || global;
	}

	public function commandDisplayName(name:String):String {
		return name;
		//return commands[name].displayName;
	}
	
	/*
	private function localCommand(name:String):Function {
		var s:Subject = null;
		for (var id:String in subjects) {
			s = subjects[id];
			break;
		}
		return Function(s[name]);
	}
	*/
	
	private function getSubjectId(e:Expression):String {
		return e.mainVariable().name;
	}
	
	public function getSubjectOf(e:Expression):Subject {
		return getSubject(getSubjectId(e));
	}
	
	public function getSubject(id:String):Subject {
		return subjects[id];
	}
	
}