﻿import Complex;
import ComplexPlane;

class CartesianGrid extends MovieClip {
	var xMin:Number = -10;
	var xMax:Number = +10;
	var yMin:Number = -10;
	var yMax:Number = +10;

	// styles
	var mini:Object = {thickness:1, rgb:0xDDDDDD, alpha:100};
	var midi:Object = {thickness:2, rgb:0xCCCCCC, alpha:100};
	var maxi:Object = {thickness:3, rgb:0xBBBBBB, alpha:100};

	function CartesianGrid() {
	}
	
	function draw() {
		drawVerticals(1, 10, 5);
		drawHorizontals(1, 10, 5);
	}

	function drawVerticals(interval:Number, majors:Number, middles:Number):Void {

		for(var x:Number = 0, i=0; x < Math.max(Math.abs(xMax),Math.abs(xMin)); x+= interval, i++) {
			var style = (i%majors==0) ? maxi : ((i%middles) == 0 ? midi : mini);
			lineStyle(style.thickness, style.rgb, style.alpha);
			if(x <= xMax) {
				moveTo(x,yMin);
				lineTo(x,yMax);
			}
			if(-x >= xMin) {
				moveTo(-x,yMin);
				lineTo(-x,yMax);
			}
		}
	}

	function drawHorizontals(interval:Number, majors:Number, middles:Number):Void {

		for(var y:Number = 0, i=0; y <= Math.max(Math.abs(yMax),Math.abs(yMin)); y+= interval, i++) {
			var style = (i%majors==0) ? maxi : ((i%middles) == 0 ? midi : mini);
			lineStyle(style.thickness, style.rgb, style.alpha);
			if(y <=yMax) {
				moveTo(xMin,y);
				lineTo(xMax,y);
			}
			if(-y >= yMin) {
				moveTo(xMin,-y);
				lineTo(xMax,-y);
			}
		}
	}

	function moveTo(x:Number, y:Number):Void {
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		//trace("moveTo("+g.x+","+g.y+")");
		super.moveTo(g.x, g.y);
	}

	function lineTo(x:Number, y:Number):Void {
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		//trace("lineTo("+g.x+","+g.y+")");
		super.lineTo(g.x, g.y);
	}
	
	function curveTo(cx:Number, cy:Number, x:Number, y:Number):Void {
		var c:Complex = _parent.complexToScreen(new Complex(cx,cy));
		var g:Complex = _parent.complexToScreen(new Complex(x,y));
		super.curveTo(c.x, c.y, g.x, g.y);
	}
}