﻿import mx.containers.ScrollPane;
import LogoFunction;

class TurtlePane extends ScrollPane {
	var x:Number = 0;
	var y:Number = 0;
	var h:Number = 0;
	var penDown:Boolean = true;
	var turtle:Turtle;
	
	var _thickness:Number = 1;
	var _rgb:Number = 0;
	var _alpha:Number = 0;
	
	static var N = LogoFunction.NUMBER;
	static var B = LogoFunction.BOOLEAN;
	static var W = LogoFunction.WORD;
	static var L = LogoFunction.LIST;
	static var WoL = LogoFunction.WORDorLIST;
	static var O = LogoFunction.OBJECT;

	function TurtlePane() {
	}

	function init():Void {
		super.init();
		trace("TurtlePane init");
		contentPath = "Screen";
		addEventListener("complete", this);
	}

	function complete(evt:Object):Void {
		trace("Content loaded");
		turtle = Turtle(content.createEmptyMovieClip("turtle", 1));
		content.lineStyle(_thickness, _rgb, _alpha);
	}
	
	function clearscreen():Void {
		trace("turtle clearscreen");
		content.clear();
		turtle.home();
		x = y = h = 0;
		turtle._visible = true;
	}

	function forward(n):Void {
		trace("turtle forward:"+n);
		var theta = this.h * Math.PI / 180;
		x += n * Math.sin(theta);
		y += n * Math.cos(theta);
		  
		turtle._x = x;
		turtle._y = y;
		
		if (penDown) {
			content.lineTo(x, y);
		}
		
	}

	function right(n:Number):Void {
		trace("turtle right:"+n);
		h += n;
		turtle._rotation = h;
	}

	function penup():Void {
		trace("turtle penup");
		penDown = false;
	}

	function pendown():Void {
		trace("turtle penDown");
		penDown = true;
	}

	function hide():Void {
		trace("turtle hide");
		turtle._visible = false;
	}

	function show():Void {
		trace("turtle show");
		turtle._visible = true;
	}

	function addTurtlePrimitives(ns:Object):Void {
		var self = this;
		
		ns.clearscreen = new LogoFunction(
			"cs", 
			[], 
			false,
			function(k) {
				self.clearscreen();
				k();
			});
		
		ns.forward = new LogoFunction(
			"fd", 
			[N], 
			false,
			function(k, n) {
				self.forward(n);
				this.delay(k, n);
			});

		ns.right = new LogoFunction(
			"rt", 
			[N], 
			false,
			function(k, n) {
				self.right(n);
				k();
			});
		
		ns.left = new LogoFunction(
			"lt", 
			[N], 
			false,
			function(k, n) {
				self.right(k, 360-n);
			});

		ns.penup = new LogoFunction(
			"pu", 
			[], 
			false,
			function(k) {
				self.penup();
				k();
			});

		ns.pendown = new LogoFunction(
			"pd", 
			[], 
			false,
			function(k) {
				self.pendown();
				k();
			});

		ns.hideturtle = new LogoFunction(
			"ht", 
			[], 
			false,
			function(k) {
				self.hideturtle();
				k();
			});

		ns.showturtle = new LogoFunction(
			"st", 
			[], 
			false,
			function(k) {
				self.showturtle();
				k();
			});

		ns.setpencolor = new LogoFunction(
			"setpencolour", 
			[L], 
			false,
			function(k, rgba) {
				var r:Number = self.getColour(rgba[0]);
				var g:Number = self.getColour(rgba[1]);
				var b:Number = self.getColour(rgba[2]);
				self.rgb = b + (g << 8) + (r << 16);
				if(rgba.length >= 4) {
					self.alpha = getColour(rgba[3])*100/256;
				}
				k();
			});
		
		ns.rgba = new LogoFunction(
			"rgba", 
			[N,N,N,N], 
			false,
			function(k, r, g, b, a) {
				self.rgb = 'rgba('+[r, g, b, a].join()+')';
				k();
			});

		ns.setpensize = new LogoFunction(
			"setpensize", 
			[N], 
			false,
			function(k, t) {
				self.thickness = t;
			});

		ns.xpos = new LogoFunction(
			"xpos", 
			[], 
			false,
			function(k) {
				k(self.x);
			});
		
		ns.ypos = new LogoFunction(
			"ypos", 
			[], 
			false,
			function(k) {
				k(self.y);
			});
		
		ns.heading = new LogoFunction(
			"heading", 
			[], 
			false,
			function(k) {
				k(self.h);
			});
		
	}
	
	
	//
	// Utilities and Setter/Getters
	//
	function set rgb(n:Number):Void {
		_rgb = n;
		content.lineStyle(_thickness, _rgb, _alpha);
	}
	function get rgb():Number {
		return _rgb;
	}
	
	function set alpha(n:Number):Void {
		_alpha = n;
		content.lineStyle(_thickness, _rgb, _alpha);
	}
	function get alpha():Number {
		return _alpha;
	}
	
	function set thickness(n:Number):Void {
		_thickness = n;
		content.lineStyle(_thickness, _rgb, _alpha);
	}
	function get thickness():Number {
		return _thickness;
	}
	
	function getColour(obj:Object):Number {
		var n:Number = Number(obj);
		if(n==null || isNaN(n) || n < 0) {
			return 0;
		}
		if(n > 255) {
			return 255;
		}
		return Math.round(n);
	}
	

}
