﻿class Reader {
	
	// Bug: infix to prefix conversion does not respect parentheses
	//
	// make "n (2 * :n) + 5
	// > (make "n ( * 2 :n + ) 5)
	//
	
	var list:Array;
	// originally var separators = ["[","]","(",")","+","-","*","/","=","<",">"];
	var separators = ["[","]","(",")"];
	
	function Reader() {
	}
	
	public function read(str):Array {
		list = singleSpace(padSeparators(standardiseSpace(str)));
		list = transpose(list);
		return readOnce(list);
	}
	
	private function replaceAllWith(s:String, pattern:String, substitute:String):String {
		var x = 0;
		while((x = s.indexOf(pattern,x)) >= 0) {
			trace(pattern + ".length=" + pattern.length);
			s=s.slice(0,x)+substitute+s.slice(x+pattern.length);
		}
		return s;
	}
	
	private function standardiseSpace(s:String):String {
		// change all whitespace to ' '
		s = replaceAllWith(s, '\r', ' ');
		s = replaceAllWith(s, '\n', ' ');
		s = replaceAllWith(s, '\t', ' ');
		trace(s);
		return s;
	}
	
	private function padSeparators(s:String):String {
		var rv:String = s;
		for(var i=0; i < separators.length; i++) {
			var x:Number = 0;
			var sep:String = separators[i];
			while((x=s.indexOf(sep, x)) >= 0) {
				s = s.substring(0,x) + " " + sep + " " + s.substring(x+1);
				x += 3;
			}
		}
		return s;
	}
	
	public function singleSpace(s:String):Array {
		var r:Array =[];
		var a:Array = s.split(" ");
		for(var i=0; i < a.length; i++) {
			if(a[i]!="" && a[i]!=null) {
				r.push(a[i]);
			}
		}
		return r;
	}
		
	public function transpose(list:Array):Array {
		var result = new Array(list.length);
		for (var i=0; i<list.length; i++) {
			var each:String = list[i];
			if (each.length == 0) continue;
			// change arithmetic operators from infix to prefix notation
			// (a + b) -> (+ a b)
			else if (String("+*/-=<>").indexOf(each)>=0) {
				result[i] = result[i-1];
				result[i-1] = each;
			} else {result[i] = each};
		}
		return result;
	}
	
	public function readOnce(list:Array):Array {
	   var result = [];
		while(list.length > 0)
		{
			var listItem = list.shift();
			if(listItem !== null && listItem.length > 0)
			{
				if(listItem == "[")
					result[result.length] = readOnce(list);
				else if(listItem == "]")
					return result;
				else if(!isNaN(listItem))
					result.push(Number(listItem));
				else
					result.push(listItem.toString());
			}
		}
		return result;
	}
	
}
