﻿import DepthManager;
class MovableResizer extends MovieClip {
	
	var w:Number;
	var h:Number;
	var x0:Number;
	var y0:Number;
	var visibleResizer:MovieClip;
	
	function MovableResizer() {
		visibleResizer = attachMovie("ResizeButton", "visibleResizer", 1);
	}
	
	function drawRoundedRectangle(t,b,f,a,w,h,c,xs,ys):Void {
		if(onMouseMove != null)
			return;
		if(xs == null) xs = 0;
		if(ys == null) ys = 0;
		if(c==null) c = 0;
		lineStyle(t, b, 100);
		beginFill(f, a);
		moveTo(xs+c, ys);
		lineTo(xs+w-c, ys);
		curveTo(xs+w, ys, xs+w, ys+c);
		lineTo(xs+w, ys+h-c);
		curveTo(xs+w, ys+h, xs+w-c, ys+h);
		lineTo(xs+c, ys+h);
		curveTo(xs, ys+h, xs+0, ys+h-c);
		lineTo(xs, ys+c);
		curveTo(xs, ys, xs+c, ys);
		endFill();
		
		this.w = w;
		this.h = h;
		visibleResizer._x = w;
		visibleResizer._y = h;
	}
	
	// Add in move behaviour
	function onPress() {
		x0 = _parent._xmouse;
		y0 = _parent._ymouse;
		onMouseMove = function() {
			_parent.bringToFront();
			_parent.move(_root._xmouse-x0, _root._ymouse-y0);
		}
	}
	
	function onRelease() {
		onMouseMove();
		onMouseMove = undefined;
		_parent.moved();
	}
	function onReleaseOutside() {
		onRelease();
	}
}