﻿class Lexer {
	
	var instr:String;
	var instrx:Number = 0;
	var charx:Number = 0;
	var lastToken:Object = "";
	
	function Lexer() {
	}
	
	// Reads string and returns a token list
	function read(s:String):Array {
		instr = s;
		instrx = 0;
		charx = 0;
		var result:Array = [];
		for(var token:Object=getToken(); token != null; token = getToken()) {
			result.push(token);
		}
		return result;
	}
	
	function getToken():Object {
		//
		// Scan for possible number
		//
		var c:String;
		var pos:Number = instrx;
		if((c = getc()) == "" || c==null) {
			return lastToken = null;
		}

		var sign:Number = 1;
		if(isUnaryMinusContext(prevc())) { //)
		    while (c == "-" && instrx < instr.length) {
				sign = -sign;
				c = getc();
			}
			if(sign == -1) {
				ungetc(c);
				return lastToken = "strongMinus";
			}
			// else ignore cancelling minuses
		}
			
		if(isnum(c)) {
			var n:Number;
			instrx--;
			for(var j = 1; instrx+j <= instr.length; j++) {
				var sub:String = instr.substr(instrx, j);
				var m = Number(sub);
				if(isNaN(m)) {
					// Check for a possible '0x' opening to a hexadecimal number
					var sub2:String = instr.substr(instrx,j+1);
					if(!isNaN(Number(sub2))) {
						continue;
					}
					//trace("substring " + sub + " is not a number");
					break;
				}
				n = m;
			}
			instrx += (j-1);
			return lastToken = sign * n;
		}
		
		//trace("isalpha("+c+")");
		if(isalpha(c)) {
			var s:String = c;
			
			while(isalpha(c = instr.charAt(instrx)) && instrx < instr.length) {
				s += c;
				instrx++;
			}
			return lastToken = s;
		}
		
		if(c == "[") {
			// return a quoted list
			//trace("instr[instrx] = " + instr[instrx]);
			return lastToken = copyNested("[", "]");
		}
				  
		// else just return character 
		return lastToken = c;
	}
	
	function copyNested(startc:String, endc:String):String {
		//trace("instr[instrx] = " + instr.charAt(instrx));
		var s:String = startc;
		var nesting:Number = 1;
		var c:String = instr.charAt(instrx);
		for(; c != null && nesting > 0; c = instr.charAt(++instrx)) {
			s += c;
			if(c == endc) nesting--;
			if(c == startc) nesting++;
		}
		if(nesting > 0) {
			return null;
		}
		return s;
	}
	
	function getc():String {
		var c:String;
		charx = instrx;
		while(isspace(c = instr.charAt(instrx++)) && instrx < instr.length) {
			//++instrx;
			++charx;
		}
		return c;
	}
	
	function prevc():String {
		return instr.charAt(instrx-2);
	}
	
	function nextc():String {
		return instr.charAt(instrx);
	}
	
	function ungetc(c:String):Void {
		//char = c;
		instrx = charx;
	}
	
	function isnum(c:String):Boolean {
		return (c >= "0" && c <= "9");
	}

	function isalpha(c:String):Boolean {
		return (c >= "a" && c <= "z") || (c >= "A" && c <= "Z");
	}
	
	function isspace(c:String) {
		return c == " " || c == "\t" || c == "\n" || c == "\r";
	}
	
	function isUnaryMinusContext(t:String):Boolean {
		// see ucblogo: help "minus for an explanation of this
		var b:Boolean = (t == null) 
				|| (t.length = 0 || " (+-*/=".indexOf(t) >= 0 || (t==" " && nextc() != " "));
		//trace("lastToken = " + lastToken + " next = " + nextc() + " isUnary = " + b);
		return b;
	}
	/*
	function getToken():Object {
		var c:String;
		var pos:Number = instrx;
		if((c = getc()) == "") return null;
			
		switch(c) {
			case "+":
				return {name:ADDOP, value:"plus", pos:pos};
			case "-":
				return {name:ADDOP, value:"minus", pos:pos};
			case "*" :
				return {name:MULOP, value:"times", pos:pos};
			case "/" :
				return {name:MULOP, value:"over", pos:pos};
			case "^" :
				return {name:POWOP, value:"pow", pos:pos};
			case "~" : 
				return {name:CFUNC1, value:"conjugate", pos:pos};
			case "(" :
			case "{" :
			case "[" :
				return {name:OPEN, value:c, pos:pos};
			case ")" :
			case "}" :
			case "]" :
				return {name:CLOSE, value:c, pos:pos};
			case "," :
				return {name:COMMA, value:c, pos:pos};
			case "=" :
				if((c = getc()) == "=") {
					return {name:RELOP, value:"==", pos:pos};
				}
				else {
					ungetc(c);
					return {name:SYMBOL, value:"assignValue", pos:pos};
					//return {name:EQUALS, value:"=", pos:pos};
				}
			case "!" :
				if((c = getc()) == "=") {
					return {name:RELOP, value:"!=", pos:pos};
				}
				else {
					ungetc(c);
					return {name:CFUNC1, value:"logicalNot", pos:pos};
				}
			case ">" :
				if((c = getc()) == "=") {
					//trace("GREATER THAN OR EQUALS");
					return {name:RELOP, value:">=", pos:pos};
				}
				else {
					ungetc(c);
					return {name:RELOP, value:">", pos:pos};
				}
			case "<" :
				if((c = getc()) == "=") {
					return {name:RELOP, value:"<=", pos:pos};
				}
				else {
					ungetc(c);
					return {name:RELOP, value:"<", pos:pos};
				}
		}
		//
		// Scan for possible number
		//
		if(isnum(c)) {
			var n:Number;
			instrx--;
			for(var j = 1; instrx+j <= instr.length; j++) {
				var sub:String = instr.substr(instrx, j);
				var m = Number(sub);
				if(isNaN(m)) {
					// Check for a possible '0x' opening to a hexadecimal number
					var sub2:String = instr.substr(instrx,j+1);
					if(!isNaN(Number(sub2))) {
						continue;
					}
					//trace("substring " + sub + " is not a number");
					break;
				}
				n = m;
			}
			instrx += (j-1);
			return {name:NUMBER, value:n, pos:pos};
		}
		if(isalpha(c)) {
			var s:String = c;
			
			while(isalpha(c = instr.charAt(instrx)) && instrx < instr.length) {
				s += c;
				instrx++;
			}
			if(s=="pow") {
				return {name:CFUNC2, value:"pow", pos:pos};
			}
			else if((new Complex(0)).hasFunction(s)) {
				return {name:CFUNC1, value:s, pos:pos};
			}
			else {
				return {name:SYMBOL, value:s, pos:pos};
			}

		}
		return null;
	}
	
	function getc():String {
		//
		// return first character of string or the empty string when done
		//
		// Collapse strings of white space into single spaces
		//
		var c:String;
		charx = instrx;
		//if(c == null) {
			while(isspace(c = instr.charAt(instrx++))) {
				if(instrx >= instr.length) {
					return null;
				}
			}
		//}
		//char = null;
		return c;
	}
	
	function ungetc(c:String):Void {
		//char = c;
		instrx = charx;
	}

	function isspace(c:String) {
		return c == " " || c == "\t" || c == "\n" || c == "\r";
	}
	
	*/
}