﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.Button;
import mx.managers.DepthManager;
import Popup;
import TurtlePane;

// Event metadata tag 
class TurtleGraphics extends Popup {

	static var symbolName:String = "TurtleGraphics";
	static var symbolOwner:Object = TurtleGraphics;
	var className:String = "TurtleGraphics";

	var pane:TurtlePane;
	
	var clear_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
	}
	
	// Overide all textBox functions...
	public function createTextBox():Void {}
	public function drawTextBox():Void {}
	public function sizeTextBox():Void {}
	public function get code():String {return null;}
	public function set code(s:String):Void {}
	
	// And replace them with TurtlePane functions...
	public function createTurtlePane():Void {
		pane = TurtlePane(createClassChildAtDepth(TurtlePane, DepthManager.kTop,{_x:5,_y:20}));
		pane.setSize(width-10,height-25);
	}
	
	
	// But we do need a TurtleGraphics Window
	public function createChildren():Void {
		
		super.createChildren();
		
		createTurtlePane();
		
		clear_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:pane._y+pane.height+5}));
		clear_btn.setSize(50,22);
		clear_btn.label = "Clear";
		clear_btn.tabIndex = 2;
		clear_btn.addEventListener("click", this);
		
		minWidth = Math.max(minWidth, 10+clear_btn._width);
		
		size();
	}

	function draw():Void {
		super.draw();
	}

	function size():Void {
		super.size();
		pane.setSize(width-10,height-50);
		clear_btn.move(5,pane._y+pane.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case clear_btn: 
				// Update the member variables with the input field contents.
				pane.clearscreen();
				break;
		}
	}

	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
	}

}