﻿
import Ball;
import mx.controls.Alert;

class Grid extends MovieClip {
	
	//Want an N by N grid.
	var N:Number = 10;
	
	//Spacing between centres of balls.
	var space:Number = 35;
	
	//The current number pressed.
	var currentTag:Number = 0;
	
	//Arial font.
	var my_fmt:TextFormat;
	
	//Count the number of balls used.
	var tally:Number = 0;
	
	//Used for making the failed text vanish.
	var intervalID:Number = null;
	
	//Used for alert component.
	var oListener:Object;
	
	//Need to keep a record of the balls pressed, in order.
	var record:Array;
	
	//Constructor.
	function Grid() {
		
		
		//Format properties.
		my_fmt = new TextFormat(); 
		my_fmt.font = "Font 2";
		my_fmt.size =  16;
		
		//Add the failure label.
		var s = this.createTextField("failed_txt", this.getNextHighestDepth(),10,335,400,20); 
		s.selectable = false;
		s.autosize = true;
		s.embedFonts = true;
		s.setNewTextFormat(my_fmt); 
		s._visible = false;
		
		
		//Add the text label.
		var t = this.createTextField("tally_txt", this.getNextHighestDepth(),425,275,40,20); 
		t.selectable = false;
		t.autosize = true;
		t.embedFonts = true;
		my_fmt.size = 12;
		t.setNewTextFormat(my_fmt); 
		
		//Control of back button.
		this["back_btn"].onPress = backPress;
		
		//Control of reset button.
		this["reset_btn"].onPress = resetPress;
		
		//Make the initial grid.
		init();
		
		//Set up the alert component.
		oListener = new Object();
		oListener.click = clickAlert;
	}
	
	//This gets called when reset pressed.
	function clickAlert(oEvent:Object):Void {
		var mc = _level0.grid;
		switch(oEvent.detail) {
			case Alert.YES:
				mc.init();
			break;
			case Alert.NO:
				//trace("no");
			break;
		}
	}
	
	//Initialisation procedure.
	function init() {
		
		//Reset tag and tally.
		currentTag = tally = 0;
		
		//Reset the recording feature.
		record = new Array();
		
		//Initial text.
		this["tally_txt"].text = tally;
		
		//Delete the old balls if there are any.
		for (var i:Number = 1; i!=N*N+1; i++) 
				this["ball"+i].removeMovieClip();
				
		//Bring in the 100 balls.
		for (var i:Number = 0; i!=N; i++) {
			for (var j:Number = 0; j!=N; j++) {
				var tag:Number = 1+i+N*j;
				var b = Ball(attachMovie("Ball","ball"+tag,this.getNextHighestDepth(),
				{_x:space*i,_y:space*j,X:space*i,Y:space*j,tag:tag}));
				b.onPress = ballPress;
				b.onRelease = b.onReleaseOutside = ballRelease;
			}
		}
		
		//Delete the old history and create new history.
		this["history"].removeMovieClip();
		History(attachMovie("History","history",this.getNextHighestDepth(),{_x:375,_y:0}));
																			
	}
	
	//Press the back button.
	function backPress() {
		var tp = this._parent;
		if (tp.record.length == 0) {
			trace("do nothing");
		} else {
			//Identify the last ball.
			var b = tp["ball"+tp.record[tp.record.length-1]];
			
			//Reset its properties.
			b.colour = "grey";
			b._alpha = 100;
			b.changeColour();
			b.nullify = false;
			
			//Remove the ball from the history.
			tp["history"].removeBall(tp.record[tp.record.length-1]);
			
			//Update class.
			tp.tally--;
			tp.record.pop();
			tp.currentTag = (tp.record.length>0) ? tp.record[tp.record.length-1] : 0;

			
			//Update text.
			tp["tally_txt"].text = tp.tally;
			
		}
	}
	
	//Press the reset button.
	function resetPress() {
		
		//Launch alert box.
		//trace(this._parent);
		if (this._parent.canGo()) 
			Alert.show("Are you sure you wish to start again?","You can continue!", 
					   Alert.NO | Alert.YES, this._parent,this._parent.oListener);
		else this._parent.init();
	}
	
	//What happens when a ball is pressed?
	function ballPress():Void {
		var m:MovieClip = this;
		var tempColour:String = m.colour;
		m.colour = "white";
		m.changeColour();
		m.colour = tempColour;
	}
	
	
	function vanishText() {
		clearInterval(intervalID);
		this["failed_txt"]._visible = false;
	}
	
	//What happens when a ball is released?
	function ballRelease():Void {
		var m:MovieClip = this;
		var tp:MovieClip = this._parent;
		
		
		//Used for release outside to get the ball back in position.
		if ( (m._x-tp._xmouse)*(m._x-tp._xmouse)+(m._y-tp._ymouse)*(m._y-tp._ymouse) > 225 ) 
			m.relocateBall();
			
		//If ball already been pressed then do nothing.
		if (m.nullify) {
			m.changeColour();
			return;
		}
		//Otherwise test for factor/multiple.
		var s:String = tp.tester(tp.currentTag,m.tag);
		
		//Get rid of old text.
		clearInterval(tp.intervalID);
		tp["failed_txt"]._visible = false;
		
		//Abort if click something that is no good.
		if (s=="neither") {
			m.colour = "grey";
			m.changeColour();
			
			//Deal with fixed text.
			tp["failed_txt"]._visible = true;
			tp["failed_txt"].text = m.tag+" is neither a factor nor a multiple of "+tp.currentTag+".";
			tp.intervalID = setInterval(this._parent, "vanishText", 2000);
			
			return;
		} else { //Otherwise have clicked something good.
			
			//Change alphas.
			tp["ball"+tp.currentTag]._alpha = 100;
			m._alpha = 30;
			
			m.nullify = true; //Nullify the tag so can't be pressed again.
			tp.currentTag = m.tag; //Change current tag.			
			tp.tally++; //Update tally.
			tp["tally_txt"].text = tp.tally; //Update tally text.
			
			if (s=="starter") {
				m.colour = "yellow";
			} else if (s=="factor") {
				m.colour = "red";
			} else if (s=="multiple") {
				m.colour = "blue";
			}
			

			
			//Add a new ball to history.
			tp.record.push(m.tag);
		 	tp.history.newBall(m.tag,m.colour);
			trace("record = "+tp.record);
			
			//Change colour of sphere.
			m.changeColour();
			
		}
		
	}
	
	
	//Test if a is a factor, multiple, or neither of b.
	function tester(a:Number,b:Number):String {
		if (a==0) return "starter";
		else if (b%a == 0) return "factor";
        else if (a%b == 0) return "multiple";		
		else return "neither";
	}
	
	//This function tests if the person can still go.
	function canGo():Boolean {
		
		//Check if there are any factors or multiples of the current tag.
		for (var i:Number = 1; i != 101; i++) {
			if (!this["ball"+i].nullify) {
				var s:String = tester(currentTag,i); 
				if ( s=="factor" || s=="multiple" ) { return true; }
			}
		}
		return false;
	}
	
	
	
}