﻿
class Ball extends MovieClip {
	
	var tag:Number = 1;
	var my_fmt:TextFormat;
	
	//Colour of the ball.
	var colour:String = "grey";
	
	//Stop from working
	var nullify:Boolean = false;
	
	//Location of ball.
	var X:Number = this._x;
	var Y:Number = this._y;
	
	//Constructor.
	function Ball() {
		
		//Create label for the ball.
		createLabel();
		
		//Ball controls.
		if (!nullify) {
			this.onRollOver = rollover;
			this.onRollOut = relocateBall;
		}
	}
	
	//Make the ball label.
	function createLabel():Void {
		
		//Initialise the text format.
		my_fmt = new TextFormat(); 
		my_fmt.font = "Font 1";

		var t = this.createTextField("my_txt", this.getNextHighestDepth(),0,0,40,20); 
		t.selectable = false;
		t.autosize = true;
		t.text = tag;
		
		my_fmt.size =  17;
		t.embedFonts = true;
		t.setTextFormat(my_fmt); 
		
		t._x = -t.textWidth/2 - 2.5; t._y = -t.textHeight/2 - 2.5;
		t._alpha = 80;
		
	}
	
	//Action when mouse rolls over a ball.
	function rollover() {
		this._x -= 2;
		this._y += 2;
	}
	
	//Replace ball.
	function relocateBall() {
		this._x = X; this._y = Y;
	}
	
	//Change the colour of the ball to colour s.
	function changeColour():Void {
		switch (colour) {
			case "grey":
				this.gotoAndStop(1);
			break;
			case "yellow":
				this.gotoAndStop(2);
			break;
			case "red":
				this.gotoAndStop(3);
			break;
			case "blue":
				this.gotoAndStop(4);
			break;
			case "white":
				this.gotoAndStop(5);
			break;		
		}
	}
	
}