﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.containers.ScrollPane;
import mx.controls.Label;
import mx.controls.Button;
import mx.managers.DepthManager;
import LogoFunction;
import Popup;

// Event metadata tag 
class TurtleGraphics extends Popup {

	static var symbolName:String = "TurtleGraphics";
	static var symbolOwner:Object = TurtleGraphics;
	var className:String = "TurtleGraphics";

	var content:MovieClip;
	
	private var __x:Number = 0;
	private var __y:Number = 0;
	private var __h:Number = 0;
	var penDown:Boolean = true;
	var turtle:MovieClip;
	var drawPane:MovieClip;
	
	private var __thickness:Number = 2;
	private var __rgb:Number = 0;
	private var __alpha:Number = 80;
	
	static var N = LogoFunction.NUMBER;
	static var B = LogoFunction.BOOLEAN;
	static var W = LogoFunction.WORD;
	static var L = LogoFunction.LIST;
	static var WoL = LogoFunction.WORDorLIST;
	static var O = LogoFunction.OBJECT;

	var pane:ScrollPane;
	//var spane:ScrollPane;
	
	var clear_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
	}
	
	// Overide all textBox functions...
	public function createTextBox():Void {}
	public function drawTextBox():Void {}
	public function sizeTextBox():Void {}
	public function get code():String {return null;}
	public function set code(s:String):Void {}
	
	// And replace them with TurtlePane functions...
	public function createTurtlePane():Void {
		pane = ScrollPane(createClassChildAtDepth(ScrollPane, DepthManager.kTop,{_x:5,_y:20}));
		pane.setSize(width-10,height-25);
		pane.contentPath = "Screen";
		doLater(this, "initScreen");
	}
	
	public function initScreen():Void {
		content = pane.content;
		drawPane = content.drawPane;
		turtle = content.attachMovie("Turtle", "turtle", 1,{_alpha:40});
		home();
		drawPane.lineStyle(__thickness, __rgb, __alpha);
		pane.scrollDrag = true;
		centreTurtle();
		clearscreen();
		addTurtlePrimitives(_logo.functions);
	}
	
	public function centreTurtle():Void {
		pane.hPosition = tx-pane.width/2;
		pane.vPosition = ty-pane.height/2;
	}
	
	// But we do need a TurtleGraphics Window
	public function createChildren():Void {
		
		super.createChildren();
		
		createTurtlePane();
		
		clear_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:pane._y+pane.height+5}));
		clear_btn.setSize(50,22);
		clear_btn.label = "Clear";
		clear_btn.tabIndex = 2;
		clear_btn.addEventListener("click", this);
		
		minWidth = Math.max(minWidth, 10+clear_btn._width);
		
		size();
	}

	function draw():Void {
		super.draw();
		clear_btn.visible = pane.visible = !minimised;
	}

	function size():Void {
		super.size();
		pane.setSize(width-10,height-50);
		clear_btn.move(5,pane._y+pane.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case clear_btn: 
				// Update the member variables with the input field contents.
				clearscreen();
				break;
		}
	}

	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
	}
	
	//
	// Turtle graphics code start here
	//
	
	function clearscreen():Void {
		//trace("turtle clearscreen");
		bringToFront();
		if(minimised) minimised = false;
		drawPane.clear();
		home();
		drawPane.moveTo(tx,ty);
		if(penDown) {
			drawPane.lineStyle(__thickness, __rgb, __alpha);
		}
		//turtle._visible = true;
	}

	function forward(n):Void {
		//trace("turtle forward:"+n);
		var theta = this.h * Math.PI / 180;
		tx += n * Math.sin(theta);
		ty += -n * Math.cos(theta);
		  		
		if (penDown) {
			//trace("lineTo");
			drawPane.lineTo(tx, ty);
		}
	}

	function turn(n:Number):Void {
		//trace("turtle right:"+n);
		h += n;
		turtle._rotation = h;
	}

	function penup():Void {
		//trace("turtle penup");
		penDown = false;
	}

	function pendown():Void {
		//trace("turtle penDown");
		penDown = true;
	}

	function hideturtle():Void {
		//trace("turtle hide");
		turtle._visible = false;
	}

	function showturtle():Void {
		//trace("turtle show");
		turtle._visible = true;
	}

	function addTurtlePrimitives(ns:Object):Void {
		var self = this;
		
		ns.cs = ns.clearscreen = new LogoFunction(
			"cs", 
			[], 
			false,
			function(k) {
				self.clearscreen();
				k();
			});
		
		ns.fd = ns.forward = new LogoFunction(
			"fd", 
			[N], 
			false,
			function(k, n) {
				self.forward(n);
				this.wait.fn.call(this, k, n);
			});

		ns.bk = ns.back = new LogoFunction(
			"bk", 
			[N], 
			false,
			function(k, n) {
				self.forward(-n);
				this.wait.fn.call(this, k, n);
			});

		ns.rt = ns.right = new LogoFunction(
			"rt", 
			[N], 
			false,
			function(k, n) {
				//trace("right " + n);
				self.turn(n);
				k();
			});
		
		ns["lt"] = ns.left = new LogoFunction(
			"lt", 
			[N], 
			false,
			function(k, n) {
				self.turn(k, 360-n);
			});

		ns.pu = ns.penup = new LogoFunction(
			"pu", 
			[], 
			false,
			function(k) {
				self.penup();
				k();
			});

		ns.pd = ns.pendown = new LogoFunction(
			"pd", 
			[], 
			false,
			function(k) {
				self.pendown();
				k();
			});

		ns.ht = ns.hideturtle = new LogoFunction(
			"ht", 
			[], 
			false,
			function(k) {
				self.hideturtle();
				k();
			});

		ns.st = ns.showturtle = new LogoFunction(
			"st", 
			[], 
			false,
			function(k) {
				self.showturtle();
				k();
			});

		ns.setpc = ns.setpencolor = ns.setpencolour = new LogoFunction(
			"setpencolour", 
			[L], 
			false,
			function(k, rgba) {
				var r:Number = self.getColour(rgba[0]);
				var g:Number = self.getColour(rgba[1]);
				var b:Number = self.getColour(rgba[2]);
				self.rgb = b + (g << 8) + (r << 16);
				//trace("rgb = "+self.rgb.toString(16));
				if(rgba.length >= 4) {
					self.alpha = getColour(rgba[3])*100/256;
				}
				k();
			});
		
		ns.setps = ns.setpensize = new LogoFunction(
			"setpensize", 
			[N], 
			false,
			function(k, t) {
				self.thickness = t;
				k();
			});

		ns.setx = new LogoFunction(
			"setx", 
			[N], 
			false,
			function(k,n) {
				self.tx = n;
				k();
			});
		
		ns.sety = new LogoFunction(
			"sety", 
			[N], 
			false,
			function(k,n) {
				self.ty = n;
				k();
			});
		
		ns.setxy = new LogoFunction(
			"setxy", 
			[N,N], 
			false,
			function(k,nx,ny) {
				self.ty = nx;
				self.ty = ny;
				k();
			});
		   
		ns.xpos = new LogoFunction(
			"xpos", 
			[], 
			false,
			function(k) {
				k(self.tx);
			});
		
		ns.ypos = new LogoFunction(
			"ypos", 
			[], 
			false,
			function(k) {
				k(self.ty);
			});
		
		ns.heading = new LogoFunction(
			"heading", 
			[], 
			false,
			function(k) {
				k(self.h);
			});
		
	}
	
	
	//
	// Utilities and Setter/Getters
	//
	function home() {
		tx = drawPane._width/2;
		ty = drawPane._height/2;
		//trace("tx,ty="+turtle._x+","+turtle._y);
		h = 0;
	}
		
	// Setters and Getters
	function set tx(n:Number):Void {
		__x = n;
		turtle._x = n;
	}
	function get tx():Number {
		return __x;
	}
	function set ty(n:Number):Void {
		__y = n;
		turtle._y = n;
	}
	function get ty():Number {
		return __y;
	}

	function get h():Number {
		return __h;
	}
	function set h(n:Number):Void {
		__h = n;
		turtle._rotation = __h;
	}
	function set rgb(n:Number):Void {
		__rgb = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get rgb():Number {
		return __rgb;
	}
	
	function set alpha(n:Number):Void {
		__alpha = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get alpha():Number {
		return __alpha;
	}
	
	function set thickness(n:Number):Void {
		__thickness = n;
		drawPane.lineStyle(__thickness, __rgb, __alpha);
	}
	function get thickness():Number {
		return __thickness;
	}
	
	function getColour(obj:Object):Number {
		var n:Number = Number(obj);
		if(n==null || isNaN(n) || n < 0) {
			return 0;
		}
		if(n > 255) {
			return 255;
		}
		return Math.round(n);
	}
	
}