﻿/*
function Point(x, y) 
{
  this.x = x;
  this.y = y;
}

Point.prototype.max = function(aPoint)
{
  return this.magnitude > aPoint.magnitude ? this : aPoint;
};

Point.prototype.magnitude = function()
{
  return Math.sqrt(this.x * this.x + this.y * this.y);
};
*/
class Turtle {
	
	var x:Number = 0;
	var y:Number = 0;
	var h:Number = 0;
	var penIsDown:Boolean = true;
	var turtleIsVisible:Boolean = false;
	var color = 0;
	var screen:Object = null;
	var sprite:Object = null;
	
	function Turtle(screen)
	{
	  this.screen = screen;
	}
	
	function setSprite(sprite)
	{
	  this.sprite = sprite;
	  turtleIsVisible = true;
	  screen.initSprite(sprite);
	};
	
	function clearscreen()
	{
	  screen.clear();
	  if (sprite) sprite.home();
	  x = 0;
	  y = 0;
	  h = 0;
	}
	
	function forward(n)
	{
	  var theta = this.h * Math.PI / 180
	  var x = this.x + Math.sin(theta) * n;
	  var y = this.y + Math.cos(theta) * n;
	  
	  if (sprite)  {
		sprite.goTo(x,y);
	  }
	  
	  if (penIsDown)
	  {
		screen.color(this.color)
		screen.line(this.x, this.y, x, y);
	  }
		
	  this.x = x;
	  this.y = y;
	}
	
	Turtle.prototype.right = function(n)
	{
	  this.h = (this.h + n) % 360;
	  if (this.sprite && this.turtleIsVisible) this.sprite.rotateTo(this.h);
	}
	
	Turtle.prototype.penup = function()
	{
	  this.penIsDown = false;
	}
	
	Turtle.prototype.pendown = function()
	{
	  this.penIsDown = true;
	}
	
	Turtle.prototype.hide = function()
	{
	  this.sprite.clear();
	  this.turtleIsVisible = false;
	};
	
	Turtle.prototype.show = function()
	{
	  this.sprite.goTo(this.x, this.y);
	  this.sprite.rotateTo(this.h);
	  this.turtleIsVisible = true;
	};
	
	Turtle.prototype.addPrimitives = function(namespace)
	{
	  var self = this;
	  
	  namespace.clearscreen = function(k)
	  {
		self.clearscreen();
		k() 
	  }
	
	  namespace.forward = function(k, n)
	  {
		self.forward(n);
		this.delay(k, n);
	  }
	
	  namespace.right = function(k, n)
	  {
		self.right(n);
		k()
	  }
	  
	  namespace.penup = function(k)
	  {
		self.penup();
		k()
	  }
	  
	  namespace.pendown = function(k)
	  {
		self.pendown();
		k()
	  }
	
	  namespace.hideturtle = function(k)
	  {
		self.hide();
		k();
	  }
	
	  namespace.showturtle = function(k)
	  {
		self.show();
		k();
	  }
	
	  namespace.color = function(k, color)
	  {
		self.color = color;
		k();
	  }
	
	  namespace.rgba = function(k, r, g, b, a)
	  {
		self.color = 'rgba(' + [r,g,b,a].join() + ')';
		k();
	  }
	  
	  namespace.xpos = function(k)
	  {
		k(self.x)
	  }
	
	  namespace.ypos = function(k)
	  {
		k(self.y)
	  }
	
	  namespace.heading = function(k)
	  {
		k(self.h)
	  }
	
	  // short forms
	  namespace.cs = namespace.clearscreen;
	  namespace.fd = namespace.forward;
	  namespace.rt = namespace.right;
	  namespace.pu = namespace.penup;
	  namespace.pd = namespace.pendown;
	  namespace.ht = namespace.hideturtle;
	  namespace.st = namespace.showturtle;
		
	}
}
