﻿class Transcript {
	var limit:Number = 100;
	var contents:Array;
	var tracing:Boolean = false;
	var tracingStack:Array;
	var output:Object;
	var gatherStart:Number;
	var name = "Transcript";
	function Transcript() {
		clear();
	}
	/*
	function addPrimitives(obj) {
		var self = this;
		var oldCs = obj.clearscreen;
		obj.clearscreen = function(k) {
			self.clear();
			oldCs(k);
		};
		obj.clearscreen.logoArity = 0;
		obj.clearscreen.name = "cs";
	}
	*/
	function clear() {
		contents = [];
		tracingStack = [];
		//update();
	}
	
	static function showString(line:Object, showing:Boolean):String {
		if(line instanceof Array) {
			var str = showing ? "[" : "";
			var sep = "";
			for(var i=0; i < line.length; i++) {
				str += sep + showString(line[i], true);
				sep = " ";
			}
			str += showing ? "]" : ""; 
			return str;
		}
		if(typeof line == "string") {
			return line.charAt(0) == '"' ? line.slice(1) : line;
		}
		return line.toString();
	}
	
	function show(line:Object):Void {
		printString(Transcript.showString(line, true));
	}
	
	function print(line:Object) {
		printString(Transcript.showString(line, false));
	}
	
	function printString(line:String) {
		if(tracing) {
			trace(line);
		}
		else {
			//trace(line + " " + contents.length);
			if(output.minimised) output.minimised = false;
			output.bringToFront();
			var lines:Array = line.split("\r");
			/*
			for(var oneLine=lines.shift(); oneLine != null; oneLine=lines.shift()) {
				contents.push(oneLine);
				if (contents.length > limit) {
					contents.shift();
				}
			}
			*/
			var lossCount = lines.length + contents.length - limit;
			if(lossCount > 0)
				contents = contents.slice(lossCount).concat(lines);
			else
				contents = contents.concat(lines);
			
			output.code = text; //(line + "\r");
		}
	}
	
	function startGather():Void {
		tracingStack.push(tracing);
		tracing = false;
		gatherStart = contents.length;
	}
	
	function endGather():String {
		var s:String = "";
		var sep:String = "";
		for (var i = gatherStart; i<contents.length; i++) {
			s += (sep + contents[i]);
			sep = "\r";
		}
		tracing = Boolean(tracingStack.pop());
		return s;
	}
	
	function get text():String {
		var s:String = "";
		for (var i = 0; i<contents.length; i++) {
			s += (contents[i] + "\r");
		}
		return s;
	}
}
