﻿interface Screen {
	function Screen(canvas)
{
  if (canvas) 
  {
    this.canvas = canvas;
    this.initialize();
  }
}

Screen.prototype.initialize = function()
{
  this.ctx = this.canvas.getContext("2d");
  this.ctx.lineCap = 'round';
  this.ctx.lineJoin = 'round';
	this.ctx.translate(this.width()/2, this.height()/2);
	this.ctx.save();
};

Screen.prototype.clear = function()
{
	this.ctx.clearRect(
		-this.width()/2, 
		-this.height()/2, 
		this.width(),
		this.height()
	);
}

Screen.prototype.color = function(color)
{
	this.ctx.strokeStyle = color;
}

Screen.prototype.line = function(ox, oy, dx, dy)
{
  this.ctx.beginPath();
  this.ctx.moveTo(ox, -oy);
  this.ctx.lineTo(dx, -dy);
  this.ctx.stroke();
}

Screen.prototype.width = function()
{
  return this.canvas.getAttribute('width');
};

Screen.prototype.height = function()
{
  return this.canvas.getAttribute('height');
};

Screen.prototype.size = function()
{
  var w = this.width();
  var h = this.height();
  return w < h ? w : h;
};

Screen.prototype.initSprite = function(sprite)
{
  sprite.setScreen(this.canvas)
};

