﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.containers.ScrollPane;
import mx.controls.Button;
import mx.managers.DepthManager;
import MovableResizer;

// Event metadata tag 
class Popup extends UIComponent {

	/* Components must declare these member variables to be proper
	   components in the components framework. */
	static var symbolName:String = "Popup";
	static var symbolOwner:Object = Popup;
	var className:String = "Popup";
	
	// The component's graphical representation.
	private var titleLabel:Label;
	public var textBox:TextArea;
	private var close_btn:Button;
	//private var boundingBox_mc:MovieClip;
	private var startDepth:Number = 10;
	private var container:MovableResizer;
	private var resizer:MovieClip;
	private var maximiser:MovieClip;
	
	private var name_label:MovieClip;
	private var password_label:MovieClip;
	private var password_ti:MovieClip;

	private var __title:String;
	private var __code:String="";
	private var __borderRGB:Number=0;
	private var __thickness:Number;
	private var __fillRGB:Number=0xEEDDFF;
	private var __corner:Number=10;
	private var __shadowRGB:Number=0;
	private var __shadowAlpha:Number=40;
	private var __xShadow:Number=2;
	private var __yShadow:Number=2;
	private var __minWidth:Number = 100;
	private var __minHeight:Number = 100;
	private var __minimised:Boolean = false;
	
	private var wMaximised:Number;
	private var hMaximised:Number;
	private var wMinimised:Number = 150;
	private var hMinimised:Number = 22;
	private var xMaximised:Number;
	private var yMaximised:Number;
	private var xMinimised:Number;
	private var yMinimised:Number;
	
	static var yDock:Number = 5;

	function Popup() {
	}
	
	function init():Void {
		super.init();
		//boundingBox_mc._visible = false;
		//boundingBox_mc._width = 0;
		//boundingBox_mc._height = 0;
		setSize(200,200);
		xMinimised = 550 - wMinimised - 5;
		yMinimised = yDock;
		yDock += (hMinimised+5);
	}
	
	function bringToFront():Void {
		//trace("to front");
		MovieClip(this).setDepthTo(DepthManager.kTop);
	} 
	
	public function createChildren():Void {
		
		enabled = true;
		createContainer();
		createResizer();
		createMaximiser();
		
		titleLabel = Label(createClassChildAtDepth(Label, DepthManager.kTop));
		titleLabel.text = __title;
		titleLabel.setSize(100,22);
		titleLabel._x = 10;
		titleLabel._y = 0;
		
		createTextBox();

		size();
	}

	public function createTextBox():Void {
		textBox = TextArea(createClassChildAtDepth(TextArea, DepthManager.kTop,{_x:5,_y:20}));
		textBox.setSize(width-10,height-25);
		textBox.html = false;
		textBox.text = __code;
		textBox.tabIndex = 1;
		textBox.setFocus(); 
	}
		
	function createMaximiser():Void {
		maximiser = MovieClip(createChildAtDepth("Maximise", DepthManager.kTop, {_x:0, _y:0}));
		maximiser.gotoAndStop(2);
		maximiser.onRelease = function() {
			if(this._currentframe == 2) {
				_parent.minimised = true;
			}
			else {
				_parent.minimised = false;
			}
		}
	}
	
	function sizeMaximiser():Void {
		maximiser._x = width - 11;
		maximiser._y = 11;
	}
	
	function createContainer():Void {
		container = MovableResizer(createChildAtDepth("MovableResizer", DepthManager.kTop, {_x:0, _y:0}));
		drawContainer();
	}
	
	function drawContainer():Void {
		container.clear();
		container.drawRoundedRectangle(undefined, undefined, __shadowRGB, __shadowAlpha, width, height, __corner, __xShadow, __yShadow); 
		container.drawRoundedRectangle(undefined, undefined, __fillRGB, 100, width, height, __corner, 0, 0); 		
	}
	
	function createResizer():Void {
		resizer=createChildAtDepth("ResizeButton", "resizer", DepthManager.kTop);
		resizer._x = width;
		resizer._y = height;
		resizer.minWidth = minWidth;
		resizer.minHeight = minHeight;
		resizer.setDepthAbove(container); // why is this needed ???
		resizer._alpha=0;
		resizer.vis = container.visibleResizer;
		resizer.onRollOver = function() {
			//trace(this.vis);
			this.vis.gotoAndStop(2);
			//gotoAndStop(2);
		}
		resizer.onRollOut = function() {
			this.vis.gotoAndStop(1);
			//gotoAndStop(1);
		}
		resizer.onReleaseOutside = resizer.onRelease = function() {
			this.stopDrag();
			this.onMouseMove();
			this.onMouseMove = undefined;
			this.vis.gotoAndStop(1);
			//gotoAndStop(1);
		}
		resizer.onPress = function() {
			this.vis.gotoAndStop(3);
			//gotoAndStop(3);
			this.startDrag(false, this.minWidth, this.minHeight, 550, 400);
			this.onMouseMove = function() {
				_parent.setSize(this._x, this._y);
			}
		}
	}
	/* The draw method is required for v2 components.
	   It is invoked after the component has been
	   invalidated by someone calling invalidate().
	   This batch’s up the changes into one redraw, rather
	   than doing them all individually. This approach leads
	   to more efficiency and better centralization of code. */
	function draw():Void {
		super.draw();
		drawContainer();
		drawTextBox();
		textBox.visible = resizer.vis._visible = !minimised;
		if(minimised) {
			maximiser.gotoAndStop(1);
		}
		else {
			maximiser.gotoAndStop(2);
		}
	}

	function moved():Void {
		if(minimised) {
			xMinimised = x;
			yMinimised = y;
		}
	}
	
	function drawTextBox():Void {
		textBox.text = __code;
	}
	
	
	/* The size method is invoked when the component's size
	   changes. This is an opportunity to resize the children,
	   The size method is required for components extending UIComponent. */
	function size():Void {
		super.size();
		if(!minimised) {
			close_btn.move(width-52,0);
			sizeTextBox();
			resizer._x = width;
			resizer._y = height;
			resizer.minWidth = minWidth;
			resizer.minHeight = minHeight;
		}
		sizeMaximiser();
		// Cause a redraw in case it is needed.
		invalidate();
	}

	function sizeTextBox():Void {
		textBox.setSize(width-10,height-25);
	}
	
	//
	// Setters and Getters which may invalidate() and so force a redraw.
	//
	function set title(val:String){
		__title = val;
		invalidate();
	}
	
	function get title():String{ 
		return(__title);
	}
	
	function set minimised(val:Boolean){
		__minimised = val;
		if(val) {
			xMaximised = x;
			yMaximised = y;
			wMaximised = width;
			hMaximised = height;
			setSize(wMinimised,hMinimised);
			move(xMinimised, yMinimised);
			MovieClip(this).setDepthTo(DepthManager.kBottom);
		}
		else {
			setSize(wMaximised, hMaximised);
			move(xMaximised, yMaximised);
		}
		invalidate();
	}
	
	function get minimised():Boolean{ 
		return(__minimised);
	}
	

	function set code(val:String){
		__code = val;
		//textBox.text = val;
		//trace("__code = " + __code);
		invalidate();
	}
	
	function get code():String{
		return textBox.text;
		//return(__code);
	}
	
	function set borderRGB(val:Number){
		__borderRGB = val;
		invalidate();
	}
	
	function get borderRGB():Number{ 
		return(__borderRGB);
	}

	function set fillRGB(val:Number){
		__fillRGB = val;
		invalidate();
	}
	
	function get fillRGB():Number{ 
		return(__fillRGB);
	}

	function set thickness(val:Number){
		__thickness = val;
		invalidate();
	}
	
	function get thickness():Number{ 
		return(__thickness);
	}

	function set corner(val:Number){
		__corner = val;
		invalidate();
	}
	
	function get corner():Number{ 
		return(__corner);
	}
	
	function set shadowRGB(val:Number){
		__shadowRGB = val;
		invalidate();
	}
	
	function get shadowRGB():Number{ 
		return(__shadowRGB);
	}

	function set xShadow(val:Number){
		__xShadow = val;
		invalidate();
	}
	
	function get xShadow():Number{ 
		return(__xShadow);
	}
	
	function set yShadow(val:Number){
		__yShadow = val;
		invalidate();
	}
	
	function get yShadow():Number{ 
		return(__yShadow);
	}

	function set minWidth(val:Number){
		__minWidth = val;
		invalidate();
	}
	
	function get minWidth():Number{ 
		return(__minWidth);
	}

	function set minHeight(val:Number){
		__minHeight = val;
		invalidate();
	}
	
	function get minHeight():Number{ 
		return(__minHeight);
	}

	function runcode(evt:Object) {
		trace("runcode");
	}
}
