﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.containers.ScrollPane;
import mx.controls.Button;
import mx.managers.DepthManager;
import Popup;

// Event metadata tag 
class Output extends Popup {

	static var symbolName:String = "Output";
	static var symbolOwner:Object = Output;
	var className:String = "Output";

	var getCode:Function; // call to get initial code.
	
	var clear_btn:Button;
	var pause_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
		__code = (getCode == null)? "" : getCode();
	}
	
	public function createChildren():Void {
		
		super.createChildren();
		
		clear_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:textBox._y+textBox.height+5}));
		clear_btn.setSize(50,22);
		clear_btn.label = "Clear";
		clear_btn.tabIndex = 2;
		clear_btn.addEventListener("click", this);
		
		pause_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:clear_btn._x+clear_btn.width+5,_y:textBox._y+textBox.height+5}));
		pause_btn.setSize(66,22);
		pause_btn.label = "Pause";
		pause_btn.tabIndex = 3;
		pause_btn.addEventListener("click", this);

		minWidth = Math.max(minWidth, 5+pause_btn._x + pause_btn._width);
		
		size();
	}

	function draw():Void {
		super.draw();
		clear_btn.visible = pause_btn.visible = !minimised;
		pause_btn.visible &= _logo.scheduler.running;
	}

	function size():Void {
		super.size();
		textBox.setSize(width-10,height-50);
		clear_btn.move(5,textBox._y+textBox.height+5);
		pause_btn.move(clear_btn._x+clear_btn.width+5, textBox._y+textBox.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case clear_btn: 
				// Update the member variables with the input field contents.
				code = "";
				_logo.transcript.clear();
				break;
			case pause_btn: 
				if(pause_btn.label == "Pause") {
					trace("Pause");
					_logo.scheduler.pause();
					pause_btn.label = "Resume";
					
				}
				else {
					trace("Resume");
					_logo.scheduler.resume();
					pause_btn.label = "Pause";
				}
				break;
		}
	}

	//
	// Scheduler events
	//
	public function logoRunning() {
		pause_btn.label = "Pause";
		pause_btn.visible = true;
	}
	
	public function logoPaused() {
		pause_btn.label = "Resume";
		pause_btn.visible = true;
	}
	
	public function logoStopped() {
		pause_btn.label = "Pause";
		pause_btn.visible = false;
	}
	
	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
		_logo.scheduler.addEventListener("logoStopped", this);
		_logo.scheduler.addEventListener("logoRunning", this);
		_logo.scheduler.addEventListener("logoPaused", this);
	}

}