﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.containers.ScrollPane;
import mx.controls.Button;
import mx.managers.DepthManager;
import Popup;

// Event metadata tag 
class Editor extends Popup {

	static var symbolName:String = "Editor";
	static var symbolOwner:Object = Editor;
	var className:String = "Editor";

	var getCode:Function; // call to get initial code.

	var run_btn:Button;
	var reset_btn:Button;
	var halt_btn:Button;
	var load_btn:Button;
	var save_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
		__code = (getCode == null)? "" : getCode();
	}
	
	public function createChildren():Void {
		
		super.createChildren();
		
		run_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:textBox._y+textBox.height+5}));
		run_btn.setSize(31,22);
		run_btn.label = "Run";
		run_btn.tabIndex = 2;
		run_btn.addEventListener("click", this);

		halt_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:run_btn.x+run_btn.width+5,_y:textBox._y+textBox.height+5}));
		halt_btn.setSize(38,22);
		halt_btn.label = "Halt";
		halt_btn.tabIndex = 3;
		halt_btn.addEventListener("click", this);

		reset_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:halt_btn.x+halt_btn.width+5,_y:textBox._y+textBox.height+5}));
		reset_btn.setSize(52,22);
		reset_btn.label = "Revert";
		reset_btn.tabIndex = 4;
		reset_btn.addEventListener("click", this);

		load_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:run_btn._y+run_btn.height+5}));
		load_btn.setSize(38,22);
		load_btn.label = "Load";
		load_btn.tabIndex = 5;
		load_btn.addEventListener("click", this);

		save_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:load_btn.x+load_btn.width+5,_y:run_btn._y+run_btn.height+5}));
		save_btn.setSize(38,22);
		save_btn.label = "Save";
		save_btn.tabIndex = 6;
		save_btn.addEventListener("click", this);

		minWidth = Math.max(minWidth, 5+reset_btn._x + reset_btn._width);

		size();
	}

	function draw():Void {
		super.draw();
		run_btn.visible 
			= halt_btn.visible 
			= reset_btn.visible 
			= load_btn.visible 
			= save_btn.visible 
			= !minimised;
	}

	function size():Void {
		super.size();
		textBox.setSize(width-10,height-80);
		run_btn.move(5,textBox._y+textBox.height+5);
		halt_btn.move(run_btn.x+run_btn.width+5,textBox._y+textBox.height+5);
		reset_btn.move(halt_btn.x+halt_btn.width+5,textBox._y+textBox.height+5);
		load_btn.move(5,run_btn._y+run_btn.height+5);
		save_btn.move(load_btn.x+load_btn.width+5,run_btn._y+run_btn.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case run_btn: 
				// Update the member variables with the input field contents.
				__code = textBox.text;
				run_btn.enabled=false;
				_logo.eval(textBox.text);
				break;
			case reset_btn:
				_logo.scheduler.doStop();
				code = getCode();
				break;
			case halt_btn:
				_logo.scheduler.doStop();
				break;
			case load_btn:
				trace('load');
				loadCodeFrom(1);
				break;
			case save_btn:
				trace('save');
				saveCodeAs(1);
				break;
		}
	}

	// Event received when a logo evaluation stops
	function logoStopped(evt:Object) {
		//trace("logoStopped");
		run_btn.enabled = true;
	}
	
	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
		_logo.scheduler.addEventListener("logoStopped", this);
	}

	// 
	// Loading and Saving Logo Programs
	//
	static var enableMsg:String = "Right click to enable Shared Object storage";
	function saveCodeAs(n:Number):Void {
		var so:SharedObject = SharedObject.getLocal("Logo"+n);
		if(so == null) {
			_logo.write(enableMsg);
			return;
		}
		so.data.code = code;
		if(so.flush() == "pending") {
			_logo.write("Please increase allowed storage");
		}
	}
	function loadCodeFrom(n:Number):Void {
		var so:SharedObject = SharedObject.getLocal("Logo"+n);
		if(so == null) {
			_logo.write(enableMsg);
			return;
		}
		__code = textBox.text = so.data.code;
	}
}