﻿import mx.events.EventDispatcher;
import Evaluator;
class Scheduler extends EventDispatcher {
	static var instances:Array=null;
	var speed:Number = 1;
	var running:Boolean = false;
	var k:Function;
	var name:String = "Scheduler";
	var intervalId:Number = null;
	var evaluator:Evaluator;
	var paused:Boolean = false;
	
	function Scheduler() {
		if(instances == null) {
			instances = [];
		}
		instances.push(this);
	}
	function run(thisObject:Object, main:Function, list:Array):Void {
		evaluator = Evaluator(thisObject);
		this.k = null;
		main.call(thisObject, list, k);
		runLoop();
	}
	
	function runLoop() {
		while (running && !paused && this.k != null) {
			var k = this.k;
			this.k = null;
			k();
		}
		if(intervalId == null && !paused) {
			doStop();
		}
	}
	
	function cont(k) {
		this.k = k;
	}
	
	function go() {
		running = true;
		dispatchEvent({type:"logoRunning", target:this});
	}
	
	function doStop() {
		running = false;
		trace("dispatching logoStop");
		dispatchEvent({type:"logoStopped", target:this});
	}
	
	function pause() {
		if(running) {
			dispatchEvent({type:"logoPaused", target:this});
			paused = true;
		}
	}
	
	function resume() {
		if(running) {
			dispatchEvent({type:"logoRunning", target:this});
			paused = false;
			runLoop(k);
		}
	}
	
	function apply(ns, fn, args, k) {
		// this is equivalent to calling ns.fn(k, args[0], args[1],...)
		//trace("scheduling a ["+fn.name+"]");
		var all = [k].concat(args);
		this.k = function() {
			//trace("applying a {" + fn.name +"}");
			fn.apply(ns, all);
		};
	}
	
	function delay(n, k) {
		var self = this;
		//trace("speed = " + speed + " n = " +n);
		if (speed<1) {
			cont(k);
		} else if (running) {
			var kk = function () {
				//trace("kk called after delay: self = " + self.name + " k = " + k + " intervalId = " + intervalId);
				if(self.intervalId != null) {
					clearInterval(self.intervalId);
					self.intervalId = null;
				}
				//self.cont(k);
				self.run(self.evaluator, k);
			};
			//trace("Scheduler should call kk after interval:"+Math.abs(n/speed));
			
			var period = Math.abs(n/speed);
			intervalId = setInterval(kk, period);
			//window.setTimeout(kk, Math.abs(n/this.speed));	
		}
	}
	
	function addPrimitives(ns) {
		var self = this;
		//
		// wait for n milliseconds before continuing
		//
		ns.delay = ns.wait = new LogoFunction(
			"wait", 
			[LogoFunction.NUMBER], 
			false,
			function(k, n) {
				//trace("WAITING self="+self + " " + self.name);
				self.delay(n, k);
			}
		);
		
		// stop the program
		ns.stop = ns.halt = new LogoFunction(
			"halt", 
			[], 
			false,
			function(k, n) {
				self.stop();
			}
		);
	}
	
	static function stopAll() {
		for (var p in instances) {
			instances[p].stop();
		}
	}
}
