﻿import Evaluator;
import LogoFunction;

//
// TODO: print formatting commands 
//

class Primitives /*extends Namespace*/ {
	var evaluator:Evaluator;
	var tracedprocs:Object;
	var name:String = "Primitives";
	static var N = LogoFunction.NUMBER;
	static var B = LogoFunction.BOOLEAN;
	static var W = LogoFunction.WORD;
	static var L = LogoFunction.LIST;
	static var WoL = LogoFunction.WORDorLIST;
	static var O = LogoFunction.OBJECT;
	
	//
	// Primitives
	//
	var print:LogoFunction;
	var show:LogoFunction;
	var run:LogoFunction;
	var make:LogoFunction;
	var ptrace:LogoFunction;
	var repeat:LogoFunction;
	var strace:LogoFunction;
	var untrace:LogoFunction;
	var If:LogoFunction;
	var ifelse:LogoFunction;
	var minus:LogoFunction;
	var sum:LogoFunction;
	var difference:LogoFunction;
	var product:LogoFunction;
	var quotient:LogoFunction;
	var floor:LogoFunction;
	var equalp:LogoFunction;
	var lessp:LogoFunction;
	var greaterp:LogoFunction;
	var fput:LogoFunction;
	var lput:LogoFunction;
	var first:LogoFunction;
	var butfirst:LogoFunction;
	var last:LogoFunction;
	var butlast:LogoFunction;
	var item:LogoFunction;
	var empty:LogoFunction;
	var member:LogoFunction;
	var list:LogoFunction;
	var word:LogoFunction;
	var sentence:LogoFunction;
	
	
	function Primitives(evaluator:Evaluator) {
		// evaluator run may be the wrong choice
		// see Evaluator.addPrimitives - which adds a run routine to a Namespace.
		this.evaluator = evaluator;
		tracedprocs = {};
		
		//
		// logo primitives
		//
		print = new LogoFunction(
			"print", 
			[O], 
			false,
			function(k, obj) {
				//trace("printing...." + evaluator.name + "("+wordOrList+")");
				evaluator.transcript.print(obj);
				k();
			}
		);

		show = new LogoFunction(
			"show", 
			[O], 
			false,
			function(k, obj) {
				//trace("showing...." + evaluator.name + "("+wordOrList+")");
				evaluator.transcript.show(obj);
				k();
			}
		);

		run = new LogoFunction(
			"run", 
			[L], 
			false,
			function(k, list) {
				//trace("running + " + list);
				var copy = [].concat(list);
				evaluator.setEscape(k);
				evaluator.run(copy, k);
			}
		);

		make = new LogoFunction(
			"make", 
			[W, O], 
			false,
			function(k, name, val) {
				k(evaluator.variables.parent[name] = val);
			}
		);
		
		ptrace = new LogoFunction(
			"ptrace", 
			[N], 
			false,
			function(k, onoff) {
				k(evaluator.parseTrace = onoff);
			}
		);

		repeat = new LogoFunction(
			"repeat", 
			[N,L], 
			false,
			function(k:Function, n:Number, listVar:Array):Void {
				if (n == 0) {
					k();
				} else {
					var self:Primitives = this;
					run.fn.call(this, function (v) {
						self.repeat.fn.call(self, k, n-1, listVar);
					}, listVar);
				}
			}
		);
		
		strace = new LogoFunction(
			"trace",
			[WoL],
			false,
			function (k, listVar):Void {
				if(isList(listVar)) {
					for(var i = 0; i < listVar.length; i++) {
						addTrace(listVar[i]);
					}
				}
				else if(isWord(listVar)) {
					addTrace(listVar);
				}
				k();
			}
		);
		this['trace'] = strace; 
		
		untrace = new LogoFunction(
			"untrace",
			[],
			false,
			function(k:Function):Void {
				for(var proc in tracedprocs) {
					var fn = tracedprocs[proc];
					fn.traced = null;
				}
				tracedprocs = {};
				k();
			}
		);
	
		If = new LogoFunction(
			"if",
			[B,L],
			false,
			function (k, bool, listVar):Void {
				if (bool) {
					run.fn.call(this, k, listVar);
				} else {
					k();
				}
			}
		);
		
		ifelse = new LogoFunction(
			"ifelse",
			[B,L,L],
			false,
			function (k, bool, yes, no):Void {
				if (bool) {
					run.fn.call(this, k, yes);
				} else {
					run.fn.call(this, k, no);
				}
			}
		);
		
		// numeric operations
		minus = new LogoFunction(
			"minus",
			[N],
			false,
			function(k, a):Void {
				k(-a);
			}
		);

		sum = new LogoFunction(
		   "+", 
		   [N,N],
		   true,
		   function(k, first, second):Void {
				var rv:Number = 0;
				for (var i = 1; i<arguments.length; i++) {
					rv += arguments[i];
				}
				k(rv);
			}
		);

		difference = new LogoFunction(
		   "-", 
		   [N,N],
		   false,
			function(k, a, b):Void {
				k(a-b);
			}
		);
		
		product = new LogoFunction(
		  	"*", 
		   [N,N],
		   true,
		   function(k, first, second):Void {
				var rv:Number = 1;
				for (var i = 1; i<arguments.length; i++) {
					rv *= arguments[i];
				}
				k(rv);
			}
		);
		
		quotient = new LogoFunction(
		  	"/", 
		   	[N,N],
		   	false,
			function(k, a, b):Void {
				k(a/b);
			}
		);
		
		this["="] = equalp = new LogoFunction(
		  	"equalp", 
		   	[O,O],
		   	false,
			function(k, a, b):Void {
				k(isEqual(a, b));
			}
		);
		
		lessp = new LogoFunction(
		  	"<", 
		   	[N,N],
		   	false,
			function(k, a, b):Void {
				k(a<b);
			}
		);
		
		greaterp = new LogoFunction(
		  	">", 
		   	[N,N],
		   	false,
			function(k, a, b):Void {
				k(a>b);
			}
		);
		
		// Math functions
		floor = new LogoFunction(
		  	"int", 
		   	[N],
		   	false,
			function(k, a):Void {
				k(Math.floor(a));
			}
		);
	
		// list operations
		fput = new LogoFunction(
		  	"fput", 
		   	[O,WoL],
		   	false,
			function(k, thing, listVar):Void {
				k([thing].concat(listVar));
			}
		);
		
		lput = new LogoFunction(
		  	"lput", 
		   	[O,WoL],
		   	false,
			function(k, thing, listVar):Void {
				k(listVar.concat([thing]));
			}
		);
		
		first = new LogoFunction(
		  	"first", 
		   	[WoL],
		   	false,
			function(k, listVar):Void {
				k(elem(listVar, 0));
			}
		);
		
		butfirst = new LogoFunction(
		  	"butfirst", 
		   	[WoL],
		   	false,
			function(k, listVar):Void {
				k(listVar.slice(1));
			}
		);
		
		last = new LogoFunction(
		  	"last", 
		   	[WoL],
		   	false,
			function(k, listVar):Void {
				k(elem(listVar, listVar.length-1));
			}
		);
		
		butlast = new LogoFunction(
		  	"butlast", 
		   	[WoL],
		   	false,
			function(k, listVar):Void {
				k(listVar.slice(0, -1));
			}
		);
		
		item = new LogoFunction(
		  	"item", 
		   	[WoL],
		   	false,
			function(k, i, listVar):Void {
				k(elem(listVar, i-1));
			}
		);
		
		empty = new LogoFunction(
		  	"empty", 
		   	[L],
		   	false,
			function(k, listVar):Void {
				k(listVar.length == 0);
			}
		);
		
		member = new LogoFunction(
		  	"member", 
		   	[O,WoL],
		   	false,
			function(k, v, listVar):Void {
				var result = false;
				for (var i = 0; i<listVar.length; i++) {
					//trace("v="+v + " list="+listVar);
					if (isEqual(v, elem(listVar, i))) {
						//trace(v + " in " + listVar + " slice="+listVar.slice(i,i+1));
						result = true;
					}
					/*
					else {
						trace(v + " not in " + listVar + " slice="+elem(listVar, i));
					}
					*/
				}
				k(result);
			}
		);
		
		// create list
		list = new LogoFunction(
		  	"list", 
		   	[O,O],
		   	true,
			function(k, first, second):Void {
				var rv:Array = [];
				//trace("list " + arguments);
				for (var i = 1; i<arguments.length; i++) {
					rv.push(arguments[i]);
				}
				k(rv);
			}
		);
		
		// word operations
		word = new LogoFunction(
		  	"word", 
		   	[W,W],
		   	true,
			function(k:Function, first, second):Void {
				var rv = arguments[1];
				for (var i = 2; i<arguments.length; i++) {
					rv = rv+arguments[i];
				}
				k(rv);
			}
		);
		
		sentence = new LogoFunction(
		  	"se", 
		   	[O,O],
		   	true,
			function(k, first, second):Void {
				var rv = [];
				var arg;
				for (var i = 1; i<arguments.length; i++) {
					arg = arguments[i];
					if (arg instanceof Array) {
						rv = rv.concat(arg);
					} else {
						// should we use arg.toString() here? MSWLogo probably doesn't.
						rv.push(arg);
					}
				}
				k(rv);
			}
		);

	}
	
	function addAliases():Void {
		// assign aliases
		for(var fn:String in this) {
			var f:LogoFunction = LogoFunction(this[fn]);
			if(f != null) {
				this[f.name] = f;
				this[f.name.toUpperCase()]=f;
			}
		}
	}
	//
	// utility functions
	//
	function arity(name:String):Number {
		return this[name].logoArity;
	}
	function isList(listVar):Boolean {
		return listVar instanceof Array;
	}
	function isWord(w):Boolean {
		return typeof w == 'string';
	}
	function isNumber(n):Boolean {
		return typeof n == 'number';
	}
	function elem(listVar, n:Number):Object {
		return isList(listVar) ? listVar[n] : listVar.charAt(n);
	}
	private function isEqual(a, b):Boolean {
		return a.valueOf() == b.valueOf();
	}
	private function msg(s:String):Void {
		evaluator.transcript.print(s);
	}
	private function abort(s:String):Void {
		evaluator.abort(s);
	}
	//
	// UNported logo primitives
	//
	/*
	function If(k, bool, listVar):Void {
		if (bool) {
			this["run"](k, listVar);
		} else {
			k.call(k.thisObject);
		}
	}
	function ifelse(k, bool, yes, no):Void {
		if (bool) {
			this["run"](k, yes);
		} else {
			this["run"](k, no);
		}
	}
	// numeric operations
	function minus(k, a):Void {
		k(-a);
	}
	function difference(k, a, b):Void {
		k(a-b);
	}
	function product(k, a, b):Void {
		k(a*b);
	}
	function quotient(k, a, b):Void {
		k(a/b);
	}
	function equalp(k, a, b):Void {
		k(isEqual(a, b));
	}
	function lessp(k, a, b):Void {
		k(a<b);
	}
	function greaterp(k, a, b):Void {
		k(a>b);
	}
	// arithmetic functions
	function floor(k, a):Void {
		k(Math.floor(a));
	}
	// list operations
	function fput(k, thing, listVar):Void {
		k([thing].concat(listVar));
	}
	function lput(k, thing, listVar):Void {
		k(listVar.concat([thing]));
	}
	function first(k, listVar):Void {
		k(elem(listVar, 0));
	}
	function butfirst(k, listVar):Void {
		k(listVar.slice(1));
	}
	function last(k, listVar):Void {
		k(elem(listVar, listVar.length-1));
	}
	function butlast(k, listVar):Void {
		k(listVar.slice(0, -1));
	}
	function item(k, i, listVar):Void {
		k(elem(listVar, i-1));
	}
	function empty(k, listVar):Void {
		k(listVar.length == 0);
	}
	function member(k, v, listVar):Void {
		var result = false;
		for (var i = 0; i<listVar.length; i++) {
			//trace("v="+v + " list="+listVar);
			if (isEqual(v, elem(listVar, i))) {
				//trace(v + " in " + listVar + " slice="+listVar.slice(i,i+1));
				result = true;
			}
		}
		k(result);
	}
	function list(k, first, second):Void {
		var rv:Array = [];
		for (var i = 1; i<arguments.length; i++) {
			rv.push(arguments[i]);
		}
		k(rv);
	}
	// word operations
	function word(k:Function, first:String, second):Void {
		var rv = arguments[1];
		for (var i = 2; i<arguments.length; i++) {
			rv = rv+arguments[i];
		}
		k(rv);
	}
	function sentence(k, first, second):Void {
		var rv = [];
		var arg;
		for (var i = 1; i<arguments.length; i++) {
			arg = arguments[i];
			if (arg instanceof Array) {
				rv = rv.concat(arg);
			} else {
				rv.push(arg.toString());
			}
		}
		k(rv);
	}
	*/
	// debugging
	private function addTrace(procname:String):Void {
		if(procname[0]=='"') {
			procname = procname.slice(1);
		}
		var fn:LogoFunction = LogoFunction(this[procname]);
		fn.traced = true;
		tracedprocs[procname]=fn;
	}
	
}
