﻿/* Import the packages so they can be referenced 
   from this class directly. */
import mx.core.UIComponent;
import mx.controls.Label;
import mx.controls.TextArea;
import mx.containers.ScrollPane;
import mx.controls.Button;
import mx.managers.DepthManager;
import Popup;

// Event metadata tag 
class Output extends Popup {

	static var symbolName:String = "Output";
	static var symbolOwner:Object = Output;
	var className:String = "Output";

	var getCode:Function; // call to get initial code.
	
	var clear_btn:Button;
	
	private var _logo:Evaluator;
	
	public function init() {
		super.init();
		__code = (getCode == null)? "" : getCode();
	}
	
	public function createChildren():Void {
		
		super.createChildren();
		
		clear_btn = Button(createClassChildAtDepth(Button, DepthManager.kTop,{_x:5,_y:textBox._y+textBox.height+5}));
		clear_btn.setSize(50,22);
		clear_btn.label = "Clear";
		clear_btn.tabIndex = 2;
		clear_btn.addEventListener("click", this);
		
		minWidth = Math.max(minWidth, 10+clear_btn._width);
		
		size();
	}

	function draw():Void {
		super.draw();
		clear_btn.visible = !minimised;
	}

	function size():Void {
		super.size();
		textBox.setSize(width-10,height-50);
		clear_btn.move(5,textBox._y+textBox.height+5);
	}

	//
	// Button clicks come in here
	//
	public function click(evt){
		switch(evt.target) {
			case clear_btn: 
				// Update the member variables with the input field contents.
				code = "";
				_logo.transcript.clear();
				break;
		}
	}

	// setters and getters
	function set evaluator(logo:Evaluator):Void {
		_logo = logo;
	}

}