﻿function Reader(str) {
	this.str = str;
}

Reader.read = function(str) {
	reader = new Reader(str);
	return reader.read();
}

Reader.prototype.read = function() {
	var list;
	this.str = this.str.replace(/\s*(\[|\]|\(|\)|\+|\-|\*|\/|\=|\<|\>)\s*/g, ' $1 ');
	list = this.transpose(this.str.split(/\s+/));
	return this.readOnce(list);
}

Reader.prototype.transpose = function(list) {
	var result = new Array(list.length);
	for (i=0; i<list.length; i++) {
		each = list[i];
		if (each.length == 0) continue;
		else if (/\+|\*|\/|\-|\=|\<|\>/.test(each)) {
			result[i] = result[i-1];
			result[i-1] = each;
		} else {result[i] = each};
	}
	return result;
}

Reader.prototype.readOnce = function(list) {
   var result = [];
	while(list.length > 0)
	{
		var next = list.shift();
		if(next !== undefined && next.length > 0)
		{
			if(next == "[")
				result[result.length] = this.readOnce(list);
			else if(next == "]")
				return result;
			else if(new Number(next).toString() != "NaN")
				result[result.length] = new Number(next);
			else
				result[result.length] = new String(next);
		}
	}
	return result;
}


function Evaluator(turtle, transcript)
{
	this.functions = new Namespace(page);
	this.definitions = this.functions.parent;
	this.variables = new Namespace();
	
	this.addPrimitives(this.functions);

	this.scheduler = new Scheduler();
	this.scheduler.addPrimitives(this.functions);
	
	if (turtle != null)
	{
		turtle.addPrimitives(this.functions);
	}
	
	if (transcript != null)
	{
		this.transcript = transcript;
		transcript.addPrimitives(this.functions);	
	}
	
	this.assignArity(this.functions);
}

// Core evaluation functions, CPS style

Evaluator.prototype.run = function(list, k)
{
	var self = this;
	if(list.length > 0)
		this.runOnce(list, function(v){self.run(list, function(){k(v)})});
	else
		this.cont(k);
}

Evaluator.prototype.runOnce = function(list, k)
{
	var next = list.shift();
	if (next instanceof String)
	{
		if (next.slice(0,1) == '"')
			k(next.slice(1));
		else if (next.slice(0,1) == ":") 
			k(this.variables[next.slice(1)])
		else if (next == 'to')
			this.defineFunction(list, k);
		else if (next == '(')
			this.callParenthesis(list, k);
		else if (next == ')')
			k(next)
		else 
			this.callFunction(next, list, k);				
	} else k(next);
}

Evaluator.prototype.defineFunction = function(list, k)
{
	var name = list.shift();
	var next = list.shift();
	var args = [];
	while (next.slice(0,1) == ':')
	{
		args.push(next.slice(1));
		next = list.shift();
	}
	var content = [];
	while (next != 'end')
	{
		content.push(next);
		next = list.shift();
	}
	
	var self = this;
	var fn = function()
	{
		// should call Primitive.run
		if(run != primitives.run) {
			trace("bad primitive run");
		}
		
		run(
			arguments[0],
			[].concat(content)
		);
		
	}
	fn.logoArity = args.length;
	fn.logoArguments = args;
	this.definitions[name] = fn;
	this.cont(k);
}

Evaluator.prototype.callParenthesis = function(list, k)
{
	var name = list.shift();
	var fun = this.findFunction(name);
	if (fun == undefined) return;
	
	var self = this;
	var args = [];
	
	var process_arg = function(v, kk)
	{
		if (v == ")")
		{
			self.executeFunction(fun, args, k);
		} else {
			args.push(v);
			self.cont(kk);
		}
	}
	
	var fetchArgs = function()
	{
		self.runOnce(list, function(v)
		{process_arg(v, fetchArgs)})
	}

	fetchArgs();
}

Evaluator.prototype.callFunction = function(name, list, k)
{
	var fun = this.findFunction(name);
	if (fun == undefined) return;

	var self = this;
	var args = [];
	
	var fetchArg = function(n, kk)
	{
		var kkk = function(v)
		{
			args.push(v); 
			fetchArg(n-1, kk)
		}
		
		if (n == 0) kk()
		else self.runOnce(list, kkk)
	}
	
	fetchArg(
		fun.logoArity, 
		function()
		{self.executeFunction(fun, args, k)}
	)
}

Evaluator.prototype.executeFunction = function(fn, args, k)
{
	var self = this;
	var keep = self.variables;

	self.variables = new Namespace(self.variables);
	if (fn.logoArguments !== undefined)
		for (var i=0; i<fn.logoArguments.length; i++)
		{
			self.variables[fn.logoArguments[i]] = args[i];
		}
			
	var kk = function (v)
	{self.variables = keep; k(v)}
	self.scheduler.apply(self.functions, fn, args, kk);
}

// Utility functions, not in CPS style

Evaluator.prototype.cont = function(k)
{
  this.scheduler.cont(k)
}

Evaluator.prototype.addPrimitives = function(obj)
{
	var self = this;

	obj.run = function(k, list)
	{
		var copy = [].concat(list);
		self.setEscape(k);
		self.run(copy, k)
	}
	
	obj.make = function(k, name, val)
	{
		k(self.variables.parent[name] = val)
	}

}

Evaluator.prototype.assignArity = function(obj)
{
	for (var p in obj)
	{
		var fn = obj[p];
		if (fn instanceof Function) fn.logoArity = fn.length - 1;
	}
}

Evaluator.prototype.eval = function(str)
{
	var self = this;
	var list = Reader.read(str);
	trace(list);
	this.scheduler.go();
	this.scheduler.run(function() {
								self.run(list, function(v){})
								});
}

Evaluator.prototype.findFunction = function(name)
{
	var fun = this.functions[name];
	
	if (fun === undefined)
	{
		this.scheduler.stop();
		var msg = "function '" + name + "' is undefined"
		if (this.transcript != null) this.transcript.print(msg)
		else St.log(msg);
	}
	return fun;
}

Evaluator.prototype.setEscape = function(k)
{
	this.functions['return'] = function(kk, v)
	{k(v)};
	this.functions['return'].logoArity = 1;
}

Evaluator.prototype.inherit = function(obj)
{
	var constructor = function ()
	{};
	constructor.prototype = obj;
	return new constructor();
}

Evaluator.prototype.exportFunctions = function(bool)
{
  if (bool) this.definitions = this.functions.parent;
  else this.definitions = this.functions;
}

Evaluator.prototype.areFunctionsExported = function()
{
  return this.definitions === this.functions.parent;
}


function Scheduler() 
{
	this.running = true;
	Scheduler.instances.push(this);
}
Scheduler.prototype.speed = 2;
Scheduler.instances = [];

Scheduler.prototype.go = function()
{
	this.running = true
}

Scheduler.prototype.stop = function() 
{
	this.running = false;
}

Scheduler.prototype.run = function(main) 
{
	this.k = undefined;
	main();
	while (this.running && this.k !== undefined) {
		var k = this.k;
		this.k = undefined;
		k();
	}
}

Scheduler.prototype.cont = function(k) 
{
	this.k = k;
}

Scheduler.prototype.apply = function(obj, fn, args, k) 
{
	var all = [k].concat(args);
	this.k = function() {fn.apply(obj, all)}
}

Scheduler.prototype.delay = function(n, k) 
{
	var self = this;
	if (this.speed < 1)
  {
    this.cont(k);
  }
  else if (this.running) 
  {
    var kk = function() {self.run(k)}
		window.setTimeout(kk, Math.abs(n/this.speed));	
  }
}

Scheduler.prototype.addPrimitives = function(obj) 
{
	var self = this;
	obj.delay = function(k, n) {
		self.delay(n, k);
	}	
}

Scheduler.stop = function() 
{
	for (var p in this.instances) this.instances[p].stop();
}


Namespace = function(parent)
{
	var constructor = function ()
	{};
	constructor.prototype = parent;
	var child = new constructor();
	child.parent = parent;
	return child
};

var primitives = new Object();
var page = new Namespace(primitives);

primitives.repeat = function(k, n, list)
{
	if(n == 0) k()
	else {
		var self = this;
		this.run(function(v){self.repeat(k, n-1, list)}, list);
	}
}
	
primitives['if'] = function(k, bool, list)
{
	if (bool) this.run(k, list)
	else k()
}

primitives.ifelse = function(k, bool, yes, no)
{
	if (bool) this.run(k, yes)
	else this.run(k, no)
}

// numeric operations
primitives['+'] = function(k, a, b) {k(a + b)}
primitives['-'] = function(k, a, b) {k(a - b)}
primitives['*'] = function(k, a, b) {k(a * b)}
primitives['/'] = function(k, a, b) {k(a / b)}
primitives['='] = function(k, a, b) {k( equals(a,b) )}
primitives['<'] = function(k, a, b) {k(a < b)}
primitives['>'] = function(k, a, b) {k(a > b)}

// list operations
primitives.fput = function(k, thing, list) {k([thing].concat(list))}
primitives.lput = function(k, thing, list) {k(list.concat([thing]))}
primitives.first = function(k, list) {k(list[0])}
primitives.butfirst = function(k, list) {k(list.slice(1))}
primitives.last = function(k, list) {k(list[list.length - 1])}
primitives.butlast = function(k, list) {k(list.slice(0,-1))}
primitives.item = function(k, i, list) {k(list[i - 1])}
primitives.empty = function(k, list) {k(list.length == 0)}
primitives.member = function(k, v, list)
{
	var result = false;
	for (var i =0; i < list.length; i++)
	{
		if ( equals(v, list[i]) ) result = true;
	}
	k(result)
}

primitives.list = function (k, first, second)
{
	var list = [];
	for (var i=1; i<arguments.length; i++) list.push(arguments[i]);
	k(list);
}

// word operations
primitives.word = function (k, first, second)
{
	var word = arguments[1];
	for (var i=2; i<arguments.length; i++) word = word + arguments[i];
	k(word);
}

primitives.sentence = function(k, first, second)
{
	var sentence = [];
	var arg;
	for (var i=1; i<arguments.length; i++)
	{
		arg = arguments[i];
		if (typeof arg == 'array') sentence.concat(arg)
		else sentence.push(arg.toString());
	}
	k(sentence)
}

// convenience
primitives.left = function(k, n) {this.right(k, 360 - n)}
primitives.lt = primitives.left;

function equals(a, b)
{
	return a.valueOf() == b.valueOf();
} 

